/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.NaturesAura;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.blocks.BlockFurnaceHeater;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityImpl;
import de.ellpeck.naturesaura.blocks.tiles.ITickableBlockEntity;
import de.ellpeck.naturesaura.blocks.tiles.ModBlockEntities;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticleStream;
import java.lang.reflect.Field;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlastFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SmokerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class BlockEntityFurnaceHeater
extends BlockEntityImpl
implements ITickableBlockEntity {
    private static final Field FURNACE_DATA_FIELD = ObfuscationReflectionHelper.findField(AbstractFurnaceBlockEntity.class, (String)"f_58311_");
    public boolean isActive;

    public BlockEntityFurnaceHeater(BlockPos pos, BlockState state) {
        super(ModBlockEntities.FURNACE_HEATER, pos, state);
    }

    public static ContainerData getFurnaceData(AbstractFurnaceBlockEntity tile) {
        try {
            return (ContainerData)FURNACE_DATA_FIELD.get(tile);
        }
        catch (IllegalAccessException e) {
            NaturesAura.LOGGER.fatal("Couldn't reflect furnace field", (Throwable)e);
            return null;
        }
    }

    public static RecipeType<? extends AbstractCookingRecipe> getRecipeType(AbstractFurnaceBlockEntity furnace) {
        if (furnace instanceof BlastFurnaceBlockEntity) {
            return RecipeType.f_44109_;
        }
        if (furnace instanceof SmokerBlockEntity) {
            return RecipeType.f_44110_;
        }
        return RecipeType.f_44108_;
    }

    @Override
    public void tick() {
        if (!this.f_58857_.f_46443_ && this.f_58857_.m_46467_() % 5L == 0L) {
            AbstractFurnaceBlockEntity furnace;
            boolean did = false;
            Direction facing = (Direction)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)BlockFurnaceHeater.FACING);
            BlockPos tilePos = this.f_58858_.m_142300_(facing.m_122424_());
            BlockEntity tile = this.f_58857_.m_7702_(tilePos);
            if (tile instanceof AbstractFurnaceBlockEntity && this.isReady(furnace = (AbstractFurnaceBlockEntity)tile)) {
                ContainerData data = BlockEntityFurnaceHeater.getFurnaceData(furnace);
                int burnTime = data.m_6413_(0);
                if (burnTime <= 0) {
                    this.f_58857_.m_46597_(tilePos, (BlockState)this.f_58857_.m_8055_(tilePos).m_61124_((Property)AbstractFurnaceBlock.f_48684_, (Comparable)Boolean.valueOf(true)));
                }
                data.m_8050_(0, 200);
                data.m_8050_(2, Math.min(data.m_6413_(3) - 1, data.m_6413_(2) + 5));
                BlockPos spot = IAuraChunk.getHighestSpot(this.f_58857_, this.f_58858_, 20, this.f_58858_);
                IAuraChunk chunk = IAuraChunk.getAuraChunk(this.f_58857_, spot);
                chunk.drainAura(spot, Mth.m_14167_((float)((float)(200 - burnTime) * 16.6f)));
                did = true;
                if (this.f_58857_.m_46467_() % 15L == 0L) {
                    PacketHandler.sendToAllAround(this.f_58857_, this.f_58858_, 32, new PacketParticleStream((float)this.f_58858_.m_123341_() + (float)this.f_58857_.f_46441_.nextGaussian() * 5.0f, (float)(this.f_58858_.m_123342_() + 1) + this.f_58857_.f_46441_.nextFloat() * 5.0f, (float)this.f_58858_.m_123343_() + (float)this.f_58857_.f_46441_.nextGaussian() * 5.0f, (float)tilePos.m_123341_() + this.f_58857_.f_46441_.nextFloat(), (float)tilePos.m_123342_() + this.f_58857_.f_46441_.nextFloat(), (float)tilePos.m_123343_() + this.f_58857_.f_46441_.nextFloat(), this.f_58857_.f_46441_.nextFloat() * 0.07f + 0.07f, IAuraType.forLevel(this.f_58857_).getColor(), this.f_58857_.f_46441_.nextFloat() + 0.5f));
                }
            }
            if (did != this.isActive) {
                this.isActive = did;
                this.sendToClients();
            }
        }
    }

    private boolean isReady(AbstractFurnaceBlockEntity furnace) {
        if (!furnace.m_8020_(1).m_41619_()) {
            return false;
        }
        ItemStack input = furnace.m_8020_(0);
        if (!input.m_41619_()) {
            AbstractCookingRecipe recipe = this.f_58857_.m_7465_().m_44015_(BlockEntityFurnaceHeater.getRecipeType(furnace), (Container)furnace, this.f_58857_).orElse(null);
            if (recipe == null) {
                return false;
            }
            ItemStack output = recipe.m_8043_();
            ItemStack currOutput = furnace.m_8020_(2);
            return currOutput.m_41619_() || Helper.areItemsEqual(currOutput, output, true) && currOutput.m_41613_() + output.m_41613_() <= output.m_41741_();
        }
        return false;
    }

    @Override
    public void writeNBT(CompoundTag compound, BlockEntityImpl.SaveType type) {
        super.writeNBT(compound, type);
        if (type == BlockEntityImpl.SaveType.SYNC) {
            compound.m_128379_("active", this.isActive);
        }
    }

    @Override
    public void readNBT(CompoundTag compound, BlockEntityImpl.SaveType type) {
        super.readNBT(compound, type);
        if (type == BlockEntityImpl.SaveType.SYNC) {
            this.isActive = compound.m_128471_("active");
        }
    }
}

