/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.misc.ILevelData;
import de.ellpeck.naturesaura.api.render.IVisualizable;
import de.ellpeck.naturesaura.blocks.BlockContainerImpl;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntitySpawnLamp;
import de.ellpeck.naturesaura.data.BlockStateGenerator;
import de.ellpeck.naturesaura.misc.LevelData;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import de.ellpeck.naturesaura.reg.ICustomBlockState;
import de.ellpeck.naturesaura.reg.ICustomRenderType;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BlockSpawnLamp
extends BlockContainerImpl
implements IVisualizable,
ICustomBlockState,
ICustomRenderType {
    private static final VoxelShape SHAPE = Shapes.m_166049_((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.8125, (double)0.75);

    public BlockSpawnLamp() {
        super("spawn_lamp", BlockEntitySpawnLamp.class, BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60978_(3.0f).m_60953_(s -> 15).m_60918_(SoundType.f_56743_));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    protected boolean hasWaterlogging() {
        return true;
    }

    @SubscribeEvent
    public void onSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (event.getSpawner() != null) {
            return;
        }
        LevelAccessor level = event.getWorld();
        BlockPos pos = new BlockPos(event.getX(), event.getY(), event.getZ());
        if (!(level instanceof Level)) {
            return;
        }
        LevelData data = (LevelData)ILevelData.getLevelData((Level)level);
        for (BlockEntitySpawnLamp lamp : data.spawnLamps) {
            BlockPos lampPos;
            int range;
            if (lamp.m_58901_() || (range = lamp.getRadius()) <= 0 || !new AABB(lampPos = lamp.m_58899_()).m_82400_((double)range).m_82390_(new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5))) continue;
            Mob entity = (Mob)event.getEntityLiving();
            if (entity.m_5545_(level, event.getSpawnReason()) && entity.m_6914_((LevelReader)level)) {
                BlockPos spot = IAuraChunk.getHighestSpot((Level)level, lampPos, 32, lampPos);
                IAuraChunk.getAuraChunk((Level)level, spot).drainAura(spot, 200);
                PacketHandler.sendToAllAround((Level)((ServerLevel)level), lampPos, 32, new PacketParticles(lampPos.m_123341_(), lampPos.m_123342_(), lampPos.m_123343_(), PacketParticles.Type.SPAWN_LAMP, new int[0]));
            }
            event.setResult(Event.Result.DENY);
            break;
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter levelIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public AABB getVisualizationBounds(Level level, BlockPos pos) {
        int radius;
        BlockEntity tile = level.m_7702_(pos);
        if (tile instanceof BlockEntitySpawnLamp && (radius = ((BlockEntitySpawnLamp)tile).getRadius()) > 0) {
            return new AABB(pos).m_82400_((double)radius);
        }
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getVisualizationColor(Level level, BlockPos pos) {
        return 8543973;
    }

    @Override
    public void generateCustomBlockState(BlockStateGenerator generator) {
        generator.simpleBlock((Block)this, (ModelFile)generator.models().getExistingFile(generator.modLoc(this.getBaseName())));
    }

    @Override
    public Supplier<RenderType> getRenderType() {
        return RenderType::m_110457_;
    }
}

