/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.gui.framework.widgets;

import com.davenonymous.libnonymous.gui.framework.SmartNumberFormatter;
import com.davenonymous.libnonymous.gui.framework.widgets.WidgetWithValue;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.client.gui.GuiUtils;

public class WidgetProgressBar
extends WidgetWithValue<Double> {
    int borderColor = -16777216;
    int foregroundColor = -13391309;
    int backgroundColor = -13421773;
    int textColor = -1;
    double rangeMin = 0.0;
    double rangeMax = 100.0;
    EnumDisplayMode displayMode = EnumDisplayMode.PERCENTAGE;

    public WidgetProgressBar() {
        this.value = 0.0;
    }

    public int getBorderColor() {
        return this.borderColor;
    }

    public WidgetProgressBar setBorderColor(int borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    public int getForegroundColor() {
        return this.foregroundColor;
    }

    public WidgetProgressBar setForegroundColor(int foregroundColor) {
        this.foregroundColor = foregroundColor;
        return this;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public WidgetProgressBar setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public WidgetProgressBar setTextColor(int textColor) {
        this.textColor = textColor;
        return this;
    }

    public double getRangeMin() {
        return this.rangeMin;
    }

    public WidgetProgressBar setRangeMin(double rangeMin) {
        this.rangeMin = rangeMin;
        return this;
    }

    public double getRangeMax() {
        return this.rangeMax;
    }

    public WidgetProgressBar setRangeMax(double rangeMax) {
        this.rangeMax = rangeMax;
        return this;
    }

    public EnumDisplayMode getDisplayMode() {
        return this.displayMode;
    }

    public WidgetProgressBar setDisplayMode(EnumDisplayMode displayMode) {
        this.displayMode = displayMode;
        return this;
    }

    @Override
    public void draw(PoseStack pPoseStack, Screen screen) {
        int x = 0;
        int y = 0;
        int width = this.width;
        int height = this.height;
        GuiUtils.drawGradientRect((Matrix4f)pPoseStack.m_85850_().m_85861_(), (int)0, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)this.borderColor, (int)this.borderColor);
        GuiUtils.drawGradientRect((Matrix4f)pPoseStack.m_85850_().m_85861_(), (int)0, (int)(x + 1), (int)(y + 1), (int)(x + width - 1), (int)(y + height - 1), (int)this.backgroundColor, (int)this.backgroundColor);
        double progress = ((Double)this.getValue() - this.getRangeMin()) / (this.getRangeMax() - this.getRangeMin());
        progress = Math.min(Math.max(progress, 0.0), 1.0);
        int progressWidth = (int)(Math.ceil((double)width - 2.0) * progress);
        GuiUtils.drawGradientRect((Matrix4f)pPoseStack.m_85850_().m_85861_(), (int)0, (int)(x + 1), (int)(y + 1), (int)(x + 1 + progressWidth), (int)(y + height - 1), (int)this.foregroundColor, (int)this.foregroundColor);
        if (this.displayMode != EnumDisplayMode.NOTHING && this.displayMode != EnumDisplayMode.CUSTOM) {
            Font fr = screen.getMinecraft().f_91062_;
            String content = "";
            if (this.displayMode == EnumDisplayMode.PERCENTAGE) {
                content = String.format("%.1f%%", progress * 100.0);
            } else if (this.displayMode == EnumDisplayMode.VALUE) {
                content = String.valueOf(SmartNumberFormatter.formatNumber((Double)this.getValue()));
            } else if (this.displayMode == EnumDisplayMode.VALUE_AND_PERCENTAGE) {
                content = String.format("%.1f%% (%s)", progress * 100.0, SmartNumberFormatter.formatNumber((Double)this.getValue()));
            }
            int xPos = x + 1 + (width - fr.m_92895_(content)) / 2;
            Objects.requireNonNull(fr);
            int yPos = y + (height + 4 - 9) / 2;
            fr.m_92883_(pPoseStack, content, (float)xPos, (float)yPos, this.textColor);
        }
    }

    public static enum EnumDisplayMode {
        NOTHING,
        VALUE,
        PERCENTAGE,
        VALUE_AND_PERCENTAGE,
        CUSTOM;

    }
}

