/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.gui.framework;

import com.davenonymous.libnonymous.gui.framework.GUIHelper;
import com.davenonymous.libnonymous.gui.framework.WidgetContainer;
import com.davenonymous.libnonymous.gui.framework.WidgetSlot;
import com.davenonymous.libnonymous.gui.framework.widgets.IValueProvider;
import com.davenonymous.libnonymous.gui.framework.widgets.Widget;
import com.davenonymous.libnonymous.gui.framework.widgets.WidgetPanel;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.client.gui.GuiUtils;

public class GUI
extends WidgetPanel {
    public static ResourceLocation tabIcons = new ResourceLocation("libnonymous", "textures/gui/tabicons.png");
    public static ResourceLocation defaultButtonTexture = new ResourceLocation("libnonymous", "textures/gui/button_background.png");
    public boolean hasTabs = false;
    private Map<ResourceLocation, IValueProvider> valueMap = new HashMap<ResourceLocation, IValueProvider>();
    private WidgetContainer container;

    public GUI(int x, int y, int width, int height) {
        this.setX(x);
        this.setY(y);
        this.setWidth(width);
        this.setHeight(height);
    }

    public void findValueWidgets() {
        this.findValueWidgets(this);
    }

    public void registerValueWidget(ResourceLocation id, IValueProvider widget) {
        this.valueMap.put(id, widget);
    }

    public Object getValue(ResourceLocation id) {
        if (id == null || !this.valueMap.containsKey(id)) {
            return null;
        }
        return this.valueMap.get(id).getValue();
    }

    public void drawGUI(PoseStack pPoseStack, Screen screen) {
        this.setX((screen.f_96543_ - this.width) / 2);
        this.setY((screen.f_96544_ - this.height) / 2);
        this.shiftAndDraw(pPoseStack, screen);
    }

    @Override
    public void drawBeforeShift(PoseStack pPoseStack, Screen screen) {
        super.drawBeforeShift(pPoseStack, screen);
    }

    @Override
    public void draw(PoseStack pPoseStack, Screen screen) {
        this.drawWindow(pPoseStack, screen);
        super.draw(pPoseStack, screen);
    }

    protected void drawWindow(PoseStack pPoseStack, Screen screen) {
        int texOffsetY = 11;
        int texOffsetX = 64;
        int width = this.width;
        int xOffset = 0;
        if (this.hasTabs) {
            width -= 32;
            xOffset += 32;
        }
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)tabIcons);
        GuiUtils.drawTexturedModalRect((PoseStack)pPoseStack, (int)xOffset, (int)0, (int)texOffsetX, (int)texOffsetY, (int)4, (int)4, (float)0.0f);
        GuiUtils.drawTexturedModalRect((PoseStack)pPoseStack, (int)(xOffset + width - 4), (int)0, (int)(texOffsetX + 4 + 64), (int)texOffsetY, (int)4, (int)4, (float)0.0f);
        GuiUtils.drawTexturedModalRect((PoseStack)pPoseStack, (int)xOffset, (int)(this.height - 4), (int)texOffsetX, (int)(texOffsetY + 4 + 64), (int)4, (int)4, (float)0.0f);
        GuiUtils.drawTexturedModalRect((PoseStack)pPoseStack, (int)(xOffset + width - 4), (int)(this.height - 4), (int)(texOffsetX + 4 + 64), (int)(texOffsetY + 4 + 64), (int)4, (int)4, (float)0.0f);
        GUIHelper.drawStretchedTexture(pPoseStack, xOffset + 4, 0, width - 8, 4, texOffsetX + 4, texOffsetY, 64, 4);
        GUIHelper.drawStretchedTexture(pPoseStack, xOffset + 4, this.height - 4, width - 8, 4, texOffsetX + 4, texOffsetY + 4 + 64, 64, 4);
        GUIHelper.drawStretchedTexture(pPoseStack, xOffset, 4, 4, this.height - 8, texOffsetX, texOffsetY + 4, 4, 64);
        GUIHelper.drawStretchedTexture(pPoseStack, xOffset + width - 4, 4, 4, this.height - 8, texOffsetX + 64 + 4, texOffsetY + 3, 4, 64);
        GUIHelper.drawStretchedTexture(pPoseStack, xOffset + 4, 4, width - 8, this.height - 8, texOffsetX + 4, texOffsetY + 4, 64, 64);
    }

    public void drawTooltips(PoseStack pPoseStack, Screen screen, int mouseX, int mouseY) {
        Widget hoveredWidget = this.getHoveredWidget(mouseX, mouseY);
        Font font = screen.getMinecraft().f_91062_;
        if (hoveredWidget != null && hoveredWidget.getTooltip() != null && hoveredWidget.getTooltip().size() > 0) {
            screen.renderTooltip(pPoseStack, hoveredWidget.getTooltipAsFormattedCharSequence(), mouseX, mouseY, font);
        }
    }

    public void drawSlot(PoseStack pPoseStack, Screen screen, Slot slot, int guiLeft, int guiTop) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (slot instanceof WidgetSlot && !slot.m_150651_((Player)screen.getMinecraft().f_91074_)) {
            RenderSystem.m_157429_((float)1.0f, (float)0.3f, (float)0.3f, (float)1.0f);
        }
        float offsetX = guiLeft - 1;
        float offsetY = guiTop - 1;
        pPoseStack.m_85836_();
        pPoseStack.m_85837_((double)offsetX, (double)offsetY, 0.0);
        int texOffsetY = 84;
        int texOffsetX = 84;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)tabIcons);
        GuiUtils.drawTexturedModalRect((PoseStack)pPoseStack, (int)slot.f_40220_, (int)slot.f_40221_, (int)texOffsetX, (int)texOffsetY, (int)18, (int)18, (float)0.0f);
        pPoseStack.m_85849_();
    }

    public void setContainer(WidgetContainer container) {
        this.container = container;
    }

    public WidgetContainer getContainer() {
        return this.container;
    }
}

