/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.colytra.common;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import top.theillusivec4.colytra.server.ColytraServerConfig;

public class ElytraTag {
    public static final String ELYTRA_TAG = "colytra:ElytraUpgrade";

    public static boolean hasUpgrade(ItemStack stack) {
        return stack.m_41737_(ELYTRA_TAG) != null;
    }

    public static ItemStack getElytra(ItemStack stack) {
        CompoundTag tag = stack.m_41737_(ELYTRA_TAG);
        return tag != null ? ItemStack.m_41712_((CompoundTag)tag) : ItemStack.f_41583_;
    }

    public static void setElytra(ItemStack chestStack, ItemStack elytraStack) {
        chestStack.m_41784_().m_128365_(ELYTRA_TAG, (Tag)elytraStack.m_41739_(new CompoundTag()));
    }

    public static void damageElytra(LivingEntity livingEntity, ItemStack chestStack, ItemStack elytraStack, int amount) {
        ColytraServerConfig.ColytraMode colytraMode = ColytraServerConfig.colytraMode;
        if (colytraMode == ColytraServerConfig.ColytraMode.NORMAL) {
            elytraStack.m_41622_(amount, livingEntity, damager -> damager.m_21166_(EquipmentSlot.CHEST));
        } else if (colytraMode == ColytraServerConfig.ColytraMode.UNISON) {
            LazyOptional energyStorage = chestStack.getCapability(CapabilityEnergy.ENERGY);
            energyStorage.ifPresent(energy -> energy.extractEnergy(ColytraServerConfig.energyUsage, false));
            if (!energyStorage.isPresent()) {
                chestStack.m_41622_(amount, livingEntity, damager -> damager.m_21166_(EquipmentSlot.CHEST));
            }
        }
        ElytraTag.setElytra(chestStack, elytraStack);
    }

    public static boolean isUseable(ItemStack chestStack, ItemStack elytraStack) {
        if (elytraStack.m_41619_()) {
            return false;
        }
        ColytraServerConfig.ColytraMode colytraMode = ColytraServerConfig.colytraMode;
        if (colytraMode == ColytraServerConfig.ColytraMode.NORMAL) {
            return elytraStack.m_41720_() instanceof ElytraItem && ElytraItem.m_41140_((ItemStack)elytraStack);
        }
        if (colytraMode == ColytraServerConfig.ColytraMode.UNISON) {
            LazyOptional energyStorage = chestStack.getCapability(CapabilityEnergy.ENERGY);
            if (energyStorage.isPresent()) {
                return energyStorage.map(energy -> energy.canExtract() && energy.getEnergyStored() > ColytraServerConfig.energyUsage).orElse(false);
            }
            return !chestStack.m_41763_() || chestStack.m_41773_() < chestStack.m_41776_() - 1;
        }
        return true;
    }
}

