/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.colytra.client;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import top.theillusivec4.caelus.api.RenderCapeEvent;
import top.theillusivec4.colytra.client.ClientEventHandler;
import top.theillusivec4.colytra.client.ColytraLayer;
import top.theillusivec4.colytra.common.ElytraTag;

public class ColytraClientMod {
    public static void setup() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(ColytraClientMod::addLayers);
        MinecraftForge.EVENT_BUS.addListener(ColytraClientMod::renderCape);
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
    }

    private static void addLayers(EntityRenderersEvent.AddLayers evt) {
        ColytraClientMod.addPlayerLayer(evt, "default");
        ColytraClientMod.addPlayerLayer(evt, "slim");
        ColytraClientMod.addEntityLayer(evt, EntityType.f_20529_);
    }

    private static void addPlayerLayer(EntityRenderersEvent.AddLayers evt, String skin) {
        LivingEntityRenderer renderer = evt.getSkin(skin);
        if (renderer instanceof LivingEntityRenderer) {
            LivingEntityRenderer livingRenderer = renderer;
            livingRenderer.m_115326_(new ColytraLayer(livingRenderer, evt.getEntityModels()));
        }
    }

    private static <T extends LivingEntity, M extends HumanoidModel<T>, R extends LivingEntityRenderer<T, M>> void addEntityLayer(EntityRenderersEvent.AddLayers evt, EntityType<? extends T> entityType) {
        LivingEntityRenderer renderer = evt.getRenderer(entityType);
        if (renderer != null) {
            renderer.m_115326_(new ColytraLayer(renderer, evt.getEntityModels()));
        }
    }

    private static void renderCape(RenderCapeEvent evt) {
        if (!ElytraTag.getElytra(evt.getPlayer().m_6844_(EquipmentSlot.CHEST)).m_41619_()) {
            evt.setCanceled(true);
        }
    }
}

