/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.colytra.client;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.colytra.common.ElytraTag;
import top.theillusivec4.colytra.server.ColytraServerConfig;

public class ClientEventHandler {
    private static void getColytraTooltip(ItemStack chestStack, List<Component> tooltip) {
        if (!ElytraTag.hasUpgrade(chestStack)) {
            return;
        }
        ItemStack elytraStack = ElytraTag.getElytra(chestStack);
        if (elytraStack.m_41619_()) {
            return;
        }
        tooltip.add((Component)new TextComponent(""));
        if (elytraStack.m_41788_()) {
            Component display = elytraStack.m_41786_();
            if (display instanceof MutableComponent) {
                ((MutableComponent)display).m_130940_(ChatFormatting.AQUA).m_130940_(ChatFormatting.ITALIC);
            }
            tooltip.add(display);
        } else {
            tooltip.add((Component)new TranslatableComponent("item.minecraft.elytra").m_130940_(ChatFormatting.AQUA));
        }
        if (ColytraServerConfig.colytraMode == ColytraServerConfig.ColytraMode.NORMAL) {
            if (elytraStack.m_41782_()) {
                int i = 0;
                CompoundTag tag = elytraStack.m_41783_();
                if (tag != null && tag.m_128425_("HideFlags", 99)) {
                    i = tag.m_128451_("HideFlags");
                }
                if (!(i & true)) {
                    ListTag nbttaglist = elytraStack.m_41785_();
                    for (int j = 0; j < nbttaglist.size(); ++j) {
                        CompoundTag nbttagcompound = nbttaglist.m_128728_(j);
                        Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(ResourceLocation.m_135820_((String)nbttagcompound.m_128461_("id")));
                        if (enchantment == null) continue;
                        tooltip.add((Component)new TextComponent(" ").m_7220_(enchantment.m_44700_(nbttagcompound.m_128451_("lvl"))));
                    }
                }
            }
            if (ElytraTag.isUseable(chestStack, elytraStack)) {
                tooltip.add((Component)new TextComponent(" ").m_7220_((Component)new TranslatableComponent("item.durability", new Object[]{elytraStack.m_41776_() - elytraStack.m_41773_(), elytraStack.m_41776_()})));
            } else {
                tooltip.add((Component)new TextComponent(" ").m_7220_((Component)new TranslatableComponent("tooltip.colytra.broken").m_130940_(ChatFormatting.RED)));
            }
        }
    }

    @SubscribeEvent
    public void itemTooltip(ItemTooltipEvent evt) {
        ItemStack itemstack = evt.getItemStack();
        List tooltip = evt.getToolTip();
        ClientEventHandler.getColytraTooltip(itemstack, tooltip);
    }
}

