/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.colytra;

import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.colytra.client.ColytraClientMod;
import top.theillusivec4.colytra.common.CommonEventHandler;
import top.theillusivec4.colytra.common.crafting.ElytraAttachmentRecipe;
import top.theillusivec4.colytra.common.crafting.ElytraDetachmentRecipe;
import top.theillusivec4.colytra.common.integration.CyclicClientPlugin;
import top.theillusivec4.colytra.common.integration.CyclicPlugin;
import top.theillusivec4.colytra.server.ColytraServerConfig;

@Mod(value="colytra")
public class Colytra {
    public static final String MOD_ID = "colytra";
    public static final Logger LOGGER = LogManager.getLogger();
    private static final String ATTACH_ELYTRA = "elytra_attachment";
    private static final String DETACH_ELYTRA = "elytra_detachment";

    public Colytra() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::setup);
        eventBus.addListener(this::clientSetup);
        eventBus.addListener(this::config);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ColytraServerConfig.serverSpec);
    }

    private void setup(FMLCommonSetupEvent evt) {
        MinecraftForge.EVENT_BUS.register((Object)new CommonEventHandler());
        if (ModList.get().isLoaded("cyclic")) {
            CyclicPlugin.setup();
        }
    }

    private void clientSetup(FMLClientSetupEvent evt) {
        ColytraClientMod.setup();
        if (ModList.get().isLoaded("cyclic")) {
            CyclicClientPlugin.setup();
        }
    }

    private void config(ModConfigEvent evt) {
        if (evt.getConfig().getModId().equals(MOD_ID) && evt.getConfig().getType() == ModConfig.Type.SERVER) {
            ColytraServerConfig.bake();
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onRecipeSerializerRegistry(RegistryEvent.Register<RecipeSerializer<?>> evt) {
            ElytraAttachmentRecipe.CRAFTING_ATTACH_ELYTRA.setRegistryName(Colytra.ATTACH_ELYTRA);
            ElytraDetachmentRecipe.CRAFTING_DETACH_ELYTRA.setRegistryName(Colytra.DETACH_ELYTRA);
            evt.getRegistry().registerAll((IForgeRegistryEntry[])new RecipeSerializer[]{ElytraAttachmentRecipe.CRAFTING_ATTACH_ELYTRA, ElytraDetachmentRecipe.CRAFTING_DETACH_ELYTRA});
        }
    }
}

