/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.allthemodium.worldgen.structures;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.thevortex.allthemodium.registry.ModRegistry;
import com.thevortex.allthemodium.worldgen.structures.ATMStructures;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.PostPlacementProcessor;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.event.world.StructureSpawnListGatherEvent;

public class APStructure
extends StructureFeature<JigsawConfiguration> {
    private static final Lazy<List<MobSpawnSettings.SpawnerData>> STRUCTURE_MONSTERS = Lazy.of(() -> ImmutableList.of((Object)new MobSpawnSettings.SpawnerData((EntityType)ModRegistry.PIGLICH.get(), 400, 1, 1)));
    private static final Lazy<List<MobSpawnSettings.SpawnerData>> STRUCTURE_CREATURES = Lazy.of(() -> ImmutableList.of((Object)new MobSpawnSettings.SpawnerData(EntityType.f_20517_, 30, 10, 15), (Object)new MobSpawnSettings.SpawnerData(EntityType.f_20549_, 100, 1, 2)));

    public APStructure(Codec<JigsawConfiguration> codec) {
        super(JigsawConfiguration.f_67756_, APStructure::createPiecesGenerator, PostPlacementProcessor.f_192427_);
    }

    private static boolean isFeatureChunk(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        BlockPos blockPos = context.f_197355_().m_45615_();
        BlockPos north = new BlockPos(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_() - 32);
        BlockPos south = new BlockPos(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_() + 32);
        BlockPos east = new BlockPos(blockPos.m_123341_() + 32, blockPos.m_123342_(), blockPos.m_123343_());
        BlockPos west = new BlockPos(blockPos.m_123341_() - 32, blockPos.m_123342_(), blockPos.m_123343_());
        NoiseColumn checkNorth = context.f_197352_().m_141914_(north.m_123341_(), north.m_123343_(), context.f_197357_());
        NoiseColumn checkSouth = context.f_197352_().m_141914_(south.m_123341_(), south.m_123343_(), context.f_197357_());
        NoiseColumn checkEast = context.f_197352_().m_141914_(east.m_123341_(), east.m_123343_(), context.f_197357_());
        NoiseColumn checkWest = context.f_197352_().m_141914_(west.m_123341_(), west.m_123343_(), context.f_197357_());
        int landHeight = context.f_197352_().m_156179_(blockPos.m_123341_(), blockPos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_());
        BlockState stateNorth = checkNorth.m_183556_(landHeight);
        BlockState stateSouth = checkSouth.m_183556_(landHeight);
        BlockState stateEast = checkEast.m_183556_(landHeight);
        BlockState stateWest = checkWest.m_183556_(landHeight);
        NoiseColumn columnOfBlocks = context.f_197352_().m_141914_(blockPos.m_123341_(), blockPos.m_123343_(), context.f_197357_());
        BlockState topBlock = columnOfBlocks.m_183556_(landHeight);
        return topBlock.m_60819_().m_76178_() && !stateNorth.m_60795_() && !stateSouth.m_60795_() && !stateEast.m_60795_() && !stateWest.m_60795_();
    }

    public static Optional<PieceGenerator<JigsawConfiguration>> createPiecesGenerator(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        if (!APStructure.isFeatureChunk(context)) {
            return Optional.empty();
        }
        BlockPos blockpos = context.f_197355_().m_151394_(0);
        int topLandY = context.f_197352_().m_156174_(blockpos.m_123341_(), blockpos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_());
        Optional structurePiecesGenerator = JigsawPlacement.m_210284_(context, PoolElementStructurePiece::new, (BlockPos)(blockpos = blockpos.m_6630_(topLandY)), (boolean)false, (boolean)false);
        if (structurePiecesGenerator.isPresent()) {
            // empty if block
        }
        return structurePiecesGenerator;
    }

    public static void setupStructureSpawns(StructureSpawnListGatherEvent event) {
        if (event.getStructure() == ATMStructures.PYRAMID.get()) {
            event.addEntitySpawns(MobCategory.MONSTER, (List)STRUCTURE_MONSTERS.get());
            event.addEntitySpawns(MobCategory.CREATURE, (List)STRUCTURE_CREATURES.get());
        }
    }

    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }
}

