/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.allthemodium.worldgen.features;

import com.mojang.serialization.Codec;
import com.thevortex.allthemodium.registry.ModRegistry;
import com.thevortex.allthemodium.worldgen.features.FastNoiseLite;
import com.thevortex.allthemodium.worldgen.features.VolcanoConfig;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;

public class Volcano
extends Feature<VolcanoConfig> {
    FastNoiseLite fnlPerlin = null;
    BlockPos lastpos = new BlockPos(0, 0, 0);

    public Volcano(Codec<VolcanoConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<VolcanoConfig> p_159749_) {
        return this.place(p_159749_.m_159774_(), p_159749_.m_159775_(), p_159749_.m_159776_(), p_159749_.m_159777_(), (FeatureConfiguration)FeatureConfiguration.f_67737_);
    }

    private boolean place(WorldGenLevel world, ChunkGenerator generator, Random rand, BlockPos pos, FeatureConfiguration config) {
        this.setSeed(world.m_7328_());
        int landHeight = generator.m_156174_(pos.m_123341_(), pos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, (LevelHeightAccessor)world.m_46865_(pos));
        if (rand.nextFloat() < 5.0E-4f) {
            pos = new BlockPos(pos.m_123341_(), landHeight, pos.m_123343_());
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            double baseRadius = 16.0;
            double lavaLeakage = 0.7;
            int volcanoConeSize = 75;
            int volcanoStartHeight = volcanoConeSize - 5;
            double threshold = 0.5;
            for (double x = (double)(-volcanoConeSize); x <= (double)volcanoConeSize; x += 1.0) {
                for (double y = (double)(-volcanoConeSize); y <= -15.0; y += 1.0) {
                    for (double z = (double)(-volcanoConeSize); z <= (double)volcanoConeSize; z += 1.0) {
                        mutable.m_122190_((Vec3i)pos).m_122184_((int)x, (int)y + volcanoStartHeight, (int)z);
                        float noise3 = FastNoiseLite.getSpongePerlinValue(this.fnlPerlin.GetNoise(mutable.m_123341_(), mutable.m_123343_()));
                        double scaledNoise = (double)(noise3 / 11.0f) * (-(y * baseRadius) / (x * x + z * z));
                        if (scaledNoise - lavaLeakage >= threshold) {
                            if (mutable.m_123342_() > pos.m_123342_() + (volcanoStartHeight - 19)) continue;
                            world.m_7731_((BlockPos)mutable, ((LiquidBlock)ModRegistry.molten_BlueLava_block.get()).m_49966_(), 2);
                            continue;
                        }
                        if (!(scaledNoise >= threshold)) continue;
                        world.m_7731_((BlockPos)mutable, rand.nextBoolean() ? Blocks.f_50137_.m_49966_() : ((Block)ModRegistry.ANCIENT_STONE.get()).m_49966_(), 2);
                    }
                }
            }
        }
        return true;
    }

    public void setSeed(long seed) {
        if (this.fnlPerlin == null) {
            this.fnlPerlin = FastNoiseLite.createSpongePerlin((int)seed);
            this.fnlPerlin.SetFrequency(0.2f);
        }
    }
}

