/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.allthemodium.datagen.builder;

import com.thevortex.allthemodium.datagen.RecipeException;
import com.thevortex.allthemodium.reference.TagRegistry;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.RegistryObject;

public class ShapedAncientStones {
    private final String criteriaName;
    private final InventoryChangeTrigger.TriggerInstance criterion;
    private final EnumMap<Slot, Item> pieces = new EnumMap(Slot.class);
    private final TagKey<Item> ancientstone;

    public ShapedAncientStones(TagKey<Item> ancientstone) {
        this.ancientstone = ancientstone;
        this.criteriaName = String.format("has_%s_block", TagRegistry.ANCIENT_STONE.toString());
        ItemPredicate predicate = ItemPredicate.Builder.m_45068_().m_204145_(ancientstone).m_45077_();
        this.criterion = InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{predicate});
    }

    public static ShapedAncientStones builder(TagKey<Item> ancientstone) {
        return new ShapedAncientStones(ancientstone);
    }

    public ShapedAncientStones setBookShelf(RegistryObject<Item> object) {
        this.pieces.put(Slot.BOOKSHELF, (Item)object.get());
        return this;
    }

    public ShapedAncientStones setDoor(RegistryObject<Item> object) {
        this.pieces.put(Slot.DOOR, (Item)object.get());
        return this;
    }

    public ShapedAncientStones setTrapDoor(RegistryObject<Item> object) {
        this.pieces.put(Slot.TRAPDOOR, (Item)object.get());
        return this;
    }

    public ShapedAncientStones setBrick(RegistryObject<Item> object) {
        this.pieces.put(Slot.BRICK, (Item)object.get());
        return this;
    }

    public ShapedAncientStones setStairs(RegistryObject<Item> object) {
        this.pieces.put(Slot.STAIRS, (Item)object.get());
        return this;
    }

    public ShapedAncientStones setFence(RegistryObject<Item> object) {
        this.pieces.put(Slot.FENCE, (Item)object.get());
        return this;
    }

    public ShapedAncientStones setFenceGate(RegistryObject<Item> object) {
        this.pieces.put(Slot.FENCEGATE, (Item)object.get());
        return this;
    }

    public ShapedAncientStones setSlab(RegistryObject<Item> object) {
        this.pieces.put(Slot.SLAB, (Item)object.get());
        return this;
    }

    public ShapedAncientStones setWall(RegistryObject<Item> object) {
        this.pieces.put(Slot.WALL, (Item)object.get());
        return this;
    }

    protected void validate(ResourceLocation id) {
        if (this.pieces.isEmpty()) {
            throw new RecipeException(id.toString(), "recipe must have at least 1 output");
        }
    }

    public void build(Consumer<FinishedRecipe> consumer) {
        Consumer<ShapedRecipeBuilder> register = builder -> builder.m_176498_(consumer);
        Optional.ofNullable(this.pieces.get((Object)Slot.BOOKSHELF)).map(this::bookshelf).map(this::addBookCriterion).ifPresent(register);
        Optional.ofNullable(this.pieces.get((Object)Slot.TRAPDOOR)).map(this::trapdoor).map(this::addCriterion).ifPresent(register);
        Optional.ofNullable(this.pieces.get((Object)Slot.WALL)).map(this::wall).map(this::addCriterion).ifPresent(register);
        Optional.ofNullable(this.pieces.get((Object)Slot.BRICK)).map(this::brick).map(this::addCriterion).ifPresent(register);
        Optional.ofNullable(this.pieces.get((Object)Slot.SLAB)).map(this::slab).map(this::addCriterion).ifPresent(register);
        Optional.ofNullable(this.pieces.get((Object)Slot.DOOR)).map(this::door).map(this::addCriterion).ifPresent(register);
        Optional.ofNullable(this.pieces.get((Object)Slot.STAIRS)).map(this::stairs).map(this::addCriterion).ifPresent(register);
        Optional.ofNullable(this.pieces.get((Object)Slot.FENCE)).map(this::fence).map(this::addStickCriterion).ifPresent(register);
        Optional.ofNullable(this.pieces.get((Object)Slot.FENCEGATE)).map(this::fencegate).map(this::addStickCriterion).ifPresent(register);
    }

    private ShapedRecipeBuilder shaped(ItemLike provider, int integer) {
        return ShapedRecipeBuilder.m_126118_((ItemLike)provider, (int)integer).m_142409_("allthemodium");
    }

    private ShapedRecipeBuilder shaped(ItemLike provider) {
        return ShapedRecipeBuilder.m_126116_((ItemLike)provider).m_142409_("allthemodium");
    }

    private ShapedRecipeBuilder addCriterion(ShapedRecipeBuilder builder) {
        return builder.m_206416_(Character.valueOf('a'), this.ancientstone).m_142284_(this.criteriaName, (CriterionTriggerInstance)this.criterion);
    }

    private ShapedRecipeBuilder addStickCriterion(ShapedRecipeBuilder builder) {
        return builder.m_206416_(Character.valueOf('a'), this.ancientstone).m_126127_(Character.valueOf('s'), (ItemLike)Items.f_42398_).m_142284_(this.criteriaName, (CriterionTriggerInstance)this.criterion);
    }

    private ShapedRecipeBuilder addBookCriterion(ShapedRecipeBuilder builder) {
        return builder.m_206416_(Character.valueOf('a'), this.ancientstone).m_126127_(Character.valueOf('b'), (ItemLike)Items.f_42517_).m_142284_(this.criteriaName, (CriterionTriggerInstance)this.criterion);
    }

    private ShapedRecipeBuilder bookshelf(ItemLike provider) {
        return this.shaped(provider).m_126130_("aaa").m_126130_("bbb").m_126130_("aaa");
    }

    private ShapedRecipeBuilder fence(ItemLike provider) {
        return this.shaped(provider, 3).m_126130_("   ").m_126130_("asa").m_126130_("asa");
    }

    private ShapedRecipeBuilder trapdoor(ItemLike provider) {
        return this.shaped(provider, 2).m_126130_("   ").m_126130_("aaa").m_126130_("aaa");
    }

    private ShapedRecipeBuilder door(ItemLike provider) {
        return this.shaped(provider, 3).m_126130_("aa ").m_126130_("aa ").m_126130_("aa ");
    }

    private ShapedRecipeBuilder brick(ItemLike provider) {
        return this.shaped(provider, 4).m_126130_("   ").m_126130_("aa ").m_126130_("aa ");
    }

    private ShapedRecipeBuilder fencegate(ItemLike provider) {
        return this.shaped(provider).m_126130_("   ").m_126130_("sas").m_126130_("sas");
    }

    private ShapedRecipeBuilder stairs(ItemLike provider) {
        return this.shaped(provider, 4).m_126130_("a  ").m_126130_("aa ").m_126130_("aaa");
    }

    private ShapedRecipeBuilder wall(ItemLike provider) {
        return this.shaped(provider, 6).m_126130_("   ").m_126130_("aaa").m_126130_("aaa");
    }

    private ShapedRecipeBuilder slab(ItemLike provider) {
        return this.shaped(provider, 6).m_126130_("   ").m_126130_("   ").m_126130_("aaa");
    }

    public static enum Slot {
        BOOKSHELF,
        TRAPDOOR,
        BRICK,
        FENCE,
        FENCEGATE,
        STAIRS,
        WALL,
        SLAB,
        DOOR;


        public String lower() {
            return this.toString().toLowerCase(Locale.ROOT);
        }
    }
}

