/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.modintegration.handlers.mekanism;

import java.util.Random;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import shetiphian.endertanks.Configuration;
import shetiphian.endertanks.api.HandlerRegistry;
import shetiphian.endertanks.api.IEnderTankInfo;
import shetiphian.endertanks.api.ITankHandler;
import shetiphian.endertanks.api.StorageAccessMode;
import shetiphian.endertanks.modintegration.handlers.mekanism.WrapperGasHandler;

public class TypeGas {
    public static void init() {
        if (((Boolean)Configuration.INTEGRATION.storeMekanismGas.get()).booleanValue() && IGasHandler.class != null) {
            HandlerRegistry.register(Capabilities.GAS_HANDLER_CAPABILITY, GasTankHandler.Provider.INSTANCE);
        }
    }

    public static class GasTankHandler
    implements ITankHandler<IGasHandler> {
        private final ChemicalTankBuilder.BasicGasTank gasTank;
        private final IGasHandler gasTankInsertOnly;
        private final IGasHandler gasTankExtractOnly;
        private long tankCapacity;

        public GasTankHandler(final IEnderTankInfo tank) {
            this.tankCapacity = (long)tank.getCapacity() * 1000L;
            this.gasTank = new ChemicalTankBuilder.BasicGasTank(this.tankCapacity, (stack, type) -> true, (stack, type) -> true, stack -> true, ChemicalAttributeValidator.ALWAYS_ALLOW, null){

                public long getCapacity() {
                    return tankCapacity;
                }

                public void onContentsChanged() {
                    tank.notifyContentsChange();
                }
            };
            this.gasTankInsertOnly = new WrapperGasHandler((IGasHandler)this.gasTank, true, false);
            this.gasTankExtractOnly = new WrapperGasHandler((IGasHandler)this.gasTank, false, true);
        }

        @Override
        public IGasHandler getTank(StorageAccessMode access) {
            return switch (access) {
                case StorageAccessMode.INSERT_ONLY -> this.gasTankInsertOnly;
                case StorageAccessMode.EXTRACT_ONLY -> this.gasTankExtractOnly;
                default -> this.gasTank;
            };
        }

        @Override
        public void setCapacity(int capacity) {
            int newCapacity = capacity * 1000;
            if (this.tankCapacity != (long)newCapacity) {
                this.tankCapacity = newCapacity;
                this.gasTank.onContentsChanged();
            }
        }

        @Override
        public void load(CompoundTag nbt) {
            this.gasTank.deserializeNBT(nbt);
        }

        @Override
        public CompoundTag save() {
            return !this.gasTank.isEmpty() ? this.gasTank.serializeNBT() : null;
        }

        @Override
        public MutableComponent getContentsInfo() {
            GasStack stack = (GasStack)this.gasTank.getStack();
            if (!stack.isEmpty()) {
                return new TextComponent(" ").m_7220_((Component)new TranslatableComponent("info.endertanks.tank.type.mekanism.gas")).m_130946_(" ").m_7220_((Component)new TranslatableComponent(((Gas)stack.getType()).getTranslationKey())).m_130946_(" [" + (float)stack.getAmount() / 1000.0f + "K/" + this.gasTank.getCapacity() / 1000L + "K mB]");
            }
            return null;
        }

        @Override
        public void preformPumpAction(Level world, BlockPos pos, Direction facing, BlockPos pullFromPos, BlockPos pushToPos, int pumpCapacity, Random random) {
            IGasHandler toHandler;
            GasStack gasStack;
            long used;
            IGasHandler fromHandler;
            if (this.gasTank.getStored() < this.gasTank.getCapacity() && (fromHandler = this.getHandler(world.m_7702_(pullFromPos), facing)) != null && (used = (gasStack = (GasStack)fromHandler.extractChemical((long)pumpCapacity, Action.SIMULATE)).getAmount() - ((GasStack)this.gasTank.insertChemical((ChemicalStack)gasStack, Action.SIMULATE)).getAmount()) > 0L) {
                this.gasTank.insertChemical((ChemicalStack)((GasStack)fromHandler.extractChemical(used, Action.EXECUTE)), Action.EXECUTE);
            }
            if (!this.gasTank.isEmpty() && (toHandler = this.getHandler(world.m_7702_(pushToPos), facing.m_122424_())) != null && (used = (gasStack = (GasStack)this.gasTank.extractChemical((long)pumpCapacity, Action.SIMULATE)).getAmount() - ((GasStack)toHandler.insertChemical((ChemicalStack)gasStack, Action.SIMULATE)).getAmount()) > 0L) {
                toHandler.insertChemical((ChemicalStack)((GasStack)this.gasTank.extractChemical(used, Action.EXECUTE)), Action.EXECUTE);
            }
        }

        public IGasHandler getHandler(BlockEntity tile, Direction facing) {
            return tile == null ? null : (IGasHandler)tile.getCapability(Capabilities.GAS_HANDLER_CAPABILITY, facing).orElse(null);
        }

        public static class Provider
        implements HandlerRegistry.ITankHandlerProvider<IGasHandler> {
            public static Provider INSTANCE = new Provider();

            @Override
            public ITankHandler<IGasHandler> create(IEnderTankInfo tank) {
                return new GasTankHandler(tank);
            }
        }
    }
}

