/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks;

import com.mojang.logging.LogUtils;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.slf4j.Logger;
import shetiphian.endertanks.Configuration;
import shetiphian.endertanks.Values;
import shetiphian.endertanks.client.misc.EventHandlerClient;
import shetiphian.endertanks.client.render.RenderRegistry;
import shetiphian.endertanks.common.misc.CauldronHelper;
import shetiphian.endertanks.common.misc.EventHandler;
import shetiphian.endertanks.common.misc.TankHelper;
import shetiphian.endertanks.common.network.NetworkHandler;
import shetiphian.endertanks.modintegration.ModIntegration;

@Mod(value="endertanks")
public class EnderTanks {
    public static final String MOD_ID = "endertanks";
    public static EnderTanks INSTANCE;
    public static Logger LOGGER;

    public EnderTanks() {
        INSTANCE = this;
        LOGGER = LogUtils.getLogger();
        IEventBus MOD_EVENT_BUS = FMLJavaModLoadingContext.get().getModEventBus();
        MOD_EVENT_BUS.register((Object)this);
        MOD_EVENT_BUS.addListener(this::commonSetup);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> MOD_EVENT_BUS.addListener(this::clientSetup));
        MOD_EVENT_BUS.addListener(this::init);
        MinecraftForge.EVENT_BUS.addListener(this::serverStarted);
        MinecraftForge.EVENT_BUS.addListener(this::serverStopped);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Configuration.SPEC_CLIENT, "endertanks-client.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Configuration.SPEC_COMMON, "endertanks.toml");
        MOD_EVENT_BUS.register(Configuration.class);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        Values.minecraftDir = FMLPaths.GAMEDIR.get().toAbsolutePath().toString();
        CauldronHelper.register();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientSetup(FMLClientSetupEvent event) {
        RenderRegistry.setupNow();
        event.enqueueWork(RenderRegistry::setupLater);
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerClient());
    }

    private void init(InterModEnqueueEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        NetworkHandler.initialise(MOD_ID);
        new ModIntegration();
    }

    private void serverStarted(ServerStartedEvent event) {
        TankHelper.INSTANCE.loadTankData();
    }

    private void serverStopped(ServerStoppedEvent event) {
        TankHelper.INSTANCE.unloadTankData();
        Configuration.CAN_PROCESS_TAGS = false;
    }
}

