/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.dialog;

import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.io.FileHandler;
import journeymap.client.model.SplashInfo;
import journeymap.client.model.SplashPerson;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.texture.Texture;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.ButtonList;
import journeymap.client.ui.component.JmUI;
import journeymap.client.ui.dialog.FullscreenActions;
import journeymap.client.ui.dialog.OptionsManager;
import journeymap.common.Journeymap;
import journeymap.common.properties.catagory.Category;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;

public class AboutDialog
extends JmUI {
    protected Texture discordLogo = TextureCache.getTexture(TextureCache.Discord);
    Button buttonClose;
    Button buttonOptions;
    Button buttonDiscord;
    Button buttonWebsite;
    Button buttonDownload;
    ButtonList peopleButtons;
    ButtonList devButtons;
    ButtonList logoButtons;
    ButtonList linkButtons;
    ButtonList bottomButtons;
    ButtonList infoButtons;
    private long lastPeopleMove;
    private List<SplashPerson> people = Arrays.asList(new SplashPerson[0]);
    private List<SplashPerson> devs = Arrays.asList(new SplashPerson("79f597fe-2877-4ecb-acdf-8c58cc1854ca", "mysticdrew", "jm.common.splash_developer"), new SplashPerson("a2039b6c-5a3d-407d-b49c-091405062b85", "techbrew", "jm.common.splash_developer"), new SplashPerson("ca5c3fc3-4d99-4f2e-a0d0-9565fe783e1f", "gdude2002", "jm.common.splash_developer"), new SplashPerson("16fd5b0e-a7a7-42a6-b203-52de6493c2b4", "Sandriell", "jm.common.splash_artist"));
    private SplashInfo info;

    public AboutDialog(JmUI returnDisplay) {
        super(Constants.getString("jm.common.splash_title", Journeymap.JM_VERSION), returnDisplay);
        this.scaleFactor = (int)Minecraft.m_91087_().m_91268_().m_85449_();
    }

    @Override
    public void m_7856_() {
        Button button2;
        JourneymapClient.getInstance().getCoreProperties().splashViewed.set(Journeymap.JM_VERSION.toString()).save();
        super.setRenderBottomBar(true);
        if (this.info == null) {
            String bday;
            this.info = FileHandler.getMessageModel(SplashInfo.class, "splash");
            if (this.info == null) {
                this.info = new SplashInfo();
            }
            if ((bday = Constants.birthdayMessage()) != null) {
                this.info.lines.add(0, new SplashInfo.Line(bday, "dialog.FullscreenActions#tweet#" + bday));
                this.devs = new ArrayList<SplashPerson>(this.devs);
                this.devs.add(new SplashPerson.Fake("", "", TextureCache.getTexture(TextureCache.ColorPicker2)));
            }
            return;
        }
        this.getRenderables().clear();
        Font fr = this.getFontRenderer();
        this.devButtons = new ButtonList();
        for (SplashPerson dev : this.devs) {
            button2 = new Button(dev.name);
            this.devButtons.add(button2);
            dev.setButton(button2);
        }
        this.devButtons.setWidths(20);
        this.devButtons.setHeights(20);
        this.devButtons.layoutDistributedHorizontal(0, 35, this.f_96543_, true);
        this.peopleButtons = new ButtonList();
        for (SplashPerson peep : this.people) {
            button2 = new Button(peep.name);
            this.peopleButtons.add(button2);
            peep.setButton(button2);
        }
        this.peopleButtons.setWidths(20);
        this.peopleButtons.setHeights(20);
        this.peopleButtons.layoutDistributedHorizontal(0, this.f_96544_ - 65, this.f_96543_, true);
        this.infoButtons = new ButtonList();
        for (SplashInfo.Line line : this.info.lines) {
            button2 = new SplashInfoButton(line, b -> line.invokeAction(this));
            button2.setDrawBackground(false);
            button2.setDefaultStyle(false);
            button2.setDrawFrame(false);
            Objects.requireNonNull(fr);
            button2.setHeight(9 + 5);
            if (line.hasAction()) {
                button2.setTooltip(Constants.getString("jm.common.splash_action"));
            }
            this.infoButtons.add(button2);
        }
        this.infoButtons.equalizeWidths(fr);
        this.getRenderables().addAll(this.infoButtons);
        this.buttonClose = (Button)this.m_142416_((GuiEventListener)new Button(Constants.getString("jm.common.close"), button -> this.closeAndReturn()));
        this.buttonOptions = (Button)this.m_142416_((GuiEventListener)new Button(Constants.getString("jm.common.options_button"), button -> {
            if (returnDisplayStack != null && returnDisplayStack.peek() != null && returnDisplayStack.peek() instanceof OptionsManager) {
                this.closeAndReturn();
            } else {
                UIManager.INSTANCE.openOptionsManager(this, new Category[0]);
            }
        }));
        this.buttonOptions.setDefaultStyle(false);
        this.buttonClose.setDefaultStyle(false);
        this.bottomButtons = new ButtonList(this.buttonOptions);
        if (this.f_96541_.f_91073_ != null) {
            this.bottomButtons.add(this.buttonClose);
        }
        this.bottomButtons.equalizeWidths(fr);
        this.bottomButtons.setWidths(Math.max(100, this.buttonOptions.m_5711_()));
        this.getRenderables().addAll(this.bottomButtons);
        this.buttonWebsite = (Button)this.m_142416_((GuiEventListener)new Button("http://journeymap.info", button -> FullscreenActions.launchWebsite("")));
        this.buttonWebsite.setTooltip(Constants.getString("jm.common.website"));
        this.buttonDownload = (Button)this.m_142416_((GuiEventListener)new Button(Constants.getString("jm.common.download"), button -> FullscreenActions.launchDownloadWebsite()));
        this.buttonDownload.setTooltip(Constants.getString("jm.common.download.tooltip"));
        this.buttonWebsite.setDefaultStyle(false);
        this.buttonDownload.setDefaultStyle(false);
        this.linkButtons = new ButtonList(this.buttonWebsite, this.buttonDownload);
        this.linkButtons.equalizeWidths(fr);
        this.getRenderables().addAll(this.linkButtons);
        int commonWidth = Math.max(this.bottomButtons.getWidth(0) / this.bottomButtons.size(), this.linkButtons.getWidth(0) / this.linkButtons.size());
        this.bottomButtons.setWidths(commonWidth);
        this.linkButtons.setWidths(commonWidth);
        this.buttonDiscord = (Button)this.m_142416_((GuiEventListener)new Button("", button -> FullscreenActions.discord()));
        this.buttonDiscord.setDefaultStyle(false);
        this.buttonDiscord.setDrawBackground(false);
        this.buttonDiscord.setDrawFrame(false);
        this.buttonDiscord.setTooltip(Constants.getString("jm.common.discord"), Constants.getString("jm.common.discord.tooltip"));
        this.buttonDiscord.m_93674_(this.discordLogo.getWidth() / this.scaleFactor);
        this.buttonDiscord.setHeight(this.discordLogo.getHeight() / this.scaleFactor);
        this.logoButtons = new ButtonList(this.buttonDiscord);
        this.logoButtons.setLayout(ButtonList.Layout.Horizontal, ButtonList.Direction.LeftToRight);
        this.logoButtons.setHeights(this.discordLogo.getHeight() / this.scaleFactor);
        this.logoButtons.setWidths(this.discordLogo.getWidth() / this.scaleFactor);
        this.getRenderables().addAll(this.logoButtons);
        this.infoButtons.forEach(x$0 -> {
            Button cfr_ignored_0 = (Button)this.m_142416_((GuiEventListener)x$0);
        });
    }

    @Override
    protected void layoutButtons(PoseStack mStack) {
        boolean movePeople;
        if (this.getRenderables().isEmpty()) {
            this.m_7856_();
        }
        double mx = this.f_96541_.f_91067_.m_91589_() * (double)this.f_96543_ / (double)this.f_96541_.m_91268_().m_85443_();
        double my = (double)this.f_96544_ - this.f_96541_.f_91067_.m_91594_() * (double)this.f_96544_ / (double)this.f_96541_.m_91268_().m_85444_() - 1.0;
        int hgap = 4;
        int vgap = 4;
        Font fr = this.getFontRenderer();
        int estimatedInfoHeight = this.infoButtons.getHeight(4);
        int estimatedButtonsHeight = (this.buttonClose.m_93694_() + 4) * 3 + 4;
        Objects.requireNonNull(this);
        int centerHeight = this.f_96544_ - 35 - estimatedButtonsHeight;
        Objects.requireNonNull(fr);
        int lineHeight = (int)(9.0 * 1.4);
        int bx = this.f_96543_ / 2;
        int by = 0;
        boolean bl = movePeople = System.currentTimeMillis() - this.lastPeopleMove > 20L;
        if (movePeople) {
            this.lastPeopleMove = System.currentTimeMillis();
        }
        Rectangle2D.Double screenBounds = new Rectangle2D.Double(0.0, 0.0, this.f_96543_, this.f_96544_);
        if (!this.devButtons.isEmpty()) {
            for (SplashPerson dev : this.devs) {
                if (dev.getButton().mouseOver(mx, my)) {
                    dev.randomizeVector();
                }
                this.drawPerson(mStack, by, lineHeight, dev);
                if (!movePeople) continue;
                dev.avoid(this.devs);
                dev.adjustVector(screenBounds);
            }
        }
        if (!this.peopleButtons.isEmpty()) {
            for (SplashPerson peep : this.people) {
                if (peep.getButton().mouseOver(mx, my)) {
                    peep.randomizeVector();
                }
                this.drawPerson(mStack, by, lineHeight, peep);
                if (!movePeople) continue;
                peep.avoid(this.devs);
                peep.adjustVector(screenBounds);
            }
        }
        if (!this.infoButtons.isEmpty()) {
            Objects.requireNonNull(this);
            int topY = by = 35 + (centerHeight - estimatedInfoHeight) / 2;
            by = (int)((double)by + (double)lineHeight * 1.5);
            this.infoButtons.layoutCenteredVertical(bx - ((Button)this.infoButtons.get(0)).m_5711_() / 2, by + this.infoButtons.getHeight(0) / 2, true, 0);
            int listX = this.infoButtons.getLeftX() - 10;
            int listY = topY - 5;
            int listWidth = this.infoButtons.getRightX() + 10 - listX;
            int listHeight = this.infoButtons.getBottomY() + 5 - listY;
            DrawUtil.drawGradientRect(mStack, listX - 1, listY - 1, listWidth + 2, listHeight + 2, 0xC0C0C0, 0.8f, 0xC0C0C0, 0.8f);
            DrawUtil.drawGradientRect(mStack, listX, listY, listWidth, listHeight, 0x404040, 1.0f, 0, 1.0f);
            DrawUtil.drawLabel(mStack, Constants.getString("jm.common.splash_whatisnew"), bx, topY, DrawUtil.HAlign.Center, DrawUtil.VAlign.Below, 0, 0.0f, 65535, 1.0f, 1.0, true);
        }
        int rowHeight = this.buttonOptions.m_93694_() + 4;
        by = this.f_96544_ - rowHeight - 4;
        this.bottomButtons.layoutCenteredHorizontal(bx, by, true, 4);
        this.linkButtons.layoutCenteredHorizontal(bx, by -= rowHeight, true, 4);
        this.logoButtons.layoutCenteredHorizontal(bx, by -= 4 + this.logoButtons.getHeight(), true, 6);
        DrawUtil.drawImage(mStack, this.discordLogo, this.buttonDiscord.getX(), this.buttonDiscord.getY(), false, 1.0f / (float)this.scaleFactor, 0.0);
    }

    protected int drawPerson(PoseStack mStack, int by, int lineHeight, SplashPerson person) {
        float scale = 1.0f;
        Button button = person.getButton();
        int imgSize = (int)((float)person.getSkin().getWidth() * scale);
        int imgY = button.getY() - 2;
        int imgX = button.getCenterX() - imgSize / 2;
        if (!(person instanceof SplashPerson.Fake)) {
            DrawUtil.drawGradientRect(mStack, imgX - 1, imgY - 1, imgSize + 2, imgSize + 2, 0, 0.4f, 0, 0.8f);
            DrawUtil.drawImage(mStack, person.getSkin(), 1.0f, imgX, imgY, false, scale, 0.0);
        } else {
            float size = Math.min((float)person.getSkin().getWidth() * scale, 24.0f * scale);
            DrawUtil.drawQuad(mStack, person.getSkin(), 0xFFFFFF, 1.0f, imgX, imgY, size, size, false, 0.0);
        }
        by = imgY + imgSize + 4;
        String name = person.name.trim();
        String name2 = null;
        boolean twoLineName = name.contains(" ");
        if (twoLineName) {
            String[] parts = person.name.split(" ");
            name = parts[0];
            name2 = parts[1];
        }
        DrawUtil.drawLabel(mStack, name, button.getCenterX(), by, DrawUtil.HAlign.Center, DrawUtil.VAlign.Below, 0, 0.0f, 0xFFFFFF, 1.0f, scale, true);
        by += lineHeight;
        if (name2 != null) {
            DrawUtil.drawLabel(mStack, name2, button.getCenterX(), by, DrawUtil.HAlign.Center, DrawUtil.VAlign.Below, 0, 0.0f, 0xFFFFFF, 1.0f, scale, true);
            by += lineHeight;
        }
        DrawUtil.drawLabel(mStack, person.title, button.getCenterX(), by, DrawUtil.HAlign.Center, DrawUtil.VAlign.Below, 0, 0.0f, 65280, 1.0f, scale, true);
        return by += lineHeight;
    }

    @Override
    public boolean m_5534_(char typedChar, int keyCode) {
        switch (keyCode) {
            case 256: {
                this.closeAndReturn();
            }
        }
        return true;
    }

    class SplashInfoButton
    extends Button {
        final SplashInfo.Line infoLine;

        public SplashInfoButton(SplashInfo.Line infoLine, Button.OnPress pressable) {
            super(infoLine.label, pressable);
            this.infoLine = infoLine;
        }
    }
}

