/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.texture;

import com.mojang.blaze3d.platform.NativeImage;
import it.unimi.dsi.fastutil.floats.Float2ObjectMap;
import it.unimi.dsi.fastutil.floats.Float2ObjectOpenHashMap;
import java.io.IOException;
import journeymap.client.cartography.color.RGB;
import journeymap.client.texture.DynamicTextureImpl;
import journeymap.client.texture.ImageUtil;
import journeymap.client.texture.Texture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.resources.metadata.texture.TextureMetadataSection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

public class SimpleTextureImpl
extends SimpleTexture
implements Texture {
    private final ResourceLocation location;
    private final Float2ObjectMap<Texture> scaledImageMap = new Float2ObjectOpenHashMap();
    private float alpha;
    private SimpleTexture.TextureImage textureData;
    private Integer renderWidth;
    private Integer renderHeight;

    public SimpleTextureImpl(ResourceLocation location) {
        super(location);
        this.location = location;
        this.textureData = super.m_6335_(Minecraft.m_91087_().m_91098_());
    }

    @Override
    public int getWidth() {
        try {
            return this.renderWidth == null ? this.textureData.m_118158_().m_84982_() : this.renderWidth.intValue();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getHeight() {
        try {
            return this.renderHeight == null ? this.textureData.m_118158_().m_85084_() : this.renderHeight.intValue();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setDisplayWidth(int width) {
        this.renderWidth = width;
    }

    @Override
    public void setDisplayHeight(int height) {
        this.renderHeight = height;
    }

    public void resize(float scale) {
        try {
            NativeImage newImg = ImageUtil.getScaledImage(scale, this.textureData.m_118158_(), false);
            this.setImage(newImg);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Texture getScaledImage(float drawScale) {
        if (drawScale == 1.0f) {
            return this;
        }
        Texture scaledTexture = (Texture)this.scaledImageMap.get(drawScale);
        try {
            if (scaledTexture == null) {
                scaledTexture = new DynamicTextureImpl(ImageUtil.getScaledImage(drawScale, this.textureData.m_118158_(), false));
                this.scaledImageMap.put(drawScale, (Object)scaledTexture);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return scaledTexture;
    }

    @Override
    public Integer getRGB(int x, int y) {
        int rgba = this.getImage().m_84985_(x, y);
        return RGB.rgbaToRgb(rgba);
    }

    @Override
    public int getTextureId() {
        return super.m_117963_();
    }

    @Override
    public boolean hasImage() {
        return this.textureData != null;
    }

    @Override
    public void remove() {
        this.close();
    }

    @Override
    public void setImage(NativeImage image) {
        this.textureData.close();
        this.textureData = this.updateImage(Minecraft.m_91087_().m_91098_(), image);
    }

    public void close() {
        if (this.getImage() != null) {
            this.scaledImageMap.values().forEach(Texture::remove);
            this.getImage().close();
            this.textureData.close();
            this.m_117964_();
            this.textureData = null;
        }
    }

    @Override
    public NativeImage getImage() {
        try {
            return this.textureData.m_118158_();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ResourceLocation getLocation() {
        return this.location;
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    @Override
    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    private SimpleTexture.TextureImage updateImage(ResourceManager pResourceManager, NativeImage nativeimage) {
        try {
            SimpleTexture.TextureImage image;
            try (Resource resource = pResourceManager.m_142591_(this.location);){
                TextureMetadataSection texturemetadatasection = null;
                try {
                    texturemetadatasection = (TextureMetadataSection)resource.m_5507_((MetadataSectionSerializer)TextureMetadataSection.f_119108_);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                image = new SimpleTexture.TextureImage(texturemetadatasection, nativeimage);
            }
            return image;
        }
        catch (IOException ioexception) {
            return new SimpleTexture.TextureImage(ioexception);
        }
    }
}

