/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.texture;

import com.google.common.base.MoreObjects;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import journeymap.client.log.JMLogger;
import journeymap.client.render.RenderWrapper;
import journeymap.client.task.main.ExpireTextureTask;
import journeymap.client.texture.ImageUtil;
import journeymap.client.texture.Texture;
import journeymap.common.Journeymap;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.ChunkPos;

public class RegionTexture
extends AbstractTexture
implements Texture {
    protected final ReentrantLock bufferLock = new ReentrantLock();
    protected HashSet<ChunkPos> dirtyChunks = new HashSet();
    protected List<WeakReference<Listener>> listeners = new ArrayList<WeakReference<Listener>>(0);
    protected long lastImageUpdate;
    protected String description;
    protected boolean bindNeeded;
    protected long lastBound;
    protected NativeImage image;
    protected NativeImage renderTarget;
    protected int width;
    protected int height;

    public RegionTexture(NativeImage pixels, String description) {
        this.setImage(pixels, true);
        this.description = description;
    }

    public void upload() {
        if (this.renderTarget != null) {
            super.m_117966_();
            this.upload(0, 0, this.renderTarget.m_84982_(), this.renderTarget.m_85084_(), this.renderTarget);
        } else {
            Journeymap.getLogger().warn("Trying to upload disposed texture {}, {}", (Object)this.m_117963_(), (Object)this.description);
        }
    }

    private void upload(int xOffset, int yOffset, int width, int height, NativeImage image) {
        RenderWrapper.texParameter(3553, 10242, 10497);
        RenderWrapper.texParameter(3553, 10243, 10497);
        RenderWrapper.texParameter(3553, 10241, 9729);
        RenderWrapper.texParameter(3553, 10240, 9729);
        RenderWrapper.pixelStore(3314, 0);
        RenderWrapper.pixelStore(3315, 0);
        RenderWrapper.pixelStore(3316, 0);
        RenderWrapper.pixelStore(3317, 4);
        RenderWrapper.texSubImage2D(3553, 0, xOffset, yOffset, width, height, image.m_85102_().m_85170_(), 5121, image.f_84964_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_117966_() {
        if (this.bindNeeded && this.bufferLock.tryLock()) {
            try {
                int err;
                if (this.f_117950_ == -1) {
                    this.f_117950_ = this.m_117963_();
                }
                RenderWrapper.activeTexture(33984);
                RenderWrapper.bindTextureForSetup(this.f_117950_);
                RenderWrapper.setShaderTexture(0, this.f_117950_);
                if (this.lastBound == 0L || this.dirtyChunks.isEmpty()) {
                    GlStateManager.m_84331_((int)3553, (int)33085, (int)0);
                    GlStateManager.m_84331_((int)3553, (int)33082, (int)0);
                    GlStateManager.m_84331_((int)3553, (int)33083, (int)0);
                    GlStateManager.m_84160_((int)3553, (int)34049, (float)0.0f);
                    GlStateManager.m_84209_((int)3553, (int)0, (int)this.renderTarget.m_85102_().m_85170_(), (int)this.renderTarget.m_84982_(), (int)this.renderTarget.m_85084_(), (int)0, (int)6408, (int)5121, (IntBuffer)null);
                    this.upload();
                    this.bindNeeded = false;
                    this.lastBound = System.currentTimeMillis();
                    return;
                }
                for (ChunkPos pos : this.dirtyChunks) {
                    NativeImage chunkImage = ImageUtil.getSubImage(pos.f_45578_, pos.f_45579_, 16, 16, this.image, false);
                    try {
                        this.upload(pos.f_45578_, pos.f_45579_, 16, 16, chunkImage);
                    }
                    finally {
                        if (chunkImage == null) continue;
                        chunkImage.close();
                    }
                }
                while ((err = RenderWrapper.getError()) != 0) {
                    JMLogger.logOnce("GL Error in RegionTexture after upload: " + err + " in " + this, null);
                }
                this.dirtyChunks.clear();
                this.lastBound = System.currentTimeMillis();
                this.bindNeeded = false;
            }
            catch (Throwable t) {
                Journeymap.getLogger().warn("Can't bind texture: ", t);
            }
            finally {
                this.bufferLock.unlock();
            }
        }
    }

    public long getLastImageUpdate() {
        return this.lastImageUpdate;
    }

    public boolean isBound() {
        return this.f_117950_ != -1;
    }

    public boolean isDefunct() {
        return this.image == null && this.f_117950_ == -1 || this.image.f_84964_ == 0L;
    }

    public NativeImage getSubImage(int x, int y, int height, int width) {
        return ImageUtil.getSubImage(x, y, width, height, this.image, false);
    }

    @Override
    public void setImage(NativeImage image, boolean retainImage) {
        if (image == null) {
            return;
        }
        try {
            this.bufferLock.lock();
            if (this.renderTarget == null || this.renderTarget.f_84964_ == 0L) {
                this.renderTarget = new NativeImage(image.m_84982_(), image.m_85084_(), false);
            }
            this.renderTarget.m_85054_(image);
            this.handleImage(image, retainImage);
            this.bindNeeded = true;
        }
        finally {
            this.bufferLock.unlock();
        }
        this.lastImageUpdate = System.currentTimeMillis();
        this.notifyListeners();
    }

    public void setImage(NativeImage image, boolean retainImage, HashSet<ChunkPos> updatedChunks) {
        if (updatedChunks.size() > 15) {
            this.setImage(image, retainImage);
        } else {
            this.handleImage(image, retainImage);
        }
        this.dirtyChunks.addAll(updatedChunks);
        this.lastImageUpdate = System.currentTimeMillis();
        this.notifyListeners();
    }

    private void handleImage(NativeImage image, boolean retainImage) {
        this.bindNeeded = true;
        try {
            this.bufferLock.lock();
            this.width = image.m_84982_();
            this.height = image.m_85084_();
            if (retainImage) {
                if (this.image == null) {
                    this.image = image;
                } else if (image.f_84964_ != this.image.f_84964_) {
                    this.image.m_85054_(image);
                }
            }
            if (image.f_84964_ != this.image.f_84964_) {
                image.close();
            }
        }
        finally {
            this.bufferLock.unlock();
        }
    }

    public Set<ChunkPos> getDirtyAreas() {
        return this.dirtyChunks;
    }

    public void addListener(Listener addedListener) {
        Iterator<WeakReference<Listener>> iter = this.listeners.iterator();
        while (iter.hasNext()) {
            WeakReference<Listener> ref = iter.next();
            Listener listener = (Listener)ref.get();
            if (listener == null) {
                iter.remove();
                continue;
            }
            if (addedListener != listener) continue;
            return;
        }
        this.listeners.add(new WeakReference<Listener>(addedListener));
    }

    protected void notifyListeners() {
        Iterator<WeakReference<Listener>> iter = this.listeners.iterator();
        while (iter.hasNext()) {
            WeakReference<Listener> ref = iter.next();
            Listener listener = (Listener)ref.get();
            if (listener == null) {
                iter.remove();
                continue;
            }
            listener.textureImageUpdated(this);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("glid", this.f_117950_).add("description", (Object)this.description).add("lastImageUpdate", this.lastImageUpdate).toString();
    }

    public boolean bindNeeded() {
        return this.bindNeeded;
    }

    @Override
    public int getWidth() {
        return this.image.m_84982_();
    }

    @Override
    public int getHeight() {
        return this.image.m_85084_();
    }

    @Override
    public void setDisplayWidth(int width) {
    }

    @Override
    public void setDisplayHeight(int height) {
    }

    @Override
    public Texture getScaledImage(float drawScale) {
        return null;
    }

    @Override
    public int getTextureId() {
        return this.f_117950_;
    }

    @Override
    public boolean hasImage() {
        return this.image != null && this.image.f_84964_ > 0L;
    }

    @Override
    public void remove() {
        this.bufferLock.lock();
        ImageUtil.clearAndClose(this.image);
        ImageUtil.clearAndClose(this.renderTarget);
        this.bufferLock.unlock();
        this.bindNeeded = false;
        this.image = null;
        this.renderTarget = null;
        this.lastImageUpdate = 0L;
        this.lastBound = 0L;
        this.f_117950_ = -1;
    }

    public void close() {
        if (this.isBound()) {
            ExpireTextureTask.queue(this.f_117950_);
        }
        this.image.close();
    }

    @Override
    public void setImage(NativeImage image) {
        this.setImage(image, true);
    }

    @Override
    public NativeImage getImage() {
        return this.image;
    }

    @Override
    public float getAlpha() {
        return 0.0f;
    }

    @Override
    public void setAlpha(float alpha) {
    }

    public void m_6704_(ResourceManager pResourceManager) throws IOException {
    }

    public static interface Listener<T extends Texture> {
        public void textureImageUpdated(T var1);
    }
}

