/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.service.webmap.kotlin.routes;

import com.mojang.blaze3d.platform.NativeImage;
import info.journeymap.shaded.kotlin.kotlin.Metadata;
import info.journeymap.shaded.kotlin.kotlin.collections.CollectionsKt;
import info.journeymap.shaded.kotlin.kotlin.jvm.internal.Intrinsics;
import info.journeymap.shaded.kotlin.kotlin.text.StringsKt;
import info.journeymap.shaded.kotlin.spark.kotlin.RouteHandler;
import info.journeymap.shaded.org.eclipse.jetty.io.EofException;
import info.journeymap.shaded.org.jetbrains.annotations.NotNull;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.util.List;
import javax.imageio.IIOException;
import journeymap.client.JourneymapClient;
import journeymap.client.service.webmap.Webmap;
import journeymap.client.texture.TextureCache;
import journeymap.common.Journeymap;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.Logger;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"ALLOWED_EXTENSIONS", "", "", "logger", "Lorg/apache/logging/log4j/Logger;", "resourcesGet", "", "handler", "Linfo/journeymap/shaded/kotlin/spark/kotlin/RouteHandler;", "journeymap"})
public final class ResourcesKt {
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final List<String> ALLOWED_EXTENSIONS;

    @NotNull
    public static final Object resourcesGet(@NotNull RouteHandler handler) {
        Intrinsics.checkNotNullParameter(handler, "handler");
        Object img = null;
        String resource = handler.getRequest().queryParams("resource");
        ResourceLocation resourceLocation = new ResourceLocation(resource);
        Intrinsics.checkNotNullExpressionValue(resource, "resource");
        Object object = new char[]{'.'};
        String extension = (String)CollectionsKt.last(StringsKt.split$default((CharSequence)resource, object, false, 0, 6, null));
        if (Minecraft.m_91087_().f_91073_ == null || !JourneymapClient.getInstance().isMapping().booleanValue()) {
            return "";
        }
        if (StringsKt.contains$default((CharSequence)extension, ":", false, 2, null)) {
            object = new String[1];
            object[0] = (char)":";
            extension = (String)CollectionsKt.first(StringsKt.split$default((CharSequence)extension, (String[])object, false, 0, 6, null));
        }
        object = new String[1];
        object[0] = (char)":";
        if (StringsKt.contains$default((CharSequence)CollectionsKt.first(StringsKt.split$default((CharSequence)resource, (String[])object, false, 0, 6, null)), "fake", false, 2, null)) {
            object = TextureCache.getTexture(resourceLocation).getImage();
            Intrinsics.checkNotNullExpressionValue(object, "getTexture(resourceLocation).image");
            img = object;
        } else {
            try {
                object = NativeImage.m_85058_((InputStream)journeymap.common.kotlin.extensions.ResourcesKt.getResourceAsStream(resourceLocation));
                Intrinsics.checkNotNullExpressionValue(object, "{\n            NativeImag\u2026urceAsStream())\n        }");
            }
            catch (FileNotFoundException e) {
                logger.warn("File at resource location not found: " + resource);
                handler.status(404);
                NativeImage nativeImage = NativeImage.m_85058_((InputStream)Webmap.INSTANCE.getClass().getResource("/assets/journeymap/ui/img/marker-dot-32.png").openStream());
                Intrinsics.checkNotNullExpressionValue(nativeImage, "{\n            logger.war\u2026).openStream())\n        }");
                object = nativeImage;
            }
            catch (EofException e) {
                logger.info("Connection closed while writing image response. Webmap probably reloaded.");
                return "";
            }
            catch (IIOException e) {
                logger.info("Connection closed while writing image response. Webmap probably reloaded.");
                return "";
            }
            catch (Exception e) {
                logger.error("Exception thrown while retrieving resource at location: " + resource, (Throwable)e);
                handler.status(500);
                NativeImage nativeImage = NativeImage.m_85058_((InputStream)Webmap.INSTANCE.getClass().getResource("/assets/journeymap/ui/img/marker-dot-32.png").openStream());
                Intrinsics.checkNotNullExpressionValue(nativeImage, "{\n            logger.err\u2026).openStream())\n        }");
                object = nativeImage;
            }
            img = object;
        }
        handler.getResponse().raw().setContentType("image/" + extension);
        img.m_85064_(Channels.newChannel(handler.getResponse().raw().getOutputStream()));
        handler.getResponse().raw().getOutputStream().flush();
        object = new String[1];
        object[0] = (char)":";
        if (!StringsKt.contains$default((CharSequence)CollectionsKt.first(StringsKt.split$default((CharSequence)resource, (String[])object, false, 0, 6, null)), "fake", false, 2, null)) {
            img.close();
        }
        return handler.getResponse();
    }

    static {
        Logger logger = Journeymap.getLogger("webmap/routes/resources");
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(\"webmap/routes/resources\")");
        ResourcesKt.logger = logger;
        ALLOWED_EXTENSIONS = CollectionsKt.listOf("png");
    }
}

