/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.draw;

import com.google.common.cache.CacheLoader;
import com.mojang.blaze3d.vertex.PoseStack;
import info.journeymap.shaded.earcut4j.Earcut;
import info.journeymap.shaded.org.jetbrains.annotations.NotNull;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import journeymap.client.api.display.Context;
import journeymap.client.api.display.PolygonOverlay;
import journeymap.client.api.model.MapPolygon;
import journeymap.client.api.model.TextProperties;
import journeymap.client.data.DataCache;
import journeymap.client.render.draw.BaseOverlayDrawStep;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.map.GridRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;

public class DrawPolygonStep
extends BaseOverlayDrawStep<PolygonOverlay> {
    protected List<Point2D.Double> fillPoints = new ArrayList<Point2D.Double>();
    protected List<List<Point2D.Double>> strokePoints = new ArrayList<List<Point2D.Double>>();
    boolean doRender = true;
    boolean onScreen;

    public DrawPolygonStep(PolygonOverlay polygon) {
        super(polygon);
    }

    @Override
    public void draw(PoseStack mStack, MultiBufferSource buffers, DrawStep.Pass pass, double xOffset, double yOffset, GridRenderer gridRenderer, double fontScale, double rotation) {
        if (pass == DrawStep.Pass.Object) {
            if (((PolygonOverlay)this.overlay).getOuterArea().getPoints().isEmpty()) {
                this.onScreen = false;
                return;
            }
            this.onScreen = this.isOnScreen(xOffset, yOffset, gridRenderer, rotation);
            if (this.onScreen && this.doRender) {
                DrawUtil.drawPolygon(mStack, xOffset, yOffset, this.fillPoints, this.strokePoints, ((PolygonOverlay)this.overlay).getShapeProperties(), gridRenderer.getZoom());
            }
        } else if (this.onScreen && this.doRender) {
            super.drawText(mStack, buffers, pass, xOffset, yOffset, gridRenderer, fontScale, rotation);
        }
    }

    @Override
    protected void updatePositions(GridRenderer gridRenderer, double rotation) {
        if (((PolygonOverlay)this.overlay).getOuterArea().getPoints().isEmpty()) {
            return;
        }
        if (Context.UI.Minimap == gridRenderer.getUIState().ui) {
            Vec3 playerPos = Minecraft.m_91087_().f_91074_.m_20182_();
            int zoom = gridRenderer.getZoom() <= 1 ? 2 : gridRenderer.getZoom();
            int limit = gridRenderer.getGridSize() * 512 / zoom;
            if (!((PolygonOverlay)this.overlay).getOuterArea().getPoints().get(0).m_123314_(new Vec3i(playerPos.m_7096_(), playerPos.m_7098_(), playerPos.m_7094_()), (double)limit)) {
                this.doRender = false;
                return;
            }
        }
        this.doRender = true;
        List<BlockPos> points = DataCache.INSTANCE.getTriangulation((PolygonOverlay)this.overlay);
        this.fillPoints.clear();
        for (BlockPos pos : points) {
            Point2D.Double pixel = gridRenderer.getBlockPixelInGrid(pos);
            if (this.fillPoints.isEmpty()) {
                this.screenBounds.setRect(pixel.x, pixel.y, 1.0, 1.0);
            } else {
                this.screenBounds.add(pixel);
            }
            this.fillPoints.add(pixel);
        }
        this.strokePoints.clear();
        this.strokePoints.add(DrawPolygonStep.toScreen(gridRenderer, ((PolygonOverlay)this.overlay).getOuterArea()));
        if (((PolygonOverlay)this.overlay).getHoles() != null) {
            for (MapPolygon hole : ((PolygonOverlay)this.overlay).getHoles()) {
                this.strokePoints.add(DrawPolygonStep.toScreen(gridRenderer, hole));
            }
        }
        TextProperties textProperties = ((PolygonOverlay)this.overlay).getTextProperties();
        this.labelPosition.setLocation(this.screenBounds.getCenterX() + (double)textProperties.getOffsetX(), this.screenBounds.getCenterY() + (double)textProperties.getOffsetY());
    }

    private static List<Point2D.Double> toScreen(@NotNull GridRenderer gridRenderer, @NotNull MapPolygon polygon) {
        ArrayList<Point2D.Double> points = new ArrayList<Point2D.Double>();
        for (BlockPos pos : polygon.getPoints()) {
            points.add(gridRenderer.getBlockPixelInGrid(pos));
        }
        return points;
    }

    public static List<MapPolygon> triangulate(@NotNull PolygonOverlay overlay) {
        List holesList = Optional.ofNullable(overlay.getHoles()).orElse(new ArrayList());
        List blockPoints = Stream.concat(overlay.getOuterArea().getPoints().stream(), holesList.stream().flatMap(hole -> hole.getPoints().stream())).collect(Collectors.toList());
        double[] points = new double[blockPoints.size() * 2];
        for (int index = 0; index < blockPoints.size(); ++index) {
            points[index * 2] = ((BlockPos)blockPoints.get(index)).m_123341_();
            points[index * 2 + 1] = ((BlockPos)blockPoints.get(index)).m_123343_();
        }
        int[] holes = new int[holesList.size()];
        int holeIndex = overlay.getOuterArea().getPoints().size();
        for (int index = 0; index < holesList.size(); ++index) {
            holes[index] = holeIndex;
            holeIndex += ((MapPolygon)holesList.get(index)).getPoints().size();
        }
        List<Integer> triangles = Earcut.earcut(points, holes, 2);
        ArrayList<MapPolygon> trianglePolys = new ArrayList<MapPolygon>();
        for (int index = 0; index < triangles.size(); index += 3) {
            ArrayList<BlockPos> trianglePoints = new ArrayList<BlockPos>();
            trianglePoints.add((BlockPos)blockPoints.get(triangles.get(index + 2)));
            trianglePoints.add((BlockPos)blockPoints.get(triangles.get(index + 1)));
            trianglePoints.add((BlockPos)blockPoints.get(triangles.get(index)));
            trianglePolys.add(new MapPolygon(trianglePoints));
        }
        return trianglePolys;
    }

    public static class SimpleCacheLoader
    extends CacheLoader<PolygonOverlay, DrawPolygonStep> {
        public DrawPolygonStep load(PolygonOverlay overlay) throws Exception {
            return new DrawPolygonStep(overlay);
        }
    }

    public static class TriangulationCacheLoader
    extends CacheLoader<PolygonOverlay, List<BlockPos>> {
        public List<BlockPos> load(PolygonOverlay overlay) throws Exception {
            return DrawPolygonStep.triangulate(overlay).stream().flatMap(poly -> poly.getPoints().stream()).collect(Collectors.toList());
        }
    }
}

