/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.cartography.render;

import com.mojang.blaze3d.platform.NativeImage;
import journeymap.client.cartography.IChunkRenderer;
import journeymap.client.cartography.Strata;
import journeymap.client.cartography.Stratum;
import journeymap.client.cartography.color.RGB;
import journeymap.client.cartography.render.BaseRenderer;
import journeymap.client.log.StatTimer;
import journeymap.client.model.BlockCoordIntPair;
import journeymap.client.model.BlockMD;
import journeymap.client.model.ChunkMD;
import journeymap.client.model.MapType;
import journeymap.client.texture.ComparableNativeImage;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import journeymap.common.nbt.RegionData;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;

public class SurfaceRenderer
extends BaseRenderer
implements IChunkRenderer {
    protected StatTimer renderSurfaceTimer = StatTimer.get("SurfaceRenderer.renderSurface");
    protected StatTimer renderSurfacePrepassTimer = StatTimer.get("SurfaceRenderer.renderSurface.CavePrepass");
    protected Strata strata = new Strata("Surface", 40, 8, false);
    protected float maxDepth = 8.0f;

    public SurfaceRenderer() {
        this.updateOptions(null, null);
    }

    @Override
    protected boolean updateOptions(ChunkMD chunkMd, MapType mapType) {
        if (super.updateOptions(chunkMd, mapType)) {
            this.ambientColor = RGB.floats(this.tweakSurfaceAmbientColor);
            return true;
        }
        return false;
    }

    @Override
    public int getBlockHeight(ChunkMD chunkMd, BlockPos blockPos) {
        Integer y = this.getBlockHeight(chunkMd, blockPos.m_123341_() & 0xF, null, blockPos.m_123343_() & 0xF, null, null);
        return y == null ? blockPos.m_123342_() : y.intValue();
    }

    @Override
    public boolean render(ComparableNativeImage dayChunkImage, RegionData regionData, ChunkMD chunkMd, Integer ignored) {
        return this.render(dayChunkImage, null, regionData, chunkMd, null, false);
    }

    public boolean render(ComparableNativeImage dayChunkImage, NativeImage nightChunkImage, RegionData regionData, ChunkMD chunkMd) {
        return this.render(dayChunkImage, nightChunkImage, regionData, chunkMd, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean render(ComparableNativeImage dayChunkImage, NativeImage nightChunkImage, RegionData regionData, ChunkMD chunkMd, Integer vSlice, boolean cavePrePass) {
        StatTimer timer = cavePrePass ? this.renderSurfacePrepassTimer : this.renderSurfaceTimer;
        try {
            timer.start();
            this.updateOptions(chunkMd, MapType.from(MapType.Name.surface, null, chunkMd.getDimension()));
            if (!this.hasSlopes(chunkMd, vSlice)) {
                this.populateSlopes(chunkMd, vSlice, this.getSlopes(chunkMd, vSlice));
            }
            boolean bl = this.renderSurface(dayChunkImage, nightChunkImage, regionData, chunkMd, vSlice, cavePrePass);
            return bl;
        }
        catch (Throwable e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            this.strata.reset();
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean renderSurface(NativeImage dayChunkImage, NativeImage nightChunkImage, RegionData regionData, ChunkMD chunkMd, Integer vSlice, boolean cavePrePass) {
        boolean chunkOk = false;
        try {
            int sliceMaxY = 0;
            if (cavePrePass) {
                int[] sliceBounds = this.getVSliceBounds(chunkMd, vSlice);
                sliceMaxY = sliceBounds[1];
            }
            CompoundTag chunkNbt = regionData.getChunkNbt(chunkMd.getCoord());
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    Integer[][] waterHeights;
                    Integer waterHeight;
                    boolean showSlope;
                    CompoundTag blockNbt = regionData.getBlockDataFromBlockPos(chunkMd.getCoord(), chunkNbt, x, z);
                    this.strata.reset();
                    int blockHeight = this.getBlockHeight(chunkMd, x, null, z, null, null);
                    int upperY = Math.max(chunkMd.getMinY(), chunkMd.getPrecipitationHeight(x, z));
                    int lowerY = Math.max(chunkMd.getMinY(), blockHeight);
                    BlockMD blockMd = chunkMd.getBlockMD(x, blockHeight, z);
                    if ((upperY == chunkMd.getMinY() || lowerY < chunkMd.getMinY()) && blockMd.getBlockState().m_60795_()) {
                        int dayVoid = this.paintVoidBlock(dayChunkImage, x, z);
                        regionData.setBlockColor(blockNbt, dayVoid, MapType.Name.day);
                        if (!cavePrePass && nightChunkImage != null) {
                            int nightVoid = this.paintVoidBlock(nightChunkImage, x, z);
                            regionData.setBlockColor(blockNbt, nightVoid, MapType.Name.night);
                        }
                        chunkOk = true;
                        continue;
                    }
                    if (cavePrePass && upperY > sliceMaxY && (float)(upperY - sliceMaxY) > this.maxDepth) {
                        chunkOk = true;
                        this.paintBlackBlock(dayChunkImage, x, z);
                        continue;
                    }
                    boolean bl = showSlope = !chunkMd.getBlockMD(x, lowerY, z).hasNoShadow();
                    if (this.mapBathymetry && (waterHeight = (waterHeights = this.getFluidHeights(chunkMd, null))[z][x]) != null) {
                        upperY = waterHeight;
                    }
                    this.buildStrata(this.strata, upperY, chunkMd, regionData, blockNbt, x, lowerY, z);
                    BlockPos pos = chunkMd.getBlockPos(x, upperY, z);
                    regionData.setBiome(blockNbt, chunkMd.getBiome(pos));
                    regionData.setY(blockNbt, this.strata.getTopY() == null ? regionData.getTopY(pos) : this.strata.getTopY());
                    chunkOk = this.paintStrata(this.strata, dayChunkImage, nightChunkImage, regionData, blockNbt, chunkMd, x, z, showSlope, cavePrePass) || chunkOk;
                }
            }
            regionData.writeChunk(chunkMd.getCoord(), chunkNbt);
        }
        catch (Throwable t) {
            Journeymap.getLogger().warn("Error rendering surface: ", t);
        }
        finally {
            this.strata.reset();
        }
        return chunkOk;
    }

    public int getSurfaceBlockHeight(ChunkMD chunkMd, int x, int z, BlockCoordIntPair offset, int defaultVal) {
        ChunkMD targetChunkMd = this.getOffsetChunk(chunkMd, x, z, offset);
        int newX = (chunkMd.getCoord().f_45578_ << 4) + (x + offset.x) & 0xF;
        int newZ = (chunkMd.getCoord().f_45579_ << 4) + (z + offset.z) & 0xF;
        if (targetChunkMd != null) {
            Integer height = this.getBlockHeight(targetChunkMd, newX, null, newZ, null, null);
            if (height == null) {
                return defaultVal;
            }
            return height;
        }
        return defaultVal;
    }

    @Override
    public Integer getBlockHeight(ChunkMD chunkMd, int localX, Integer vSlice, int localZ, Integer sliceMinY, Integer sliceMaxY) {
        Integer[][] heights = this.getHeights(chunkMd, null);
        if (heights == null) {
            return null;
        }
        Integer y = heights[localX][localZ];
        if (y != null) {
            return y;
        }
        y = Math.max(chunkMd.getMinY(), chunkMd.getPrecipitationHeight(localX, localZ));
        if (y.equals(chunkMd.getMinY())) {
            return chunkMd.getMinY();
        }
        boolean setFluidHeight = true;
        try {
            while (y > chunkMd.getMinY()) {
                Integer n;
                BlockMD blockMD = BlockMD.getBlockMDFromChunkLocal(chunkMd, localX, y, localZ);
                if (blockMD.isIgnore()) {
                    n = y;
                    y = y - 1;
                    continue;
                }
                if (blockMD.isWater() || blockMD.isFluid()) {
                    if (this.mapBathymetry) {
                        if (setFluidHeight) {
                            this.getFluidHeights((ChunkMD)chunkMd, null)[localZ][localX] = y;
                            setFluidHeight = false;
                        }
                        n = y;
                        y = y - 1;
                        continue;
                    }
                } else {
                    if (blockMD.hasTransparency() && this.mapTransparency) {
                        n = y;
                        y = y - 1;
                        continue;
                    }
                    if (!blockMD.isLava() && blockMD.hasNoShadow()) {
                        n = y;
                        y = y - 1;
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            Journeymap.getLogger().warn(String.format("Couldn't get safe surface block height for %s coords %s,%s: %s", chunkMd, localX, localZ, LogFormatter.toString(e)));
        }
        heights[localX][localZ] = y = Integer.valueOf(Math.max(chunkMd.getMinY(), y));
        return y;
    }

    protected void buildStrata(Strata strata, int upperY, ChunkMD chunkMd, RegionData regionData, CompoundTag blockNbt, int x, int lowerY, int z) {
        while (upperY > lowerY) {
            BlockMD topBlockMd = BlockMD.getBlockMDFromChunkLocal(chunkMd, x, upperY, z);
            if (!topBlockMd.isIgnore()) {
                if (topBlockMd.hasTransparency()) {
                    strata.push(chunkMd, topBlockMd, x, upperY, z);
                    if (!this.mapTransparency) break;
                }
                if (topBlockMd.hasNoShadow()) {
                    lowerY = upperY;
                    break;
                }
            }
            --upperY;
        }
        if (this.mapTransparency || strata.isEmpty()) {
            while (lowerY >= chunkMd.getMinY() && !((float)(upperY - lowerY) >= this.maxDepth)) {
                BlockMD bottomBlockMd = BlockMD.getBlockMDFromChunkLocal(chunkMd, x, lowerY, z);
                if (!bottomBlockMd.isIgnore()) {
                    strata.push(chunkMd, bottomBlockMd, x, lowerY, z);
                    if (!bottomBlockMd.hasTransparency() || !this.mapTransparency) break;
                }
                --lowerY;
            }
        }
        regionData.setBlockState(blockNbt, chunkMd, chunkMd.getBlockPos(x, upperY, z));
        regionData.setBlockState(blockNbt, chunkMd, chunkMd.getBlockPos(x, lowerY, z));
    }

    protected boolean paintStrata(Strata strata, NativeImage dayChunkImage, NativeImage nightChunkImage, RegionData regionData, CompoundTag blockNbt, ChunkMD chunkMd, int x, int z, boolean showSlope, boolean cavePrePass) {
        float slope;
        Integer y = strata.getTopY();
        if (strata.isEmpty() || y == null) {
            y = 0;
            if (dayChunkImage != null) {
                this.paintBadBlock(dayChunkImage, x, y, z);
            }
            if (nightChunkImage != null) {
                this.paintBadBlock(nightChunkImage, x, y, z);
            }
            return false;
        }
        while (!strata.isEmpty()) {
            Stratum stratum = strata.nextUp(this, true);
            if (strata.getRenderDayColor() == null || strata.getRenderNightColor() == null) {
                strata.setRenderDayColor(stratum.getDayColor());
                if (!cavePrePass) {
                    strata.setRenderNightColor(stratum.getNightColor());
                }
            } else {
                strata.setRenderDayColor(RGB.blendWith(strata.getRenderDayColor(), stratum.getDayColor(), stratum.getBlockMD().getAlpha()));
                if (!cavePrePass) {
                    strata.setRenderNightColor(RGB.blendWith(strata.getRenderNightColor(), stratum.getNightColor(), stratum.getBlockMD().getAlpha()));
                }
            }
            strata.release(stratum);
        }
        if (strata.getRenderDayColor() == null) {
            this.paintBadBlock(dayChunkImage, x, y, z);
            this.paintBadBlock(nightChunkImage, x, y, z);
            return false;
        }
        if (nightChunkImage != null && strata.getRenderNightColor() == null) {
            this.paintBadBlock(nightChunkImage, x, y, z);
            return false;
        }
        if (showSlope && (slope = this.getSlope(chunkMd, x, null, z)) != 1.0f) {
            strata.setRenderDayColor(RGB.bevelSlope(strata.getRenderDayColor(), slope));
            if (!cavePrePass) {
                strata.setRenderNightColor(RGB.bevelSlope(strata.getRenderNightColor(), slope));
            }
        }
        int dayColor = this.paintBlock(dayChunkImage, x, z, strata.getRenderDayColor());
        regionData.setBlockColor(blockNbt, dayColor, MapType.Name.day);
        if (nightChunkImage != null) {
            int nightColor = this.paintBlock(nightChunkImage, x, z, strata.getRenderNightColor());
            regionData.setBlockColor(blockNbt, nightColor, MapType.Name.night);
        }
        return true;
    }
}

