/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.cartography.render;

import com.mojang.blaze3d.platform.NativeImage;
import journeymap.client.cartography.IChunkRenderer;
import journeymap.client.cartography.color.RGB;
import journeymap.client.cartography.render.SurfaceRenderer;
import journeymap.client.log.StatTimer;
import journeymap.client.model.BlockMD;
import journeymap.client.model.ChunkMD;
import journeymap.client.model.MapType;
import journeymap.client.texture.ComparableNativeImage;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import journeymap.common.nbt.RegionData;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.biome.Biome;
import org.apache.logging.log4j.Level;

public class BiomeRenderer
extends SurfaceRenderer
implements IChunkRenderer {
    private static final String DEFAULT_LAND_CONTOUR_COLOR = "#3F250B";
    protected StatTimer renderTopoTimer = StatTimer.get("BiomeRenderer.renderSurface");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean render(ComparableNativeImage chunkImage, RegionData regionData, ChunkMD chunkMd, Integer vSlice) {
        StatTimer timer = this.renderTopoTimer;
        try {
            timer.start();
            this.updateOptions(chunkMd, MapType.from(MapType.Name.biome, null, chunkMd.getDimension()));
            boolean bl = this.renderSurface(chunkImage, regionData, chunkMd, vSlice, false);
            return bl;
        }
        catch (Throwable e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            timer.stop();
        }
    }

    protected boolean renderSurface(NativeImage chunkImage, RegionData regionData, ChunkMD chunkMd, Integer vSlice, boolean cavePrePass) {
        boolean chunkOk = false;
        try {
            CompoundTag chunkNbt = regionData.getChunkNbt(chunkMd.getCoord());
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    CompoundTag blockNbt = regionData.getBlockDataFromBlockPos(chunkMd.getCoord(), chunkNbt, x, z);
                    BlockMD topBlockMd = null;
                    int y = Math.max(0, this.getBlockHeight(chunkMd, x, null, z, null, null));
                    topBlockMd = chunkMd.getBlockMD(x, y, z);
                    if (topBlockMd == null) {
                        this.paintBadBlock(chunkImage, x, y, z);
                        continue;
                    }
                    chunkOk = this.paintBiome(chunkImage, regionData, blockNbt, chunkMd, topBlockMd, x, y, z) || chunkOk;
                }
            }
            regionData.writeChunk(chunkMd.getCoord(), chunkNbt);
        }
        catch (Throwable t) {
            Journeymap.getLogger().log(Level.WARN, "Error in renderSurface: " + LogFormatter.toString(t));
        }
        return chunkOk;
    }

    private boolean paintBiome(NativeImage chunkImage, RegionData regionData, CompoundTag blockNbt, ChunkMD chunkMd, BlockMD topBlockMd, int x, int y, int z) {
        if (!chunkMd.hasChunk()) {
            return false;
        }
        BlockPos blockPos = chunkMd.getBlockPos(x, y, z);
        Biome biome = chunkMd.getBiome(blockPos);
        if (biome == null) {
            return false;
        }
        try {
            boolean isWater = topBlockMd.isWater() || topBlockMd.isIce();
            boolean isFoliage = topBlockMd.isFoliage();
            int contourColor = RGB.hexToInt(DEFAULT_LAND_CONTOUR_COLOR);
            Integer color = this.isBiomeEdge(chunkMd, blockPos, biome) ? Integer.valueOf(contourColor) : (topBlockMd.isLava() ? Integer.valueOf(topBlockMd.getTextureColor()) : (isWater ? Integer.valueOf(biome.m_47560_()) : (isFoliage ? Integer.valueOf(biome.m_47542_()) : Integer.valueOf(biome.m_47464_((double)chunkMd.getCoord().f_45578_, (double)chunkMd.getCoord().f_45579_)))));
            int blockColor = this.paintBlock(chunkImage, x, z, color);
            regionData.setBlockColor(blockNbt, blockColor, MapType.Name.biome);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    private boolean isBiomeEdge(ChunkMD chunkMD, BlockPos pos, Biome blockBiome) {
        return false;
    }
}

