/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;

public class RootsUtil {
    private static final Random random = new Random();

    public static double randomDouble(double min, double max) {
        double range = max - min;
        double scale = random.nextDouble() * range;
        return scale + min;
    }

    public static BlockPos getRayTrace(Level levelAccessor, Player player, int reachDistance) {
        double x = player.m_20185_();
        double y = player.m_20186_() + (double)player.m_20192_();
        double z = player.m_20189_();
        int i = 0;
        while ((double)i < (double)reachDistance * 10.0) {
            if (levelAccessor.m_8055_(new BlockPos(x += player.m_20154_().f_82479_ * 0.1, y += player.m_20154_().f_82480_ * 0.1, z += player.m_20154_().f_82481_ * 0.1)).m_60734_() != Blocks.f_50016_) {
                return new BlockPos(x, y, z);
            }
            ++i;
        }
        return new BlockPos(x, y, z);
    }

    public static void addTickTracking(Entity entity) {
        if (entity.getPersistentData().m_128441_("RMOD_trackTicks")) {
            entity.getPersistentData().m_128405_("RMOD_trackTicks", entity.getPersistentData().m_128451_("RMOD_trackTicks") + 1);
        } else {
            entity.getPersistentData().m_128405_("RMOD_trackTicks", 1);
        }
    }

    public static void decrementTickTracking(Entity entity) {
        if (entity.getPersistentData().m_128441_("RMOD_trackTicks")) {
            entity.getPersistentData().m_128405_("RMOD_trackTicks", entity.getPersistentData().m_128451_("RMOD_trackTicks") - 1);
            if (entity.getPersistentData().m_128451_("RMOD_trackTicks") == 0) {
                entity.m_20137_("RMOD_trackTicks");
            }
        }
    }

    public static Entity getRayTraceEntity(Level levelAccessor, Player player, int reachDistance) {
        double x = player.m_20185_();
        double y = player.m_20186_() + (double)player.m_20192_();
        double z = player.m_20189_();
        int i = 0;
        while ((double)i < (double)reachDistance * 10.0) {
            List entities;
            if ((entities = levelAccessor.m_45976_(Entity.class, new AABB((x += player.m_20154_().f_82479_ * 0.1) - 0.1, (y += player.m_20154_().f_82480_ * 0.1) - 0.1, (z += player.m_20154_().f_82481_ * 0.1) - 0.1, x + 0.1, y + 0.1, z + 0.1))).size() > 0 && ((Entity)entities.get(0)).m_142081_() != player.m_142081_()) {
                return (Entity)entities.get(0);
            }
            ++i;
        }
        return null;
    }

    public static int intColor(int r, int g, int b) {
        return r * 65536 + g * 256 + b;
    }

    public static boolean itemListMatchInventoryWithSize(Container i1, List<ItemStack> i2) {
        int i;
        ArrayList<ItemStack> recipe = new ArrayList<ItemStack>();
        for (int i3 = 0; i3 < i1.m_6643_(); ++i3) {
            recipe.add(i1.m_8020_(i3));
        }
        ArrayList<ItemStack> available = new ArrayList<ItemStack>(i2);
        for (i = 0; i < recipe.size(); ++i) {
            if (!((ItemStack)recipe.get(i)).m_41619_()) continue;
            recipe.remove(i);
            --i;
        }
        for (i = 0; i < available.size(); ++i) {
            if (!available.get(i).m_41619_()) continue;
            available.remove(i);
            --i;
        }
        if (available.size() == recipe.size()) {
            for (ItemStack itemStack : available) {
                boolean endIteration = false;
                for (int i4 = 0; i4 < recipe.size() && !endIteration; ++i4) {
                    if (!itemStack.m_41656_((ItemStack)recipe.get(i4))) continue;
                    recipe.remove(i4);
                    endIteration = true;
                }
            }
        }
        return recipe.size() == 0;
    }

    public static boolean itemListMatchInventory(Container i1, List<ItemStack> i2) {
        int i;
        ArrayList<ItemStack> recipe = new ArrayList<ItemStack>();
        for (int i3 = 0; i3 < i1.m_6643_(); ++i3) {
            recipe.add(i1.m_8020_(i3));
        }
        ArrayList<ItemStack> available = new ArrayList<ItemStack>(i2);
        for (i = 0; i < recipe.size(); ++i) {
            if (!((ItemStack)recipe.get(i)).m_41619_()) continue;
            recipe.remove(i);
            --i;
        }
        for (i = 0; i < available.size(); ++i) {
            if (!available.get(i).m_41619_()) continue;
            available.remove(i);
            --i;
        }
        if (available.size() >= recipe.size()) {
            for (ItemStack itemStack : available) {
                boolean endIteration = false;
                for (int i4 = 0; i4 < recipe.size() && !endIteration; ++i4) {
                    if (!itemStack.m_41656_((ItemStack)recipe.get(i4))) continue;
                    recipe.remove(i4);
                    endIteration = true;
                }
            }
        }
        return recipe.size() == 0;
    }

    public static boolean itemListMatchesIngredients(List<Ingredient> i1, List<ItemStack> i2) {
        int i;
        ArrayList<Ingredient> recipe = new ArrayList<Ingredient>(i1);
        ArrayList<ItemStack> available = new ArrayList<ItemStack>(i2);
        for (i = 0; i < recipe.size(); ++i) {
            if (!recipe.get(i).m_43947_()) continue;
            recipe.remove(i);
            --i;
        }
        for (i = 0; i < available.size(); ++i) {
            if (!available.get(i).m_41619_()) continue;
            available.remove(i);
            --i;
        }
        if (available.size() >= recipe.size()) {
            for (ItemStack itemStack : available) {
                boolean endIteration = false;
                for (int i3 = 0; i3 < recipe.size() && !endIteration; ++i3) {
                    if (!recipe.get(i3).test(itemStack)) continue;
                    recipe.remove(i3);
                    endIteration = true;
                }
            }
        }
        return recipe.size() == 0;
    }

    public static boolean itemListMatchesIngredientsWithSize(List<Ingredient> i1, List<ItemStack> i2) {
        int i;
        ArrayList<Ingredient> recipe = new ArrayList<Ingredient>(i1);
        ArrayList<ItemStack> available = new ArrayList<ItemStack>(i2);
        for (i = 0; i < recipe.size(); ++i) {
            if (!recipe.get(i).m_43947_()) continue;
            recipe.remove(i);
            --i;
        }
        for (i = 0; i < available.size(); ++i) {
            if (!available.get(i).m_41619_()) continue;
            available.remove(i);
            --i;
        }
        if (available.size() == recipe.size()) {
            for (ItemStack itemStack : available) {
                boolean endIteration = false;
                for (int i3 = 0; i3 < recipe.size() && !endIteration; ++i3) {
                    if (!recipe.get(i3).test(itemStack)) continue;
                    recipe.remove(i3);
                    endIteration = true;
                }
            }
        }
        return recipe.size() == 0;
    }

    public static boolean itemListsMatchWithSize(List<ItemStack> i1, List<ItemStack> i2) {
        int i;
        ArrayList<ItemStack> recipe = new ArrayList<ItemStack>(i1);
        ArrayList<ItemStack> available = new ArrayList<ItemStack>(i2);
        for (i = 0; i < recipe.size(); ++i) {
            if (!recipe.get(i).m_41619_()) continue;
            recipe.remove(i);
            --i;
        }
        for (i = 0; i < available.size(); ++i) {
            if (!available.get(i).m_41619_()) continue;
            available.remove(i);
            --i;
        }
        if (available.size() == recipe.size()) {
            for (ItemStack itemStack : available) {
                boolean endIteration = false;
                for (int i3 = 0; i3 < recipe.size() && !endIteration; ++i3) {
                    if (!itemStack.m_41656_(recipe.get(i3))) continue;
                    recipe.remove(i3);
                    endIteration = true;
                }
            }
        }
        return recipe.size() == 0;
    }

    public static boolean itemListsMatch(List<ItemStack> i1, List<ItemStack> i2) {
        int i;
        ArrayList<ItemStack> recipe = new ArrayList<ItemStack>(i1);
        ArrayList<ItemStack> available = new ArrayList<ItemStack>(i2);
        for (i = 0; i < recipe.size(); ++i) {
            if (!recipe.get(i).m_41619_()) continue;
            recipe.remove(i);
            --i;
        }
        for (i = 0; i < available.size(); ++i) {
            if (!available.get(i).m_41619_()) continue;
            available.remove(i);
            --i;
        }
        if (available.size() >= recipe.size()) {
            for (ItemStack itemStack : available) {
                boolean endIteration = false;
                for (int i3 = 0; i3 < recipe.size() && !endIteration; ++i3) {
                    if (!itemStack.m_41656_(recipe.get(i3))) continue;
                    recipe.remove(i3);
                    endIteration = true;
                }
            }
        }
        return recipe.size() == 0;
    }

    public static boolean ingredientListMatch(List<Ingredient> i1, List<Ingredient> i2) {
        int i;
        ArrayList<Ingredient> recipe = new ArrayList<Ingredient>(i1);
        ArrayList<Ingredient> available = new ArrayList<Ingredient>(i2);
        for (i = 0; i < recipe.size(); ++i) {
            if (!recipe.get(i).m_43947_()) continue;
            recipe.remove(i);
            --i;
        }
        for (i = 0; i < available.size(); ++i) {
            if (!available.get(i).m_43947_()) continue;
            available.remove(i);
            --i;
        }
        if (available.size() >= recipe.size()) {
            for (Ingredient ingredient : available) {
                boolean endIteration = false;
                for (int i3 = 0; i3 < recipe.size() && !endIteration; ++i3) {
                    if (!ingredient.m_43908_()[0].m_41656_(recipe.get(i3).m_43908_()[0])) continue;
                    recipe.remove(i3);
                    endIteration = true;
                }
            }
        }
        return recipe.size() == 0;
    }

    public static void randomlyRepair(Random rnd, ItemStack stack) {
        if (stack.m_41768_() && rnd.nextInt(80) == 0) {
            stack.m_41721_(stack.m_41773_() - 1);
        }
    }
}

