/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.item;

import com.google.common.collect.ImmutableMap;
import elucent.rootsclassic.config.RootsConfig;
import elucent.rootsclassic.registry.RootsRegistry;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class DruidKnifeItem
extends Item {
    protected static final Map<Block, Block> BLOCK_STRIPPING_MAP = new ImmutableMap.Builder().put((Object)Blocks.f_50011_, (Object)Blocks.f_50044_).put((Object)Blocks.f_49999_, (Object)Blocks.f_50010_).put((Object)Blocks.f_50043_, (Object)Blocks.f_50049_).put((Object)Blocks.f_50004_, (Object)Blocks.f_50009_).put((Object)Blocks.f_50015_, (Object)Blocks.f_50048_).put((Object)Blocks.f_50003_, (Object)Blocks.f_50008_).put((Object)Blocks.f_50013_, (Object)Blocks.f_50046_).put((Object)Blocks.f_50001_, (Object)Blocks.f_50006_).put((Object)Blocks.f_50014_, (Object)Blocks.f_50047_).put((Object)Blocks.f_50002_, (Object)Blocks.f_50007_).put((Object)Blocks.f_50012_, (Object)Blocks.f_50045_).put((Object)Blocks.f_50000_, (Object)Blocks.f_50005_).build();
    protected static final Map<Block, Supplier<Item>> BLOCK_BARK_MAP = new ImmutableMap.Builder().put((Object)Blocks.f_50011_, RootsRegistry.OAK_BARK).put((Object)Blocks.f_49999_, RootsRegistry.OAK_BARK).put((Object)Blocks.f_50043_, RootsRegistry.DARK_OAK_BARK).put((Object)Blocks.f_50004_, RootsRegistry.DARK_OAK_BARK).put((Object)Blocks.f_50015_, RootsRegistry.ACACIA_BARK).put((Object)Blocks.f_50003_, RootsRegistry.ACACIA_BARK).put((Object)Blocks.f_50013_, RootsRegistry.BIRCH_BARK).put((Object)Blocks.f_50001_, RootsRegistry.BIRCH_BARK).put((Object)Blocks.f_50014_, RootsRegistry.JUNGLE_BARK).put((Object)Blocks.f_50002_, RootsRegistry.JUNGLE_BARK).put((Object)Blocks.f_50012_, RootsRegistry.SPRUCE_BARK).put((Object)Blocks.f_50000_, RootsRegistry.SPRUCE_BARK).build();

    public DruidKnifeItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level levelAccessor = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = levelAccessor.m_8055_(pos);
        BlockState strippedState = DruidKnifeItem.getStrippingState(state);
        ItemStack barkDrop = DruidKnifeItem.getBarkDrop(state);
        if (!barkDrop.m_41619_() && strippedState != null) {
            ItemStack stack = context.m_43722_();
            InteractionHand hand = context.m_43724_();
            Player playerIn = context.m_43723_();
            playerIn.m_5552_(barkDrop, 1.0f);
            stack.m_41622_(1, (LivingEntity)playerIn, e -> e.m_21190_(hand));
            if (levelAccessor.f_46441_.nextDouble() < (Double)RootsConfig.COMMON.barkKnifeBlockStripChance.get()) {
                levelAccessor.m_5594_(playerIn, pos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!levelAccessor.f_46443_) {
                    levelAccessor.m_7731_(pos, strippedState, 11);
                }
            }
            return InteractionResult.m_19078_((boolean)levelAccessor.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public static BlockState getStrippingState(BlockState originalState) {
        Block block = BLOCK_STRIPPING_MAP.get(originalState.m_60734_());
        return block != null ? (BlockState)block.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)((Direction.Axis)originalState.m_61143_((Property)RotatedPillarBlock.f_55923_))) : null;
    }

    public static ItemStack getBarkDrop(BlockState originalState) {
        Block block = originalState.m_60734_();
        if (BLOCK_BARK_MAP.containsKey(block)) {
            return new ItemStack((ItemLike)BLOCK_BARK_MAP.get(block).get());
        }
        return ItemStack.f_41583_;
    }
}

