/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.client.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import elucent.rootsclassic.Const;
import elucent.rootsclassic.capability.IManaCapability;
import elucent.rootsclassic.capability.RootsCapabilityManager;
import elucent.rootsclassic.client.ClientInfo;
import elucent.rootsclassic.config.RootsConfig;
import elucent.rootsclassic.item.IManaRelatedItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ManaBarEvent {
    private void drawQuad(BufferBuilder vertexConsumer, float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4, int minU, int minV, int maxU, int maxV) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        vertexConsumer.m_5483_((double)(x1 + 0.0f), (double)(y1 + 0.0f), 0.0).m_7421_((float)(minU + 0) * f, (float)(minV + maxV) * f1).m_5752_();
        vertexConsumer.m_5483_((double)(x2 + 0.0f), (double)(y2 + 0.0f), 0.0).m_7421_((float)(minU + maxU) * f, (float)(minV + maxV) * f1).m_5752_();
        vertexConsumer.m_5483_((double)(x3 + 0.0f), (double)(y3 + 0.0f), 0.0).m_7421_((float)(minU + maxU) * f, (float)(minV + 0) * f1).m_5752_();
        vertexConsumer.m_5483_((double)(x4 + 0.0f), (double)(y4 + 0.0f), 0.0).m_7421_((float)(minU + 0) * f, (float)(minV + 0) * f1).m_5752_();
    }

    @SubscribeEvent
    public void onGameOverlayRender(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.TEXT) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        boolean showBar = player.m_21205_().m_41720_() instanceof IManaRelatedItem || player.m_21206_().m_41720_() instanceof IManaRelatedItem;
        IManaCapability capability = (IManaCapability)player.getCapability(RootsCapabilityManager.MANA_CAPABILITY, null).orElse(null);
        if (!showBar || capability == null) {
            return;
        }
        if (capability.getMaxMana() > 0.0f) {
            this.drawManaBar(event, (Player)player, capability);
        }
    }

    private void drawManaBar(RenderGameOverlayEvent.Post event, Player player, IManaCapability capability) {
        PoseStack poseStack = event.getMatrixStack();
        RenderSystem.m_69465_();
        RenderSystem.m_69464_();
        poseStack.m_85836_();
        RenderSystem.m_69478_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)Const.manaBar);
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder b = tess.m_85915_();
        int w = event.getWindow().m_85445_();
        int h = event.getWindow().m_85446_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int manaNumber = Math.round(capability.getMana());
        int maxManaNumber = Math.round(capability.getMaxMana());
        int offsetX = 0;
        b.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        int manaBarOffset = (Integer)RootsConfig.CLIENT.manaBarOffset.get();
        while (maxManaNumber > 0) {
            this.drawQuad(b, w / 2 + 10 + offsetX, h - (manaBarOffset - 9), w / 2 + 19 + offsetX, h - (manaBarOffset - 9), w / 2 + 19 + offsetX, h - manaBarOffset, w / 2 + 10 + offsetX, h - manaBarOffset, 0, 0, 9, 9);
            if (maxManaNumber > 4) {
                maxManaNumber -= 4;
                offsetX += 8;
                continue;
            }
            maxManaNumber = 0;
        }
        offsetX = 0;
        while (manaNumber > 0) {
            if (manaNumber > 4) {
                this.drawQuad(b, w / 2 + 10 + offsetX, h - (manaBarOffset - 9), w / 2 + 19 + offsetX, h - (manaBarOffset - 9), w / 2 + 19 + offsetX, h - manaBarOffset, w / 2 + 10 + offsetX, h - manaBarOffset, 0, 16, 9, 9);
                manaNumber -= 4;
                offsetX += 8;
                continue;
            }
            if (manaNumber == 4) {
                this.drawQuad(b, w / 2 + 10 + offsetX, h - (manaBarOffset - 9), w / 2 + 19 + offsetX, h - (manaBarOffset - 9), w / 2 + 19 + offsetX, h - manaBarOffset, w / 2 + 10 + offsetX, h - manaBarOffset, 0, 16, 9, 9);
            }
            if (manaNumber == 3) {
                this.drawQuad(b, w / 2 + 10 + offsetX, h - (manaBarOffset - 9), w / 2 + 19 + offsetX, h - (manaBarOffset - 9), w / 2 + 19 + offsetX, h - manaBarOffset, w / 2 + 10 + offsetX, h - manaBarOffset, 16, 16, 9, 9);
            }
            if (manaNumber == 2) {
                this.drawQuad(b, w / 2 + 10 + offsetX, h - (manaBarOffset - 9), w / 2 + 19 + offsetX, h - (manaBarOffset - 9), w / 2 + 19 + offsetX, h - manaBarOffset, w / 2 + 10 + offsetX, h - manaBarOffset, 32, 16, 9, 9);
            }
            if (manaNumber == 1) {
                this.drawQuad(b, w / 2 + 10 + offsetX, h - (manaBarOffset - 9), w / 2 + 19 + offsetX, h - (manaBarOffset - 9), w / 2 + 19 + offsetX, h - manaBarOffset, w / 2 + 10 + offsetX, h - manaBarOffset, 48, 16, 9, 9);
            }
            manaNumber = 0;
        }
        tess.m_85914_();
        RenderSystem.m_69461_();
        poseStack.m_85849_();
        RenderSystem.m_69481_();
        RenderSystem.m_69482_();
    }

    @SubscribeEvent
    public void clientTickEnd(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ++ClientInfo.ticksInGame;
        }
    }
}

