/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.block.imbuer;

import elucent.rootsclassic.blockentity.BEBase;
import elucent.rootsclassic.client.particles.MagicLineParticleData;
import elucent.rootsclassic.component.ComponentBase;
import elucent.rootsclassic.component.ComponentBaseRegistry;
import elucent.rootsclassic.item.SpellPowderItem;
import elucent.rootsclassic.item.StaffItem;
import elucent.rootsclassic.registry.RootsRegistry;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class ImbuerBlockEntity
extends BEBase {
    private static final int STICK = 0;
    private static final int DUST = 1;
    public int progress = 0;
    public int spin = 0;
    public final ItemStackHandler inventory = new ItemStackHandler(2){

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            return 1;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            if (slot == 0) {
                return stack.m_204117_(Tags.Items.RODS_WOODEN);
            }
            return stack.m_41720_() instanceof SpellPowderItem;
        }
    };
    private LazyOptional<IItemHandler> inventoryHolder = LazyOptional.of(() -> this.inventory);

    public ImbuerBlockEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public ImbuerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RootsRegistry.IMBUER_TILE.get(), pos, state);
    }

    public ItemStack getStick() {
        return this.inventory.getStackInSlot(0);
    }

    public ItemStack getSpellPowder() {
        return this.inventory.getStackInSlot(1);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inventory.deserializeNBT(tag.m_128469_("InventoryHandler"));
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("InventoryHandler", (Tag)this.inventory.serializeNBT());
    }

    @Override
    public void breakBlock(Level levelAccessor, BlockPos pos, BlockState state, Player player) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.m_41619_() || levelAccessor.f_46443_) continue;
            levelAccessor.m_7967_((Entity)new ItemEntity(levelAccessor, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, stack));
        }
        this.m_7651_();
    }

    @Override
    public InteractionResult activate(Level levelAccessor, BlockPos pos, BlockState state, Player player, InteractionHand hand, ItemStack heldItem, BlockHitResult hit) {
        if (this.progress == 0 && hand == InteractionHand.MAIN_HAND) {
            if (heldItem.m_41619_()) {
                if (!this.getStick().m_41619_()) {
                    if (!levelAccessor.f_46443_) {
                        levelAccessor.m_7967_((Entity)new ItemEntity(levelAccessor, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, this.getStick()));
                    }
                    this.inventory.setStackInSlot(0, ItemStack.f_41583_);
                    this.m_6596_();
                    levelAccessor.m_7260_(this.m_58899_(), state, levelAccessor.m_8055_(pos), 3);
                    return InteractionResult.SUCCESS;
                }
                if (!this.getSpellPowder().m_41619_()) {
                    if (!levelAccessor.f_46443_) {
                        levelAccessor.m_7967_((Entity)new ItemEntity(levelAccessor, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, this.getSpellPowder()));
                    }
                    this.inventory.setStackInSlot(1, ItemStack.f_41583_);
                    this.m_6596_();
                    levelAccessor.m_7260_(this.m_58899_(), state, levelAccessor.m_8055_(pos), 3);
                    return InteractionResult.SUCCESS;
                }
            } else if (heldItem.m_204117_(Tags.Items.RODS_WOODEN)) {
                if (this.getStick().m_41619_()) {
                    ItemStack copyStack = heldItem.m_41777_();
                    copyStack.m_41764_(1);
                    this.inventory.setStackInSlot(0, copyStack);
                    heldItem.m_41774_(1);
                    this.m_6596_();
                    levelAccessor.m_7260_(this.m_58899_(), state, levelAccessor.m_8055_(pos), 3);
                    return InteractionResult.SUCCESS;
                }
            } else if (heldItem.m_41720_() == RootsRegistry.SPELL_POWDER.get() && this.getSpellPowder().m_41619_()) {
                ItemStack copyStack = heldItem.m_41777_();
                copyStack.m_41764_(1);
                this.inventory.setStackInSlot(1, copyStack);
                heldItem.m_41774_(1);
                this.m_6596_();
                levelAccessor.m_7260_(this.m_58899_(), state, levelAccessor.m_8055_(pos), 3);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, ImbuerBlockEntity tile) {
        tile.spin = tile.progress == 0 ? (tile.spin += 4) : (tile.spin += 12);
        ItemStack dustStack = tile.getSpellPowder();
        ItemStack stickStack = tile.getStick();
        if (!dustStack.m_41619_() && !stickStack.m_41619_()) {
            ++tile.progress;
        }
        if (tile.progress != 0 && tile.progress % 1 == 0 && tile.progress > 40) {
            tile.progress = 0;
            if (!dustStack.m_41619_() && !stickStack.m_41619_() && dustStack.m_41782_()) {
                ItemStack staff = new ItemStack((ItemLike)RootsRegistry.STAFF.get(), 1);
                CompoundTag tag = dustStack.m_41783_();
                String effectName = tag.m_128461_("rootsclassic:effect");
                int potency = tag.m_128451_("rootsclassic:potency");
                int duration = tag.m_128451_("rootsclassic:efficiency");
                int size = tag.m_128451_("rootsclassic:size");
                StaffItem.createData(staff, effectName, potency, duration, size);
                if (!level.f_46443_) {
                    level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, staff));
                }
                tile.inventory.setStackInSlot(0, ItemStack.f_41583_);
                tile.inventory.setStackInSlot(1, ItemStack.f_41583_);
                tile.m_6596_();
                level.m_7260_(pos, state, state, 3);
            }
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, ImbuerBlockEntity tile) {
        tile.spin = tile.progress == 0 ? (tile.spin += 4) : (tile.spin += 12);
        ItemStack dustStack = tile.getSpellPowder();
        ItemStack stickStack = tile.getStick();
        if (!dustStack.m_41619_() && !stickStack.m_41619_()) {
            ++tile.progress;
        }
        if (tile.progress != 0 && tile.progress % 1 == 0) {
            ComponentBase comp;
            ResourceLocation compName;
            CompoundTag tag;
            int chance = level.f_46441_.nextInt(4);
            if (dustStack.m_41782_() && (tag = dustStack.m_41783_()).m_128441_("rootsclassic:effect") && (compName = ResourceLocation.m_135820_((String)tag.m_128461_("rootsclassic:effect"))) != null && (comp = (ComponentBase)ComponentBaseRegistry.COMPONENTS.get().getValue(compName)) != null && level.f_46443_) {
                if (chance == 0) {
                    if (level.f_46441_.nextBoolean()) {
                        level.m_7106_(MagicLineParticleData.createData(comp.primaryColor.f_82479_, comp.primaryColor.f_82480_, comp.primaryColor.f_82481_), (double)pos.m_123341_() + 0.125, (double)pos.m_123342_() + 0.125, (double)pos.m_123343_() + 0.125, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.625, (double)pos.m_123343_() + 0.5);
                    } else {
                        level.m_7106_(MagicLineParticleData.createData(comp.secondaryColor.f_82479_, comp.secondaryColor.f_82480_, comp.secondaryColor.f_82481_), (double)pos.m_123341_() + 0.125, (double)pos.m_123342_() + 0.125, (double)pos.m_123343_() + 0.125, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.625, (double)pos.m_123343_() + 0.5);
                    }
                }
                if (chance == 1) {
                    if (level.f_46441_.nextBoolean()) {
                        level.m_7106_(MagicLineParticleData.createData(comp.primaryColor.f_82479_, comp.primaryColor.f_82480_, comp.primaryColor.f_82481_), (double)pos.m_123341_() + 0.875, (double)pos.m_123342_() + 0.125, (double)pos.m_123343_() + 0.125, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.625, (double)pos.m_123343_() + 0.5);
                    } else {
                        level.m_7106_(MagicLineParticleData.createData(comp.secondaryColor.f_82479_, comp.secondaryColor.f_82480_, comp.secondaryColor.f_82481_), (double)pos.m_123341_() + 0.875, (double)pos.m_123342_() + 0.125, (double)pos.m_123343_() + 0.125, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.625, (double)pos.m_123343_() + 0.5);
                    }
                }
                if (chance == 2) {
                    if (level.f_46441_.nextBoolean()) {
                        level.m_7106_(MagicLineParticleData.createData(comp.primaryColor.f_82479_, comp.primaryColor.f_82480_, comp.primaryColor.f_82481_), (double)pos.m_123341_() + 0.875, (double)pos.m_123342_() + 0.125, (double)pos.m_123343_() + 0.875, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.625, (double)pos.m_123343_() + 0.5);
                    } else {
                        level.m_7106_(MagicLineParticleData.createData(comp.secondaryColor.f_82479_, comp.secondaryColor.f_82480_, comp.secondaryColor.f_82481_), (double)pos.m_123341_() + 0.875, (double)pos.m_123342_() + 0.125, (double)pos.m_123343_() + 0.875, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.625, (double)pos.m_123343_() + 0.5);
                    }
                }
                if (chance == 3) {
                    if (level.f_46441_.nextBoolean()) {
                        level.m_7106_(MagicLineParticleData.createData(comp.primaryColor.f_82479_, comp.primaryColor.f_82480_, comp.primaryColor.f_82481_), (double)pos.m_123341_() + 0.125, (double)pos.m_123342_() + 0.125, (double)pos.m_123343_() + 0.875, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.625, (double)pos.m_123343_() + 0.5);
                    } else {
                        level.m_7106_(MagicLineParticleData.createData(comp.secondaryColor.f_82479_, comp.secondaryColor.f_82480_, comp.secondaryColor.f_82481_), (double)pos.m_123341_() + 0.125, (double)pos.m_123342_() + 0.125, (double)pos.m_123343_() + 0.875, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.625, (double)pos.m_123343_() + 0.5);
                    }
                }
            }
            if (tile.progress > 40) {
                tile.progress = 0;
            }
        }
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.inventoryHolder.invalidate();
    }
}

