/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.scm.network;

import com.mojang.math.Vector3f;
import com.technicalitiesmc.lib.circuit.component.ComponentSlot;
import com.technicalitiesmc.lib.math.VecDirection;
import com.technicalitiesmc.lib.network.Packet;
import com.technicalitiesmc.scm.block.CircuitBlock;
import com.technicalitiesmc.scm.circuit.TileAccessor;
import com.technicalitiesmc.scm.circuit.server.ServerTileAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.network.NetworkEvent;

public class ComponentUsePacket
implements Packet {
    private static final Capability<CircuitBlock.Data> DATA_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<CircuitBlock.Data>(){});
    private final BlockPos pos;
    private final Vec3i componentPos;
    private final ComponentSlot slot;
    private final InteractionHand hand;
    private final VecDirection sideHit;
    private final Vector3f hitPos;

    public ComponentUsePacket(BlockPos pos, Vec3i componentPos, ComponentSlot slot, InteractionHand hand, VecDirection sideHit, Vector3f hitPos) {
        this.pos = pos;
        this.componentPos = componentPos;
        this.slot = slot;
        this.hand = hand;
        this.sideHit = sideHit;
        this.hitPos = hitPos;
    }

    public ComponentUsePacket(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.componentPos = buf.m_130135_();
        this.slot = (ComponentSlot)buf.m_130066_(ComponentSlot.class);
        this.hand = (InteractionHand)buf.m_130066_(InteractionHand.class);
        this.sideHit = (VecDirection)buf.m_130066_(VecDirection.class);
        this.hitPos = new Vector3f(buf.readFloat(), buf.readFloat(), buf.readFloat());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130064_(new BlockPos(this.componentPos));
        buf.m_130068_((Enum)this.slot);
        buf.m_130068_((Enum)this.hand);
        buf.m_130068_((Enum)this.sideHit);
        buf.writeFloat(this.hitPos.m_122239_()).writeFloat(this.hitPos.m_122260_()).writeFloat(this.hitPos.m_122269_());
    }

    public boolean handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            ServerLevel level = context.getSender().m_183503_();
            BlockEntity entity = level.m_7702_(this.pos);
            if (entity == null) {
                return;
            }
            CircuitBlock.Data data = (CircuitBlock.Data)entity.getCapability(DATA_CAPABILITY).orElse(null);
            if (data == null) {
                return;
            }
            TileAccessor accessor = data.getOrCreateAccessor();
            if (accessor instanceof ServerTileAccessor) {
                ServerTileAccessor sta = (ServerTileAccessor)accessor;
                sta.use(this.componentPos, this.slot, (Player)context.getSender(), this.hand, this.sideHit, this.hitPos);
            }
        });
        return true;
    }
}

