/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.scm.component3;

import com.technicalitiesmc.lib.circuit.component.ComponentSlot;
import com.technicalitiesmc.lib.circuit.component.ComponentState;
import com.technicalitiesmc.lib.math.VecDirection;
import com.technicalitiesmc.scm.api2.logical.SideEffects;
import com.technicalitiesmc.scm.api2.logical.StateLike;
import com.technicalitiesmc.scm.api2.signal.InputPort;
import com.technicalitiesmc.scm.api2.signal.OutputPort;
import com.technicalitiesmc.scm.api2.signal.PortBuilder;
import com.technicalitiesmc.scm.api2.signal.SignalMap;
import com.technicalitiesmc.scm.api2.signal.SignalPorts;
import com.technicalitiesmc.scm.api2.signal.SignalType;
import com.technicalitiesmc.scm.api3.CircuitPos;
import com.technicalitiesmc.scm.api3.component.CircuitComponent;
import com.technicalitiesmc.scm.component3.SimpleCircuitComponent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TorchComponent
extends SimpleCircuitComponent<State, Void> {
    public static final CircuitComponent.Footprint FOOTPRINT = new CircuitComponent.Footprint(1, 2, 1, ComponentSlot.DEFAULT, ComponentSlot.OVERLAY);
    private static final VoxelShape SHAPE = Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)1.0, (double)0.8125);
    private static final Property<Boolean> PROP_ON = BooleanProperty.m_61465_((String)"on");
    private final InputPort<Integer> input;
    private final OutputPort<Integer> output;

    public TorchComponent(PortBuilder<State> ports) {
        super(FOOTPRINT, SHAPE, State.DEFAULT, State::new, PROP_ON);
        this.input = ports.addInput("in", SignalType.redstone());
        this.output = ports.addOutput("out", SignalType.redstone(), State::outputValue);
    }

    @Override
    public StateLike<State> onNewInputs(State state, SignalMap signals) {
        return SideEffects.scheduleTick(state, 1);
    }

    @Override
    public StateLike<State> tick(State state, SignalMap signals) {
        return new State(signals.get(this.input) == 0);
    }

    @Override
    public <T> SignalPorts<T> getPorts(CircuitComponent.Metadata metadata, State state, CircuitPos pos, VecDirection side, SignalType<T> signalType) {
        InputPort<Integer> in = pos.is(0, 0, 0) ? this.input : null;
        OutputPort<Integer> out = side != VecDirection.NEG_Y ? this.output : null;
        return SignalPorts.of(signalType).when(SignalType.redstone(), in, out).build();
    }

    @Override
    public ComponentState getVisualState(CircuitComponent.Metadata metadata, State state) {
        return (ComponentState)this.baseVisualState().m_61124_(PROP_ON, (Comparable)Boolean.valueOf(state.on));
    }

    @Override
    public ItemStack getPicked(ComponentState visualState) {
        return new ItemStack((ItemLike)Items.f_41978_);
    }

    public record State(boolean on) implements CircuitComponent.State<State>
    {
        public static final State DEFAULT = new State(true);

        public State(CompoundTag tag) {
            this(tag.m_128471_("on"));
        }

        private int outputValue() {
            return this.on() ? 255 : 0;
        }

        @Override
        public CompoundTag save() {
            CompoundTag tag = new CompoundTag();
            tag.m_128379_("on", this.on);
            return tag;
        }
    }
}

