/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.scm.component.wire;

import com.mojang.math.Vector3f;
import com.technicalitiesmc.lib.circuit.component.CircuitComponent;
import com.technicalitiesmc.lib.circuit.component.CircuitEvent;
import com.technicalitiesmc.lib.circuit.component.ClientComponent;
import com.technicalitiesmc.lib.circuit.component.ComponentContext;
import com.technicalitiesmc.lib.circuit.component.ComponentState;
import com.technicalitiesmc.lib.circuit.component.ComponentStateBuilder;
import com.technicalitiesmc.lib.circuit.interfaces.RedstoneSink;
import com.technicalitiesmc.lib.circuit.interfaces.RedstoneSource;
import com.technicalitiesmc.lib.circuit.interfaces.wire.BundledWire;
import com.technicalitiesmc.lib.circuit.interfaces.wire.RedstoneConductor;
import com.technicalitiesmc.lib.circuit.interfaces.wire.RedstoneWire;
import com.technicalitiesmc.lib.circuit.interfaces.wire.Wire;
import com.technicalitiesmc.lib.circuit.interfaces.wire.WireConnectionState;
import com.technicalitiesmc.lib.init.TKLibItemTags;
import com.technicalitiesmc.lib.math.VecDirection;
import com.technicalitiesmc.lib.math.VecDirectionFlags;
import com.technicalitiesmc.lib.util.Utils;
import com.technicalitiesmc.scm.component.InterfaceLookup;
import com.technicalitiesmc.scm.component.wire.HorizontalWireComponentBase;
import com.technicalitiesmc.scm.component.wire.WireUtils;
import com.technicalitiesmc.scm.init.SCMComponents;
import com.technicalitiesmc.scm.init.SCMItems;
import com.technicalitiesmc.scm.network.PickPaletteColorPacket;
import com.technicalitiesmc.scm.network.SCMNetworkHandler;
import java.util.Arrays;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class ColoredWireComponent
extends HorizontalWireComponentBase<ColoredWireComponent>
implements RedstoneWire {
    private static final AABB BOUNDS = new AABB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
    public static final Property<WireConnectionState.Visual> PROP_NEG_X = EnumProperty.m_61587_((String)"neg_x", WireConnectionState.Visual.class);
    public static final Property<WireConnectionState.Visual> PROP_POS_X = EnumProperty.m_61587_((String)"pos_x", WireConnectionState.Visual.class);
    public static final Property<WireConnectionState.Visual> PROP_NEG_Z = EnumProperty.m_61587_((String)"neg_z", WireConnectionState.Visual.class);
    public static final Property<WireConnectionState.Visual> PROP_POS_Z = EnumProperty.m_61587_((String)"pos_z", WireConnectionState.Visual.class);
    public static final Property<DyeColor> PROP_EXT_COLOR = EnumProperty.m_61587_((String)"color", DyeColor.class);
    private static final Property<Integer> PROP_EXT_POWER = IntegerProperty.m_61631_((String)"power", (int)0, (int)255);
    private static final InterfaceLookup<ColoredWireComponent> INTERFACES = InterfaceLookup.builder().with(RedstoneSource.class, ColoredWireComponent::getRedstoneSource).with(RedstoneSink.class, ColoredWireComponent::getRedstoneSink).with(Wire.class, c -> c).with(RedstoneWire.class, c -> c).with(BundledWire.class, VecDirectionFlags.verticals(), ColoredWireComponent::getBundledWire).build();
    private final int[] sideInputs = new int[VecDirection.VALUES.length];
    private final Conductor conductor = new Conductor();
    private DyeColor color = DyeColor.LIGHT_GRAY;
    private int power;

    public ColoredWireComponent(ComponentContext context) {
        super(SCMComponents.REDSTONE_WIRE, context, INTERFACES);
    }

    public ColoredWireComponent(ComponentContext context, DyeColor color) {
        this(context);
        this.color = color;
    }

    public ComponentState getState() {
        return ((ComponentState)((ComponentState)((ComponentState)((ComponentState)super.getState().m_61124_(PROP_NEG_X, (Comparable)this.getState(VecDirection.NEG_X).getVisualState())).m_61124_(PROP_POS_X, (Comparable)this.getState(VecDirection.POS_X).getVisualState())).m_61124_(PROP_NEG_Z, (Comparable)this.getState(VecDirection.NEG_Z).getVisualState())).m_61124_(PROP_POS_Z, (Comparable)this.getState(VecDirection.POS_Z).getVisualState())).setExtended(PROP_EXT_COLOR, (Comparable)this.color).setExtended(PROP_EXT_POWER, (Comparable)Integer.valueOf(this.power));
    }

    public AABB getBoundingBox() {
        return BOUNDS;
    }

    public ItemStack getPickedItem() {
        return new ItemStack((ItemLike)SCMItems.TINY_REDSTONE.get());
    }

    @Override
    protected WireConnectionState getNextState(VecDirection side, WireConnectionState state, CircuitComponent neighbor, boolean forced) {
        RedstoneWire rsWire;
        WireConnectionState nextState = WireUtils.getNextState(side, state, neighbor, RedstoneSource.class, RedstoneSink.class);
        if (!forced && nextState == WireConnectionState.WIRE && (rsWire = (RedstoneWire)neighbor.getInterface(side.getOpposite(), RedstoneWire.class)) != null && rsWire.getColor() != null && rsWire.getColor() != this.color) {
            return WireConnectionState.FORCE_DISCONNECTED;
        }
        return nextState;
    }

    @Override
    protected boolean isValidState(VecDirection side, WireConnectionState state, CircuitComponent neighbor) {
        return WireUtils.isValidState(side, state, neighbor, RedstoneSource.class, RedstoneSink.class);
    }

    @Override
    protected void onStateTransition(VecDirection side, WireConnectionState prevState, WireConnectionState newState) {
        Wire wire;
        CircuitComponent neighbor;
        this.sendEvent(CircuitEvent.NEIGHBOR_CHANGED, new VecDirection[]{side});
        if (prevState == WireConnectionState.OUTPUT || newState == WireConnectionState.OUTPUT) {
            this.sendEvent(CircuitEvent.REDSTONE, new VecDirection[]{side});
        }
        if (prevState == WireConnectionState.WIRE || newState == WireConnectionState.WIRE) {
            this.conductor.invalidateNetwork();
        }
        if ((neighbor = this.findConnectionTarget(side)) != null && (wire = (Wire)neighbor.getInterface(side.getOpposite(), Wire.class)) != null) {
            wire.setState(side.getOpposite(), newState.getOpposite());
        }
    }

    @Override
    protected void updateSignals(VecDirectionFlags sides) {
        for (VecDirection side : sides) {
            boolean isInput = this.getStateInternal(side) == WireConnectionState.INPUT;
            this.sideInputs[side.ordinal()] = isInput ? this.getInput(side) : 0;
        }
        int newInput = Arrays.stream(this.sideInputs).max().orElse(0);
        this.conductor.setInput(newInput);
    }

    private int getInput(VecDirection side) {
        CircuitComponent neighbor = this.findConnectionTarget(side);
        if (neighbor == null) {
            return 0;
        }
        RedstoneSource redstoneSource = (RedstoneSource)neighbor.getInterface(side.getOpposite(), RedstoneSource.class);
        if (redstoneSource != null) {
            return redstoneSource.getWeakOutput();
        }
        BundledWire wire = (BundledWire)neighbor.getInterface(side.getOpposite(), BundledWire.class);
        if (wire != null) {
            RedstoneConductor conductor = wire.getConductor(this.color);
            return conductor != null ? conductor.getPower() : 0;
        }
        return 0;
    }

    public void updateSequential() {
        super.updateSequential();
        this.conductor.doSequentialUpdate();
    }

    @Override
    public InteractionResult use(Player player, InteractionHand hand, VecDirection sideHit, Vector3f hit) {
        DyeColor dyeColor;
        ItemStack stack = player.m_21120_(hand);
        DyeColor dyeColor2 = dyeColor = !stack.m_41619_() ? Utils.getDyeColor((ItemStack)stack) : null;
        if (dyeColor != null) {
            this.updateExternalState(true, () -> {
                this.color = dyeColor;
            });
            this.conductor.invalidateNetwork();
            return InteractionResult.m_19078_((boolean)player.f_19853_.m_5776_());
        }
        return super.use(player, hand, sideHit, hit);
    }

    public DyeColor getColor() {
        return this.color;
    }

    public RedstoneConductor getConductor() {
        return this.conductor;
    }

    @Override
    public CompoundTag save(CompoundTag tag) {
        tag = super.save(tag);
        tag.m_128385_("side_inputs", Arrays.copyOf(this.sideInputs, this.sideInputs.length));
        tag.m_128405_("color", this.color.m_41060_());
        tag.m_128405_("power", this.power);
        return tag;
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        int[] inputs = tag.m_128465_("side_inputs");
        System.arraycopy(inputs, 0, this.sideInputs, 0, this.sideInputs.length);
        this.conductor.setInputOnLoad(Arrays.stream(this.sideInputs).max().orElse(0));
        this.color = DyeColor.m_41053_((int)tag.m_128451_("color"));
        this.power = tag.m_128451_("power");
    }

    private RedstoneSource getRedstoneSource(VecDirection side) {
        if (this.getState(side) != WireConnectionState.OUTPUT) {
            return null;
        }
        return RedstoneSource.of((int)this.power, (int)this.power);
    }

    private RedstoneSink getRedstoneSink(VecDirection side) {
        if (this.getState(side) != WireConnectionState.INPUT) {
            return null;
        }
        return RedstoneSink.instance();
    }

    private BundledWire getBundledWire(VecDirection side) {
        if (this.getState(side.getOpposite()) != WireConnectionState.WIRE) {
            return null;
        }
        CircuitComponent neighbor = this.findConnectionTarget(side.getOpposite());
        if (neighbor == null) {
            return null;
        }
        BundledWire neighborBundled = (BundledWire)neighbor.getInterface(side, BundledWire.class);
        if (neighborBundled == null) {
            return null;
        }
        return color -> color == this.color ? this.conductor : neighborBundled.getConductor(color);
    }

    public static void createState(ComponentStateBuilder builder) {
        builder.add(new Property[]{PROP_NEG_X, PROP_POS_X, PROP_NEG_Z, PROP_POS_Z});
        builder.addExtended(new Property[]{PROP_EXT_COLOR, PROP_EXT_POWER});
    }

    public final class Conductor
    extends RedstoneConductor {
        public int getPower() {
            return ColoredWireComponent.this.power;
        }

        public void visit(RedstoneConductor.Visitor visitor) {
            for (VecDirection side : VecDirection.VALUES) {
                CircuitComponent neighbor;
                if (ColoredWireComponent.this.getStateInternal(side) != WireConnectionState.WIRE || (neighbor = ColoredWireComponent.this.findConnectionTarget(side)) == null) continue;
                RedstoneWire rsWire = (RedstoneWire)neighbor.getInterface(side.getOpposite(), RedstoneWire.class);
                if (rsWire != null) {
                    visitor.accept(rsWire.getConductor());
                    continue;
                }
                BundledWire bundledWire = (BundledWire)neighbor.getInterface(side.getOpposite(), BundledWire.class);
                if (bundledWire == null) continue;
                visitor.accept(bundledWire.getConductor(ColoredWireComponent.this.color));
            }
        }

        public void onPropagated(int newPower) {
            ColoredWireComponent.this.updateExternalState(true, () -> {
                ColoredWireComponent.this.power = newPower;
            });
            VecDirectionFlags sides = VecDirectionFlags.none();
            for (VecDirection side : VecDirection.VALUES) {
                if (ColoredWireComponent.this.getStateInternal(side) != WireConnectionState.OUTPUT) continue;
                sides = (VecDirectionFlags)sides.and((Enum)side);
            }
            ColoredWireComponent.this.sendEvent(CircuitEvent.REDSTONE, sides);
        }

        public void scheduleSequentialUpdate() {
            ColoredWireComponent.this.scheduleSequential();
        }
    }

    public static class Client
    extends ClientComponent {
        public AABB getBoundingBox(ComponentState state) {
            return BOUNDS;
        }

        public ItemStack getPickedItem(ComponentState state) {
            return new ItemStack((ItemLike)SCMItems.TINY_REDSTONE.get());
        }

        public void onPicking(ComponentState state, Player player) {
            ItemStack stack = player.m_21206_();
            if (!stack.m_41619_() && stack.m_150930_((Item)SCMItems.PALETTE.get())) {
                SCMNetworkHandler.sendToServer(new PickPaletteColorPacket((DyeColor)state.getExtended(PROP_EXT_COLOR)));
            }
        }

        public InteractionResult use(ComponentState state, Player player, InteractionHand hand, VecDirection sideHit, Vector3f hit) {
            ItemStack offHandStack;
            ItemStack stack = player.m_21120_(hand);
            if (!stack.m_41619_() && (stack.m_204117_(TKLibItemTags.TOOLS_WRENCH) || Utils.getDyeColor((ItemStack)stack) != null)) {
                return InteractionResult.m_19078_((boolean)true);
            }
            if (hand == InteractionHand.MAIN_HAND && stack.m_150930_((Item)SCMItems.TINY_REDSTONE.get()) && Utils.getDyeColor((ItemStack)(offHandStack = player.m_21206_())) != null) {
                return InteractionResult.FAIL;
            }
            return super.use(state, player, hand, sideHit, hit);
        }

        public int getTint(ComponentState state, int tintIndex) {
            return switch (tintIndex) {
                case 0 -> ((DyeColor)state.getExtended(PROP_EXT_COLOR)).m_41070_();
                case 1 -> {
                    Integer power = (Integer)state.getExtended(PROP_EXT_POWER);
                    int minBrightness = 128;
                    int pow = (int)((float)power.intValue() / 255.0f * (float)(255 - minBrightness) + (float)minBrightness);
                    yield pow << 16 | pow << 8 | pow;
                }
                default -> super.getTint(state, tintIndex);
            };
        }
    }
}

