/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.scm.component.digital;

import com.technicalitiesmc.lib.circuit.component.CircuitComponent;
import com.technicalitiesmc.lib.circuit.component.CircuitEvent;
import com.technicalitiesmc.lib.circuit.component.ClientComponent;
import com.technicalitiesmc.lib.circuit.component.ComponentContext;
import com.technicalitiesmc.lib.circuit.component.ComponentEventMap;
import com.technicalitiesmc.lib.circuit.component.ComponentHarvestContext;
import com.technicalitiesmc.lib.circuit.component.ComponentSlot;
import com.technicalitiesmc.lib.circuit.component.ComponentState;
import com.technicalitiesmc.lib.circuit.component.ComponentType;
import com.technicalitiesmc.lib.circuit.interfaces.RedstoneSink;
import com.technicalitiesmc.lib.circuit.interfaces.RedstoneSource;
import com.technicalitiesmc.lib.math.VecDirection;
import com.technicalitiesmc.lib.math.VecDirectionFlags;
import com.technicalitiesmc.scm.component.InterfaceLookup;
import com.technicalitiesmc.scm.component.digital.DigitalComponentBase;
import com.technicalitiesmc.scm.component.digital.TorchTopComponent;
import com.technicalitiesmc.scm.init.SCMComponents;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class TorchBottomComponent
extends DigitalComponentBase<TorchBottomComponent> {
    private static final Property<Boolean> PROP_ON = BooleanProperty.m_61465_((String)"on");
    private static final AABB BOUNDS = new AABB(0.1875, 0.0, 0.1875, 0.8125, 1.0, 0.8125);
    private static final VecDirectionFlags OUTPUT_SIDES = VecDirectionFlags.horizontals();
    private static final InterfaceLookup<TorchBottomComponent> INTERFACES = InterfaceLookup.builder().with(RedstoneSource.class, OUTPUT_SIDES, TorchBottomComponent::getRedstoneSource).with(RedstoneSink.class, DigitalComponentBase.DEFAULT_INPUT_SIDES, RedstoneSink::instance).build();
    boolean state = true;

    public TorchBottomComponent(ComponentContext context) {
        super(SCMComponents.TORCH_BOTTOM, context, INTERFACES);
    }

    public TorchBottomComponent(ComponentContext context, boolean state) {
        this(context);
        this.state = state;
    }

    public CircuitComponent copyRotated(ComponentContext context, Rotation rotation) {
        return new TorchBottomComponent(context, this.state);
    }

    public ComponentState getState() {
        return (ComponentState)super.getState().m_61124_(PROP_ON, (Comparable)Boolean.valueOf(this.state));
    }

    public AABB getBoundingBox() {
        return BOUNDS;
    }

    public ItemStack getPickedItem() {
        return new ItemStack((ItemLike)Items.f_41978_);
    }

    @Override
    protected boolean beforeCheckInputs(ComponentEventMap events, boolean tick) {
        boolean newState;
        if (tick && (newState = TorchBottomComponent.computeState(this.getInputs())) != this.state) {
            this.updateExternalState(true, () -> {
                this.state = newState;
            });
            this.sendEvent(CircuitEvent.REDSTONE, OUTPUT_SIDES);
            this.sendEventAt(VecDirection.POS_Y.getOffset(), CircuitEvent.REDSTONE, TorchTopComponent.OUTPUT_SIDES);
        }
        return true;
    }

    @Override
    protected void onNewInputs(boolean tick, byte newInputs) {
        if (this.state != TorchBottomComponent.computeState(newInputs)) {
            this.scheduleTick(1);
        }
    }

    public void harvest(ComponentHarvestContext context) {
        this.spawnDrops(context);
        this.removeComponentAt(Vec3i.f_123288_, ComponentSlot.DEFAULT, true);
        this.removeComponentAt(VecDirection.POS_Y.getOffset(), ComponentSlot.DEFAULT, true);
    }

    @Override
    public CompoundTag save(CompoundTag tag) {
        tag = super.save(tag);
        tag.m_128379_("state", this.state);
        return tag;
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.state = tag.m_128471_("state");
    }

    private RedstoneSource getRedstoneSource() {
        return this.state ? RedstoneSource.fullWeak() : RedstoneSource.off();
    }

    private static boolean computeState(byte inputs) {
        return inputs == 0;
    }

    public static void createState(StateDefinition.Builder<ComponentType, ComponentState> builder) {
        builder.m_61104_(new Property[]{PROP_ON});
    }

    public static class Client
    extends ClientComponent {
        public AABB getBoundingBox(ComponentState state) {
            return BOUNDS;
        }

        public ItemStack getPickedItem(ComponentState state) {
            return new ItemStack((ItemLike)Items.f_41978_);
        }
    }
}

