/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.scm.component.digital;

import com.mojang.math.Vector3f;
import com.technicalitiesmc.lib.circuit.component.CircuitComponent;
import com.technicalitiesmc.lib.circuit.component.CircuitEvent;
import com.technicalitiesmc.lib.circuit.component.ClientComponent;
import com.technicalitiesmc.lib.circuit.component.ComponentContext;
import com.technicalitiesmc.lib.circuit.component.ComponentEventMap;
import com.technicalitiesmc.lib.circuit.component.ComponentState;
import com.technicalitiesmc.lib.circuit.component.ComponentType;
import com.technicalitiesmc.lib.circuit.interfaces.RedstoneSink;
import com.technicalitiesmc.lib.circuit.interfaces.RedstoneSource;
import com.technicalitiesmc.lib.init.TKLibItemTags;
import com.technicalitiesmc.lib.math.VecDirection;
import com.technicalitiesmc.lib.math.VecDirectionFlags;
import com.technicalitiesmc.scm.component.InterfaceLookup;
import com.technicalitiesmc.scm.component.digital.DigitalComponentBase;
import com.technicalitiesmc.scm.init.SCMComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class LeverComponent
extends DigitalComponentBase<LeverComponent> {
    private static final AABB BOUNDS1 = new AABB(0.0, 0.0, 0.125, 1.0, 0.375, 0.875);
    private static final AABB BOUNDS2 = new AABB(0.125, 0.0, 0.0, 0.875, 0.375, 1.0);
    private static final Property<Boolean> PROP_ROTATED = BooleanProperty.m_61465_((String)"rotated");
    private static final Property<Boolean> PROP_ON = BooleanProperty.m_61465_((String)"on");
    private static final VecDirectionFlags INPUT_SIDES_1 = VecDirectionFlags.of((VecDirection[])new VecDirection[]{VecDirection.NEG_X, VecDirection.POS_X, VecDirection.NEG_Y});
    private static final VecDirectionFlags OUTPUT_SIDES_1 = VecDirectionFlags.of((VecDirection[])new VecDirection[]{VecDirection.NEG_Z, VecDirection.POS_Z});
    private static final VecDirectionFlags INPUT_SIDES_2 = VecDirectionFlags.of((VecDirection[])new VecDirection[]{VecDirection.NEG_Z, VecDirection.POS_Z, VecDirection.NEG_Y});
    private static final VecDirectionFlags OUTPUT_SIDES_2 = VecDirectionFlags.of((VecDirection[])new VecDirection[]{VecDirection.NEG_X, VecDirection.POS_X});
    private static final InterfaceLookup<LeverComponent> INTERFACES = InterfaceLookup.builder().with(RedstoneSink.class, LeverComponent::getRedstoneSink).with(RedstoneSource.class, LeverComponent::getRedstoneSource).build();
    private boolean previousInput = false;
    private boolean rotation = false;
    private boolean state = true;

    public LeverComponent(ComponentContext context) {
        super(SCMComponents.LEVER, context, INTERFACES);
    }

    private LeverComponent(ComponentContext context, boolean rotation, boolean state) {
        this(context);
        this.rotation = rotation;
        this.state = state;
    }

    private int getRotation() {
        return (this.state ? 2 : 0) + (this.rotation ? 1 : 0);
    }

    public void setRotation(int rotation) {
        this.updateExternalState(true, () -> {
            this.rotation = rotation % 2 == 1;
            this.state = rotation >= 2;
        });
    }

    public CircuitComponent copyRotated(ComponentContext context, Rotation rotation) {
        boolean rotate = rotation.ordinal() % 2 == 1;
        boolean flip = rotation.ordinal() >= 2;
        return new LeverComponent(context, rotate != this.rotation, this.state != flip);
    }

    public ComponentState getState() {
        return (ComponentState)((ComponentState)super.getState().m_61124_(PROP_ROTATED, (Comparable)Boolean.valueOf(this.rotation))).m_61124_(PROP_ON, (Comparable)Boolean.valueOf(this.state));
    }

    public AABB getBoundingBox() {
        return this.rotation ? BOUNDS2 : BOUNDS1;
    }

    public ItemStack getPickedItem() {
        return new ItemStack((ItemLike)Items.f_41966_);
    }

    @Override
    protected VecDirectionFlags getInputSides() {
        return this.choose(INPUT_SIDES_1, INPUT_SIDES_2);
    }

    private VecDirectionFlags getOutputSides() {
        return this.choose(OUTPUT_SIDES_1, OUTPUT_SIDES_2);
    }

    @Override
    protected boolean beforeCheckInputs(ComponentEventMap events, boolean tick) {
        if (tick) {
            boolean input;
            boolean bl = input = this.getInputs() != 0;
            if (input && !this.previousInput) {
                this.toggle();
            }
            this.previousInput = input;
        }
        return true;
    }

    @Override
    protected void onNewInputs(boolean tick, byte newInputs) {
        if (this.getInputs() == 0 != (newInputs == 0)) {
            this.scheduleTick(1);
        }
    }

    public InteractionResult use(Player player, InteractionHand hand, VecDirection sideHit, Vector3f hit) {
        if (player.m_21120_(hand).m_204117_(TKLibItemTags.TOOLS_WRENCH)) {
            this.rotate();
        } else {
            this.toggle();
        }
        return InteractionResult.m_19078_((boolean)false);
    }

    @Override
    public CompoundTag save(CompoundTag tag) {
        tag = super.save(tag);
        tag.m_128379_("previous_input", this.previousInput);
        tag.m_128379_("state", this.state);
        tag.m_128379_("rotation", this.rotation);
        return tag;
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.previousInput = tag.m_128471_("previous_input");
        this.state = tag.m_128471_("state");
        this.rotation = tag.m_128471_("rotation");
    }

    private void toggle() {
        boolean newState = !this.state;
        float pitch = newState ? 0.7f : 0.6f;
        this.playSound(SoundEvents.f_12088_, SoundSource.BLOCKS, 0.2f, pitch);
        this.updateExternalState(true, () -> {
            this.state = newState;
        });
        this.sendEvent(CircuitEvent.REDSTONE, this.getOutputSides());
    }

    public void rotate() {
        this.setRotation((this.getRotation() + 1) % 4);
        this.sendEvent(CircuitEvent.REDSTONE, VecDirectionFlags.horizontals());
        this.sendEvent(CircuitEvent.NEIGHBOR_CHANGED, VecDirectionFlags.horizontals());
    }

    private <T> T choose(T first, T second) {
        return this.rotation ? first : second;
    }

    private RedstoneSink getRedstoneSink(VecDirection side) {
        if (!this.getInputSides().has((Enum)side)) {
            return null;
        }
        return RedstoneSink.instance();
    }

    private RedstoneSource getRedstoneSource(VecDirection side) {
        if (!this.getOutputSides().has((Enum)side)) {
            return null;
        }
        return side.isPositive() == this.state ? RedstoneSource.fullWeak() : RedstoneSource.off();
    }

    public static void createState(StateDefinition.Builder<ComponentType, ComponentState> builder) {
        builder.m_61104_(new Property[]{PROP_ROTATED, PROP_ON});
    }

    public static class Client
    extends ClientComponent {
        public AABB getBoundingBox(ComponentState state) {
            return (Boolean)state.m_61143_(PROP_ROTATED) != false ? BOUNDS2 : BOUNDS1;
        }

        public ItemStack getPickedItem(ComponentState state) {
            return new ItemStack((ItemLike)Items.f_41966_);
        }

        public InteractionResult use(ComponentState state, Player player, InteractionHand hand, VecDirection sideHit, Vector3f hit) {
            return InteractionResult.m_19078_((boolean)true);
        }
    }
}

