/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.scm.component.digital;

import com.technicalitiesmc.lib.circuit.component.CircuitEvent;
import com.technicalitiesmc.lib.circuit.component.ComponentContext;
import com.technicalitiesmc.lib.circuit.component.ComponentEventMap;
import com.technicalitiesmc.lib.circuit.component.ComponentType;
import com.technicalitiesmc.lib.math.VecDirection;
import com.technicalitiesmc.lib.math.VecDirectionFlags;
import com.technicalitiesmc.lib.util.Utils;
import com.technicalitiesmc.scm.component.CircuitComponentBase;
import com.technicalitiesmc.scm.component.InterfaceLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.registries.RegistryObject;

public abstract class DigitalComponentBase<T extends DigitalComponentBase<T>>
extends CircuitComponentBase<T> {
    public static final VecDirectionFlags DEFAULT_INPUT_SIDES = (VecDirectionFlags)VecDirectionFlags.horizontals().and((Enum)VecDirection.NEG_Y);
    private byte inputs = 0;

    protected DigitalComponentBase(RegistryObject<ComponentType> type, ComponentContext context, InterfaceLookup<T> interfaceLookup) {
        super(type, context, interfaceLookup);
    }

    protected boolean needsSupport() {
        return true;
    }

    protected final byte getInputs() {
        return this.inputs;
    }

    protected VecDirectionFlags getInputSides() {
        return DEFAULT_INPUT_SIDES;
    }

    protected boolean beforeCheckInputs(ComponentEventMap events, boolean tick) {
        return true;
    }

    protected abstract void onNewInputs(boolean var1, byte var2);

    public void onAdded() {
        byte newInputs = this.computeInputs(this.inputs, this.getInputSides());
        this.onNewInputs(false, newInputs);
        this.inputs = newInputs;
    }

    public void update(ComponentEventMap events, boolean tick) {
        if (this.needsSupport() && !this.ensureSupported(events)) {
            return;
        }
        if (!this.beforeCheckInputs(events, tick)) {
            return;
        }
        VecDirectionFlags updatedSides = events.findAny(this.getInputSides(), new CircuitEvent[]{CircuitEvent.REDSTONE, CircuitEvent.NEIGHBOR_CHANGED});
        if (updatedSides.isEmpty()) {
            return;
        }
        byte newInputs = this.computeInputs(this.inputs, updatedSides);
        this.onNewInputs(tick, newInputs);
        this.inputs = newInputs;
    }

    public CompoundTag save(CompoundTag tag) {
        tag = super.save(tag);
        tag.m_128344_("inputs", this.inputs);
        return tag;
    }

    public void load(CompoundTag tag) {
        super.load(tag);
        this.inputs = tag.m_128445_("inputs");
    }

    protected final void clearAllInputs() {
        this.inputs = 0;
    }

    protected final void recheckAllInputs() {
        this.inputs = this.computeInputs((byte)0, this.getInputSides());
    }

    private byte computeInputs(byte inputs, VecDirectionFlags sides) {
        for (VecDirection direction : sides) {
            boolean newInput = this.getStrongInput(direction) > 0;
            inputs = Utils.set((byte)inputs, (int)direction.ordinal(), (boolean)newInput);
        }
        return inputs;
    }
}

