/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.scm.component.digital;

import com.mojang.math.Vector3f;
import com.technicalitiesmc.lib.circuit.component.CircuitComponent;
import com.technicalitiesmc.lib.circuit.component.CircuitEvent;
import com.technicalitiesmc.lib.circuit.component.ClientComponent;
import com.technicalitiesmc.lib.circuit.component.ComponentContext;
import com.technicalitiesmc.lib.circuit.component.ComponentEventMap;
import com.technicalitiesmc.lib.circuit.component.ComponentState;
import com.technicalitiesmc.lib.circuit.component.ComponentType;
import com.technicalitiesmc.lib.circuit.interfaces.RedstoneSource;
import com.technicalitiesmc.lib.math.VecDirection;
import com.technicalitiesmc.lib.math.VecDirectionFlags;
import com.technicalitiesmc.scm.component.CircuitComponentBase;
import com.technicalitiesmc.scm.component.InterfaceLookup;
import com.technicalitiesmc.scm.init.SCMComponents;
import com.technicalitiesmc.scm.init.SCMItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class ButtonComponent
extends CircuitComponentBase<ButtonComponent> {
    private static final AABB BOUNDS = new AABB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0);
    private static final Property<Boolean> PROP_ON = BooleanProperty.m_61465_((String)"on");
    private static final int TIMEOUT = 10;
    private static final VecDirectionFlags OUTPUT_SIDES = (VecDirectionFlags)VecDirectionFlags.horizontals().and((Enum)VecDirection.NEG_Y);
    private static final InterfaceLookup<ButtonComponent> INTERFACES = InterfaceLookup.builder().with(RedstoneSource.class, OUTPUT_SIDES, ButtonComponent::getRedstoneSource).build();
    private int counter;
    private boolean state;

    public ButtonComponent(ComponentContext context) {
        super(SCMComponents.BUTTON, context, INTERFACES);
    }

    public CircuitComponent copyRotated(ComponentContext context, Rotation rotation) {
        return new ButtonComponent(context);
    }

    public ComponentState getState() {
        return (ComponentState)super.getState().m_61124_(PROP_ON, (Comparable)Boolean.valueOf(this.state));
    }

    public AABB getBoundingBox() {
        return BOUNDS;
    }

    public ItemStack getPickedItem() {
        return new ItemStack((ItemLike)SCMItems.BUTTON.get());
    }

    public void update(ComponentEventMap events, boolean tick) {
        if (tick) {
            --this.counter;
            if (this.counter == 0) {
                this.playSound(SoundEvents.f_12443_, SoundSource.BLOCKS, 0.2f, 0.6f);
                this.updateExternalState(true, () -> {
                    this.state = false;
                });
                this.sendEvent(CircuitEvent.REDSTONE, OUTPUT_SIDES);
            } else {
                this.scheduleTick(1);
            }
        }
    }

    public InteractionResult use(Player player, InteractionHand hand, VecDirection sideHit, Vector3f hit) {
        this.counter = 10;
        this.scheduleTick(1);
        if (!this.state) {
            this.playSound(SoundEvents.f_12444_, SoundSource.BLOCKS, 0.2f, 0.7f);
            this.updateExternalState(true, () -> {
                this.state = true;
            });
            this.sendEvent(CircuitEvent.REDSTONE, OUTPUT_SIDES);
        }
        return InteractionResult.m_19078_((boolean)false);
    }

    public CompoundTag save(CompoundTag tag) {
        tag = super.save(tag);
        tag.m_128405_("counter", this.counter);
        tag.m_128379_("state", this.state);
        return tag;
    }

    public void load(CompoundTag tag) {
        super.load(tag);
        this.counter = tag.m_128451_("counter");
        this.state = tag.m_128471_("state");
    }

    private RedstoneSource getRedstoneSource() {
        return this.state ? RedstoneSource.fullWeak() : RedstoneSource.off();
    }

    public static void createState(StateDefinition.Builder<ComponentType, ComponentState> builder) {
        builder.m_61104_(new Property[]{PROP_ON});
    }

    public static class Client
    extends ClientComponent {
        public AABB getBoundingBox(ComponentState state) {
            return BOUNDS;
        }

        public ItemStack getPickedItem(ComponentState state) {
            return new ItemStack((ItemLike)SCMItems.BUTTON.get());
        }

        public InteractionResult use(ComponentState state, Player player, InteractionHand hand, VecDirection sideHit, Vector3f hit) {
            return InteractionResult.m_19078_((boolean)true);
        }
    }
}

