/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.scm.circuit.util;

import com.technicalitiesmc.lib.circuit.component.ComponentSlot;
import com.technicalitiesmc.lib.math.IndexedShape;
import com.technicalitiesmc.scm.circuit.CircuitHelper;
import com.technicalitiesmc.scm.circuit.util.ComponentPos;
import com.technicalitiesmc.scm.circuit.util.ComponentSlotPos;
import java.util.BitSet;
import java.util.stream.Stream;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum TileSection {
    ALL(0, 0){

        @Override
        public VoxelShape offsetNeg(VoxelShape shape) {
            return shape;
        }
    }
    ,
    X_EDGE(1, 0),
    Z_EDGE(0, 1),
    CORNER(1, 1);

    public static final TileSection[] VALUES;
    public static final TileSection[] NEIGHBORS;
    private final BitSet bits = new BitSet(CircuitHelper.TOTAL_POSITIONS);
    private final int xOffset;
    private final int zOffset;

    private TileSection(int xOffset, int zOffset) {
        this.xOffset = xOffset;
        this.zOffset = zOffset;
    }

    public BitSet getBits() {
        return this.bits;
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public int getZOffset() {
        return this.zOffset;
    }

    public VoxelShape offsetNeg(VoxelShape shape) {
        return shape.m_83216_((double)(-this.xOffset), 0.0, (double)(-this.zOffset));
    }

    public VoxelShape offsetNeg(VoxelShape shape, int newIndex) {
        AABB bounds = shape.m_83215_().m_82386_((double)(-this.xOffset), 0.0, (double)(-this.zOffset));
        return IndexedShape.create((int)newIndex, (AABB)bounds);
    }

    public Stream<ComponentSlotPos> stream() {
        return this.bits.stream().mapToObj(CircuitHelper::getPositionFromIndex);
    }

    static {
        VALUES = TileSection.values();
        NEIGHBORS = new TileSection[]{X_EDGE, Z_EDGE, CORNER};
        TileSection.ALL.bits.set(0, CircuitHelper.TOTAL_POSITIONS);
        for (ComponentSlot slot : ComponentSlot.VALUES) {
            for (int y = 0; y < 4; ++y) {
                for (int i = 0; i < 8; ++i) {
                    TileSection.X_EDGE.bits.set(CircuitHelper.getIndex(new ComponentPos(7, y, i), slot));
                    TileSection.Z_EDGE.bits.set(CircuitHelper.getIndex(new ComponentPos(i, y, 7), slot));
                }
                TileSection.CORNER.bits.set(CircuitHelper.getIndex(new ComponentPos(7, y, 7), slot));
            }
        }
    }
}

