/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.scm.circuit.util;

import com.technicalitiesmc.lib.math.Vec2i;
import com.technicalitiesmc.scm.circuit.util.ComponentPos;
import com.technicalitiesmc.scm.circuit.util.TileSection;
import net.minecraft.core.Vec3i;

public record TilePos(int x, int z) {
    public static final TilePos ZERO = new TilePos(0, 0);

    public TilePos(int[] values) {
        this(values[0], values[1]);
    }

    public boolean isZero() {
        return this.x() == 0 && this.z() == 0;
    }

    public TilePos offset(int x, int z) {
        return new TilePos(this.x() + x, this.z() + z);
    }

    public TilePos offset(Vec2i vec) {
        return this.offset(vec.x(), vec.y());
    }

    public TilePos offset(TileSection section) {
        return this.offset(section.getXOffset(), section.getZOffset());
    }

    public TilePos offsetNeg(TileSection section) {
        return this.offset(-section.getXOffset(), -section.getZOffset());
    }

    public Vec3i pack(ComponentPos pos) {
        return this.pack(pos.x(), pos.y(), pos.z());
    }

    public Vec3i pack(Vec3i pos) {
        return this.pack(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public Vec3i pack(int x, int y, int z) {
        return new Vec3i(this.x() * 8 + x, y, this.z() * 8 + z);
    }

    public Vec2i subtract(TilePos pos) {
        return new Vec2i(this.x() - pos.x(), this.z() - pos.z());
    }

    public int[] toArray() {
        return new int[]{this.x(), this.z()};
    }
}

