/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.scm.circuit.server;

import com.mojang.math.Vector3f;
import com.technicalitiesmc.lib.circuit.component.CircuitEvent;
import com.technicalitiesmc.lib.circuit.component.ComponentEventMap;
import com.technicalitiesmc.lib.circuit.component.ComponentHarvestContext;
import com.technicalitiesmc.lib.circuit.component.ComponentSlot;
import com.technicalitiesmc.lib.circuit.component.ComponentState;
import com.technicalitiesmc.lib.circuit.component.ComponentType;
import com.technicalitiesmc.lib.math.Vec2i;
import com.technicalitiesmc.lib.math.VecDirection;
import com.technicalitiesmc.lib.math.VecDirectionFlags;
import com.technicalitiesmc.lib.util.Utils;
import com.technicalitiesmc.scm.circuit.CircuitAdjacency;
import com.technicalitiesmc.scm.circuit.TilePointer;
import com.technicalitiesmc.scm.circuit.server.CircuitCache;
import com.technicalitiesmc.scm.circuit.server.CircuitTile;
import com.technicalitiesmc.scm.circuit.server.ComponentInstance;
import com.technicalitiesmc.scm.circuit.server.ServerTileAccessor;
import com.technicalitiesmc.scm.circuit.util.AbsoluteSlotPos;
import com.technicalitiesmc.scm.circuit.util.ComponentSlotPos;
import com.technicalitiesmc.scm.circuit.util.TilePos;
import com.technicalitiesmc.scm.circuit.util.TileSection;
import com.technicalitiesmc.scm.circuit.util.UnpackedPos;
import com.technicalitiesmc.scm.component.misc.LevelIOComponent;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectRBTreeMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class Circuit
extends SavedData {
    private final CircuitCache cache;
    private final UUID id;
    private final Map<TilePos, CircuitTile> tiles = new HashMap<TilePos, CircuitTile>();
    private final Map<TilePos, ServerTileAccessor.Host> tileClaims = new HashMap<TilePos, ServerTileAccessor.Host>();
    private final List<ComponentInstance> addedComponents = new ArrayList<ComponentInstance>();
    private Map<AbsoluteSlotPos, ComponentEventMap.Builder> eventQueues = new HashMap<AbsoluteSlotPos, ComponentEventMap.Builder>();
    private final Set<AbsoluteSlotPos> queuedRemovals = new HashSet<AbsoluteSlotPos>();
    private final Set<AbsoluteSlotPos> queuedSequentialUpdates = new HashSet<AbsoluteSlotPos>();
    private final Set<AbsoluteSlotPos> queuedStateUpdates = new HashSet<AbsoluteSlotPos>();
    private final Long2ObjectMap<Set<AbsoluteSlotPos>> queuedTicks = new Long2ObjectRBTreeMap();
    private final Set<CircuitTile> queuedTileSyncs = Collections.newSetFromMap(new IdentityHashMap());
    private final Map<TilePos, VecDirectionFlags> queuedOutputs = new HashMap<TilePos, VecDirectionFlags>();
    private final Set<Level> tickLevels = new HashSet<Level>();
    private long currentTime = 0L;
    private boolean invalid = false;
    private boolean shouldTrySplit = false;
    private boolean ticking = false;

    public Circuit(CircuitCache cache, UUID id, boolean initialize) {
        this.cache = cache;
        this.id = id;
        if (!initialize) {
            return;
        }
        this.tiles.put(TilePos.ZERO, new CircuitTile(this, TilePos.ZERO));
    }

    public UUID getId() {
        return this.id;
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public boolean isLoaded() {
        return !this.tileClaims.isEmpty();
    }

    @Nullable
    public ServerTileAccessor claim(TilePos pos, ServerTileAccessor.Host host) {
        CircuitTile tile = this.tiles.get(pos);
        if (tile == null || this.tileClaims.containsKey(pos)) {
            return null;
        }
        this.tileClaims.put(pos, host);
        return new ServerTileAccessor(tile);
    }

    public void releaseClaim(TilePos pos) {
        this.tileClaims.remove(pos);
    }

    private ServerTileAccessor.Host getOrScoutHost(TilePos pos) {
        ServerTileAccessor.Host host = this.tileClaims.get(pos);
        if (host != null || this.tileClaims.isEmpty()) {
            return host;
        }
        Map.Entry<TilePos, ServerTileAccessor.Host> entry = this.tileClaims.entrySet().iterator().next();
        Vec2i relative = pos.subtract(entry.getKey());
        return entry.getValue().find(relative);
    }

    private boolean hasTile(TilePos pos) {
        return this.tiles.containsKey(pos);
    }

    @Nullable
    CircuitTile getTile(TilePos pos) {
        return this.tiles.get(pos);
    }

    @Nullable
    private CircuitTile getOrScoutTile(TilePos pos) {
        CircuitTile tile = this.getTile(pos);
        if (tile != null || this.tileClaims.isEmpty()) {
            return tile;
        }
        Map.Entry<TilePos, ServerTileAccessor.Host> entry = this.tileClaims.entrySet().iterator().next();
        Vec2i relative = pos.subtract(entry.getKey());
        ServerTileAccessor.Host host = entry.getValue().find(relative);
        return host != null ? host.getAccessor().getTile() : null;
    }

    private boolean visitTileAreaWhile(TilePos pos, BiPredicate<CircuitTile, TileSection> predicate) {
        for (TileSection section : TileSection.VALUES) {
            CircuitTile tile = this.getTile(pos.offsetNeg(section));
            if (tile == null || predicate.test(tile, section)) continue;
            return false;
        }
        return true;
    }

    boolean isTileAreaEmpty(TilePos pos) {
        return this.visitTileAreaWhile(pos, CircuitTile::isEmpty);
    }

    void clearTileArea(TilePos pos, @Nullable ComponentHarvestContext context) {
        this.visitTileAreaWhile(pos, (t, s) -> {
            t.clear((TileSection)((Object)s), context);
            return true;
        });
        for (int i = -1; i < 9; ++i) {
            for (int j = 0; j < 4; ++j) {
                for (ComponentSlot slot : ComponentSlot.VALUES) {
                    this.enqueueEventAt(pos.pack(-2, j, i), slot, VecDirection.POS_X, CircuitEvent.NEIGHBOR_CHANGED);
                    this.enqueueEventAt(pos.pack(8, j, i), slot, VecDirection.NEG_X, CircuitEvent.NEIGHBOR_CHANGED);
                    this.enqueueEventAt(pos.pack(i, j, -2), slot, VecDirection.POS_Z, CircuitEvent.NEIGHBOR_CHANGED);
                    this.enqueueEventAt(pos.pack(i, j, 8), slot, VecDirection.NEG_Z, CircuitEvent.NEIGHBOR_CHANGED);
                }
            }
        }
    }

    void clearAreaAndRemoveTile(CircuitTile tile, ComponentHarvestContext context) {
        TilePos pos = tile.getPosition();
        this.clearTileArea(pos, context);
        this.releaseClaim(pos);
        this.tiles.remove(pos);
        this.queuedTileSyncs.remove(tile);
        this.shouldTrySplit = true;
    }

    boolean isValidPosition(Vec3i pos) {
        UnpackedPos unpacked = UnpackedPos.of(pos);
        CircuitTile tile = this.getTile(unpacked.tile());
        if (tile == null) {
            return false;
        }
        TileSection section = unpacked.pos().getSection();
        return section == TileSection.ALL || this.getTile(unpacked.tile().offset(section)) != null;
    }

    @Nullable
    ComponentInstance get(Vec3i pos, ComponentSlot slot) {
        UnpackedPos unpacked = UnpackedPos.of(pos);
        if (unpacked.pos().y() < 0 || unpacked.pos().y() >= 4) {
            return null;
        }
        CircuitTile tile = this.getTile(unpacked.tile());
        if (tile == null) {
            TilePos neighborPos;
            if (unpacked.pos().y() == 0 && unpacked.pos().isOnXEdge() != unpacked.pos().isOnZEdge() && this.hasTile(neighborPos = unpacked.tile().offset(unpacked.pos().getSection()))) {
                return new ComponentInstance(null, unpacked.pos(), ctx -> new LevelIOComponent(ctx, side -> {
                    ServerTileAccessor.Host host = this.getOrScoutHost(neighborPos);
                    return host != null ? host.getInput((VecDirection)side) : 0;
                }));
            }
            return null;
        }
        ComponentInstance ci = tile.get(unpacked.pos(), slot);
        if (ci == null && unpacked.pos().y() == 0 && unpacked.pos().isOnXEdge() != unpacked.pos().isOnZEdge() && !this.hasTile(unpacked.tile().offset(unpacked.pos().getSection()))) {
            return new ComponentInstance(null, unpacked.pos(), ctx -> new LevelIOComponent(ctx, side -> {
                ServerTileAccessor.Host host = this.getOrScoutHost(unpacked.tile());
                return host != null ? host.getInput((VecDirection)side) : 0;
            }));
        }
        return ci;
    }

    @Nullable
    Supplier<ComponentInstance> tryPutLater(Vec3i pos, ComponentType type, ComponentType.Factory factory) {
        TileSection section;
        UnpackedPos unpacked = UnpackedPos.of(pos);
        if (unpacked.pos().y() < 0 || unpacked.pos().y() >= 4) {
            return null;
        }
        ArrayList<Runnable> tasks = new ArrayList<Runnable>();
        CircuitTile tile = this.getTile(unpacked.tile());
        if (tile == null || !tile.canPut(unpacked.pos(), type)) {
            CircuitTile neighbor = this.getOrScoutTile(unpacked.tile());
            if (neighbor == null || neighbor.getCircuit() == this || !neighbor.canPut(unpacked.pos(), type)) {
                return null;
            }
            Vec2i offset = unpacked.tile().subtract(neighbor.getPosition());
            tasks.add(() -> this.absorb(neighbor.getCircuit(), offset));
            tile = neighbor;
        }
        if ((section = unpacked.pos().getSection()) != TileSection.ALL) {
            TilePos neighborPos;
            CircuitTile neighbor;
            int j;
            int i;
            int xOff = section.getXOffset();
            int zOff = section.getZOffset();
            CircuitTile[][] neighbors = new CircuitTile[xOff + 1][zOff + 1];
            for (i = 0; i <= xOff; ++i) {
                for (j = 0; j <= zOff; ++j) {
                    if (i == 0 && j == 0 || (neighbor = (neighbors[i][j] = this.getOrScoutTile(neighborPos = unpacked.tile().offset(i, j)))) != null) continue;
                    tasks.forEach(Runnable::run);
                    return null;
                }
            }
            for (i = 0; i <= xOff; ++i) {
                for (j = 0; j <= zOff; ++j) {
                    if (i == 0 && j == 0) continue;
                    neighborPos = unpacked.tile().offset(i, j);
                    neighbor = neighbors[i][j];
                    if (neighbor.getCircuit() == this) continue;
                    Vec2i offset = neighborPos.subtract(neighbor.getPosition());
                    tasks.add(() -> this.absorb(neighbor.getCircuit(), offset));
                }
            }
        }
        CircuitTile theTile = tile;
        return () -> {
            tasks.forEach(Runnable::run);
            this.m_77762_();
            ComponentInstance instance = theTile.put(unpacked.pos(), factory);
            if (instance.getType() != type) {
                throw new IllegalStateException("Attempted to place a mismatched component type.");
            }
            this.addedComponents.add(instance);
            this.sendEvent(pos, instance.getSlot(), CircuitEvent.NEIGHBOR_CHANGED, VecDirectionFlags.all());
            return instance;
        };
    }

    @Nullable
    ComponentInstance tryPut(Vec3i pos, ComponentType type, ComponentType.Factory factory) {
        Supplier<ComponentInstance> adder = this.tryPutLater(pos, type, factory);
        return adder == null ? null : adder.get();
    }

    void harvest(Vec3i pos, ComponentSlot slot, ComponentHarvestContext context) {
        ComponentInstance c = this.get(pos, slot);
        if (c != null) {
            c.harvest(context);
        }
    }

    boolean tryRemove(Vec3i pos, ComponentSlot slot) {
        UnpackedPos unpacked = UnpackedPos.of(pos);
        CircuitTile tile = this.getTile(unpacked.tile());
        if (tile == null) {
            return false;
        }
        ComponentInstance component = tile.get(unpacked.pos(), slot);
        if (component != null && tile.remove(unpacked.pos(), slot)) {
            this.m_77762_();
            return true;
        }
        return false;
    }

    public void scheduleRemoval(Vec3i pos, ComponentSlot slot) {
        this.queuedRemovals.add(new AbsoluteSlotPos(pos, slot));
    }

    InteractionResult use(Vec3i pos, ComponentSlot slot, Player player, InteractionHand hand, VecDirection sideHit, Vector3f hit) {
        ComponentInstance c = this.get(pos, slot);
        if (c != null) {
            return c.use(player, hand, sideHit, hit);
        }
        return InteractionResult.PASS;
    }

    void sendEvent(Vec3i pos, ComponentSlot slot, CircuitEvent event, VecDirectionFlags directions) {
        for (VecDirection direction : directions) {
            if (direction.getAxis() != Direction.Axis.Y) {
                Vec3i p = pos.m_141952_(direction.getOffset());
                for (ComponentSlot s : ComponentSlot.VALUES) {
                    this.enqueueEventAt(p, s, direction.getOpposite(), event);
                }
                continue;
            }
            Direction.AxisDirection dir = direction.getAxisDirection();
            ComponentSlot currentSlot = slot;
            Vec3i offset = Vec3i.f_123288_;
            while ((offset = offset.m_141952_(currentSlot.getOffsetTowards(dir))).m_123333_(Vec3i.f_123288_) <= 1) {
                ComponentSlot next = currentSlot.next(dir);
                ComponentInstance component = this.get(pos.m_141952_(offset), next);
                if (component != null) {
                    this.enqueueEventAt(pos.m_141952_(offset), next, direction.getOpposite(), event);
                }
                currentSlot = next;
            }
        }
    }

    void enqueueEventAt(Vec3i pos, ComponentSlot slot, VecDirection side, CircuitEvent event) {
        TilePos neighborPos;
        CircuitTile neighbor;
        ComponentInstance c = this.get(pos, slot);
        if (c == null) {
            ComponentEventMap.Builder builder = this.eventQueues.computeIfAbsent(new AbsoluteSlotPos(pos, slot), $ -> new ComponentEventMap.Builder());
            builder.add(side, new CircuitEvent[]{event});
            return;
        }
        if (!c.isLevelIOComponent()) {
            ComponentEventMap.Builder builder = this.eventQueues.computeIfAbsent(new AbsoluteSlotPos(pos, slot), $ -> new ComponentEventMap.Builder());
            c.receiveEvent(side, event, builder);
            return;
        }
        if (!side.getAxis().m_122479_() || event != CircuitEvent.REDSTONE && event != CircuitEvent.NEIGHBOR_CHANGED) {
            return;
        }
        UnpackedPos unpacked = UnpackedPos.of(pos);
        if (unpacked.pos().isOnXEdge() == unpacked.pos().isOnZEdge()) {
            return;
        }
        CircuitTile tile = this.getTile(unpacked.tile());
        if (tile == null != ((neighbor = this.getTile(neighborPos = unpacked.tile().offset(unpacked.pos().getSection()))) == null)) {
            TilePos eventPos = !side.isPositive() ? unpacked.tile() : neighborPos;
            VecDirectionFlags sides = this.queuedOutputs.getOrDefault(eventPos, VecDirectionFlags.none());
            this.queuedOutputs.put(eventPos, (VecDirectionFlags)sides.and((Enum)side.getOpposite()));
        }
    }

    void enqueueSequentialUpdate(Vec3i pos, ComponentSlot slot) {
        this.queuedSequentialUpdates.add(new AbsoluteSlotPos(pos, slot));
    }

    void enqueueStateUpdate(Vec3i pos, ComponentSlot slot) {
        this.queuedStateUpdates.add(new AbsoluteSlotPos(pos, slot));
    }

    void enqueueTick(Vec3i pos, ComponentSlot slot, int delay) {
        if (delay <= 0) {
            throw new IllegalArgumentException("Delay cannot be less than or equal to 0.");
        }
        Set components = (Set)this.queuedTicks.computeIfAbsent(this.currentTime + (long)delay, $ -> new HashSet());
        components.add(new AbsoluteSlotPos(pos, slot));
    }

    void playSound(Vec3i pos, SoundEvent sound, SoundSource source, float volume, float pitch) {
        UnpackedPos unpacked = UnpackedPos.of(pos);
        ServerTileAccessor.Host host = this.tileClaims.get(unpacked.tile());
        if (host != null) {
            host.playSound(sound, source, volume, pitch);
        }
    }

    void enqueueTileSync(CircuitTile tile) {
        this.queuedTileSyncs.add(tile);
    }

    CircuitAdjacency[] calculateAdjacencyMap(TilePos pos) {
        boolean nx = this.getTile(pos.offset(-1, 0)) != null;
        boolean nz = this.getTile(pos.offset(0, -1)) != null;
        boolean px = this.getTile(pos.offset(1, 0)) != null;
        boolean pz = this.getTile(pos.offset(0, 1)) != null;
        CircuitAdjacency[] adjacency = new CircuitAdjacency[4];
        CircuitAdjacency circuitAdjacency = nx && nz ? (this.getTile(pos.offset(-1, -1)) != null ? CircuitAdjacency.BOTH_FULL : CircuitAdjacency.BOTH_PARTIAL) : (nx ? CircuitAdjacency.HORIZONTAL : (adjacency[0] = nz ? CircuitAdjacency.VERTICAL : CircuitAdjacency.NONE));
        CircuitAdjacency circuitAdjacency2 = px && nz ? (this.getTile(pos.offset(1, -1)) != null ? CircuitAdjacency.BOTH_FULL : CircuitAdjacency.BOTH_PARTIAL) : (px ? CircuitAdjacency.HORIZONTAL : (adjacency[1] = nz ? CircuitAdjacency.VERTICAL : CircuitAdjacency.NONE));
        CircuitAdjacency circuitAdjacency3 = nx && pz ? (this.getTile(pos.offset(-1, 1)) != null ? CircuitAdjacency.BOTH_FULL : CircuitAdjacency.BOTH_PARTIAL) : (nx ? CircuitAdjacency.HORIZONTAL : (adjacency[2] = pz ? CircuitAdjacency.VERTICAL : CircuitAdjacency.NONE));
        adjacency[3] = px && pz ? (this.getTile(pos.offset(1, 1)) != null ? CircuitAdjacency.BOTH_FULL : CircuitAdjacency.BOTH_PARTIAL) : (px ? CircuitAdjacency.HORIZONTAL : (pz ? CircuitAdjacency.VERTICAL : CircuitAdjacency.NONE));
        return adjacency;
    }

    private void sendTile(CircuitTile tile) {
        TilePos pos = tile.getPosition();
        ServerTileAccessor.Host host = this.tileClaims.get(pos);
        if (host == null) {
            tile.clearSyncQueue();
            return;
        }
        CircuitAdjacency[] adjacency = this.calculateAdjacencyMap(pos);
        Map<ComponentSlotPos, ComponentState> states = tile.getAndClearSyncQueue();
        host.syncState(states, adjacency);
    }

    private void absorb(Circuit other, Vec2i offset) {
        AbsoluteSlotPos newPos;
        if (other == this) {
            return;
        }
        other.tiles.forEach((pos, tile) -> {
            TilePos newPos = pos.offset(offset);
            tile.move(this, newPos);
            this.tiles.put(newPos, (CircuitTile)tile);
            ServerTileAccessor.Host host = other.getOrScoutHost((TilePos)pos);
            if (host != null) {
                host.updatePointer(new TilePointer(this.id, newPos));
            }
        });
        other.tileClaims.forEach((pos, host) -> {
            TilePos newPos = pos.offset(offset);
            this.tileClaims.put(newPos, (ServerTileAccessor.Host)host);
        });
        other.eventQueues.forEach((pos, builder) -> {
            AbsoluteSlotPos newPos = pos.offset(offset);
            this.eventQueues.put(newPos, (ComponentEventMap.Builder)builder);
        });
        for (AbsoluteSlotPos pos2 : other.queuedSequentialUpdates) {
            newPos = pos2.offset(offset);
            this.queuedSequentialUpdates.add(newPos);
        }
        for (AbsoluteSlotPos pos2 : other.queuedStateUpdates) {
            newPos = pos2.offset(offset);
            this.queuedStateUpdates.add(newPos);
        }
        other.queuedTicks.forEach((delay, components) -> {
            long time = delay - other.currentTime + this.currentTime;
            Set queuedComponents = (Set)this.queuedTicks.computeIfAbsent(time, $ -> new HashSet());
            for (AbsoluteSlotPos pos : components) {
                queuedComponents.add(pos.offset(offset));
            }
        });
        this.queuedTileSyncs.addAll(other.queuedTileSyncs);
        other.invalid = true;
        this.queuedTileSyncs.addAll(this.tiles.values());
    }

    Set<Circuit> maybeSplit() {
        for (CircuitTile tile : this.tiles.values()) {
            boolean mightSplit = tile.computeAdjacency();
            this.shouldTrySplit |= mightSplit;
        }
        if (!this.shouldTrySplit) {
            return Collections.singleton(this);
        }
        this.shouldTrySplit = false;
        Set groups = Utils.newIdentityHashSet();
        class Group {
            private final Set<CircuitTile> members = new HashSet<CircuitTile>();

            Group() {
            }
        }
        HashMap<CircuitTile, Group> mappings = new HashMap<CircuitTile, Group>();
        for (CircuitTile tile : this.tiles.values()) {
            Group group = mappings.computeIfAbsent(tile, p -> {
                Group newGroup = new Group();
                groups.add(newGroup);
                newGroup.members.add(tile);
                return newGroup;
            });
            for (TileSection section : TileSection.NEIGHBORS) {
                Group neighborGroup;
                TilePos neighborPos;
                CircuitTile neighbor;
                if (tile.isEmpty(section) || (neighbor = this.tiles.get(neighborPos = tile.getPosition().offset(section))) == null || (neighborGroup = (Group)mappings.get(neighbor)) == group) continue;
                if (neighborGroup == null) {
                    group.members.add(neighbor);
                    mappings.put(neighbor, group);
                    continue;
                }
                group.members.addAll(neighborGroup.members);
                for (CircuitTile member : neighborGroup.members) {
                    mappings.put(member, group);
                }
                groups.remove(neighborGroup);
            }
        }
        if (groups.size() == 0) {
            this.invalid = true;
            return Collections.singleton(this);
        }
        if (groups.size() == 1) {
            return Collections.singleton(this);
        }
        HashSet<Circuit> circuits = new HashSet<Circuit>();
        for (Group group : groups) {
            UUID id = UUID.randomUUID();
            Circuit circuit = this.cache.createUncached(id);
            circuit.currentTime = this.currentTime;
            for (CircuitTile tile : group.members) {
                TilePos pos = tile.getPosition();
                tile.move(circuit, pos);
                circuit.tiles.put(pos, tile);
                ServerTileAccessor.Host host = this.tileClaims.get(pos);
                if (host != null) {
                    circuit.tileClaims.put(pos, host);
                } else {
                    host = this.getOrScoutHost(pos);
                }
                if (host != null) {
                    host.updatePointer(new TilePointer(id, pos));
                }
                circuit.queuedTileSyncs.add(tile);
            }
            circuit.eventQueues.putAll(this.eventQueues);
            this.queuedTicks.forEach((ticks, components) -> circuit.queuedTicks.put(ticks, new HashSet(components)));
            circuit.queuedSequentialUpdates.addAll(this.queuedSequentialUpdates);
            circuit.queuedStateUpdates.addAll(this.queuedStateUpdates);
            circuit.tickLevels.addAll(this.tickLevels);
            circuits.add(circuit);
        }
        this.invalid = true;
        circuits.add(this);
        return circuits;
    }

    void scheduleTick(Level level) {
        this.tickLevels.add(level);
    }

    public boolean isTicking() {
        return this.ticking;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update() {
        try {
            ComponentInstance component;
            this.ticking = true;
            int levels = this.tickLevels.size();
            Optional firstLevel = this.tickLevels.stream().findFirst();
            this.tickLevels.clear();
            if (levels != 1) {
                return;
            }
            Set<AbsoluteSlotPos> updatesThisTick = (Set<AbsoluteSlotPos>)this.queuedTicks.remove(this.currentTime);
            if (updatesThisTick == null) {
                updatesThisTick = Collections.emptySet();
            }
            Set<AbsoluteSlotPos> updatesThisTick2 = updatesThisTick;
            for (AbsoluteSlotPos pos2 : this.queuedStateUpdates) {
                component = this.get(pos2.pos(), pos2.slot());
                if (component == null) continue;
                component.updateExternalState();
            }
            this.queuedStateUpdates.clear();
            for (AbsoluteSlotPos pos2 : this.queuedSequentialUpdates) {
                component = this.get(pos2.pos(), pos2.slot());
                if (component == null) continue;
                component.updateSequential();
            }
            this.queuedSequentialUpdates.clear();
            for (AbsoluteSlotPos pos2 : this.queuedStateUpdates) {
                component = this.get(pos2.pos(), pos2.slot());
                if (component == null) continue;
                component.updateExternalState();
            }
            this.queuedStateUpdates.clear();
            this.addedComponents.forEach(ComponentInstance::onAdded);
            this.addedComponents.clear();
            for (AbsoluteSlotPos pos2 : this.queuedStateUpdates) {
                component = this.get(pos2.pos(), pos2.slot());
                if (component == null) continue;
                component.updateExternalState();
            }
            this.queuedStateUpdates.clear();
            ServerLevel level = (ServerLevel)firstLevel.get();
            while (!updatesThisTick2.isEmpty() || !this.eventQueues.isEmpty()) {
                ComponentInstance component2;
                Map<AbsoluteSlotPos, ComponentEventMap.Builder> eventQueues = this.eventQueues;
                this.eventQueues = new HashMap<AbsoluteSlotPos, ComponentEventMap.Builder>();
                eventQueues.forEach((pos, events) -> {
                    boolean tick = updatesThisTick2.remove(pos);
                    ComponentInstance component = this.get(pos.pos(), pos.slot());
                    if (component != null) {
                        component.update(events.build(), tick);
                    }
                });
                for (AbsoluteSlotPos pos3 : updatesThisTick2) {
                    ComponentInstance component22 = this.get(pos3.pos(), pos3.slot());
                    if (component22 == null) continue;
                    component22.update(ComponentEventMap.empty(), true);
                }
                for (AbsoluteSlotPos pos3 : this.queuedSequentialUpdates) {
                    component2 = this.get(pos3.pos(), pos3.slot());
                    if (component2 == null) continue;
                    component2.updateSequential();
                }
                for (AbsoluteSlotPos pos3 : this.queuedStateUpdates) {
                    component2 = this.get(pos3.pos(), pos3.slot());
                    if (component2 == null) continue;
                    component2.updateExternalState();
                }
                for (AbsoluteSlotPos pos3 : this.queuedRemovals) {
                    component2 = this.get(pos3.pos(), pos3.slot());
                    if (component2 == null) continue;
                    UnpackedPos unpacked = UnpackedPos.of(pos3.pos());
                    ServerTileAccessor.Host host = this.tileClaims.get(unpacked.tile());
                    if (host == null && !this.tileClaims.isEmpty()) {
                        host = this.tileClaims.values().iterator().next();
                    }
                    ComponentHarvestContext ctx = host != null ? ComponentHarvestContext.drop((ServerLevel)level, host::drop) : ComponentHarvestContext.dummy((ServerLevel)level);
                    component2.harvest(ctx);
                }
                updatesThisTick.clear();
                this.queuedSequentialUpdates.clear();
                this.queuedStateUpdates.clear();
                this.queuedRemovals.clear();
                this.m_77762_();
            }
            this.queuedTileSyncs.forEach(this::sendTile);
            this.queuedTileSyncs.clear();
            this.queuedOutputs.forEach((pos, sides) -> {
                CircuitTile tile = this.getTile((TilePos)pos);
                if (tile == null) {
                    return;
                }
                ServerTileAccessor.Host host = this.getOrScoutHost((TilePos)pos);
                if (host == null) {
                    return;
                }
                for (VecDirection side : sides) {
                    int output = tile.calculateOutput(side);
                    host.setOutput(side, output);
                }
            });
            this.queuedOutputs.clear();
            ++this.currentTime;
        }
        finally {
            this.ticking = false;
        }
    }

    public void m_77757_(File file) {
        file.getParentFile().mkdirs();
        super.m_77757_(file);
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag tiles = new ListTag();
        this.tiles.forEach((pos, tile) -> {
            CompoundTag t = new CompoundTag();
            t.m_128385_("pos", pos.toArray());
            t.m_128365_("tile", (Tag)tile.save(new CompoundTag()));
            tiles.add((Object)t);
        });
        tag.m_128365_("tiles", (Tag)tiles);
        ListTag eventQueues = new ListTag();
        this.eventQueues.forEach((pos, builder) -> {
            CompoundTag t = new CompoundTag();
            t.m_128385_("pos", pos.toArray());
            t.m_128382_("events", builder.build().serialize());
            eventQueues.add((Object)t);
        });
        tag.m_128365_("event_queues", (Tag)eventQueues);
        ListTag queuedTicks = new ListTag();
        this.queuedTicks.forEach((tick, components) -> {
            CompoundTag t = new CompoundTag();
            t.m_128356_("tick", tick.longValue());
            ListTag l = new ListTag();
            for (AbsoluteSlotPos pos : components) {
                l.add((Object)new IntArrayTag(pos.toArray()));
            }
            t.m_128365_("components", (Tag)l);
            queuedTicks.add((Object)t);
        });
        tag.m_128365_("queued_ticks", (Tag)queuedTicks);
        ListTag queuedSequentialUpdates = new ListTag();
        this.queuedSequentialUpdates.forEach(pos -> queuedSequentialUpdates.add((Object)new IntArrayTag(pos.toArray())));
        tag.m_128365_("queued_sequential_updates", (Tag)queuedSequentialUpdates);
        ListTag queuedStateUpdates = new ListTag();
        this.queuedStateUpdates.forEach(pos -> queuedStateUpdates.add((Object)new IntArrayTag(pos.toArray())));
        tag.m_128365_("queued_state_updates", (Tag)queuedStateUpdates);
        tag.m_128356_("current_time", this.currentTime);
        return tag;
    }

    static Circuit load(CircuitCache cache, UUID id, CompoundTag tag) {
        Circuit circuit = new Circuit(cache, id, false);
        ListTag tiles = tag.m_128437_("tiles", 10);
        for (int i = 0; i < tiles.size(); ++i) {
            CompoundTag t = tiles.m_128728_(i);
            TilePos pos = new TilePos(t.m_128465_("pos"));
            CircuitTile tile = CircuitTile.load(circuit, pos, t.m_128469_("tile"));
            circuit.tiles.put(pos, tile);
        }
        ListTag eventQueues = tag.m_128437_("event_queues", 10);
        for (int i = 0; i < eventQueues.size(); ++i) {
            CompoundTag t = eventQueues.m_128728_(i);
            AbsoluteSlotPos pos = new AbsoluteSlotPos(t.m_128465_("pos"));
            ComponentEventMap.Builder events = ComponentEventMap.Builder.deserialize((byte[])t.m_128463_("events"));
            circuit.eventQueues.put(pos, events);
        }
        ListTag queuedTicks = tag.m_128437_("queued_ticks", 10);
        for (int i = 0; i < queuedTicks.size(); ++i) {
            CompoundTag t = queuedTicks.m_128728_(i);
            long tick = t.m_128454_("tick");
            HashSet<AbsoluteSlotPos> components = new HashSet<AbsoluteSlotPos>();
            ListTag l = t.m_128437_("components", 11);
            for (int j = 0; j < l.size(); ++j) {
                components.add(new AbsoluteSlotPos(l.m_128767_(j)));
            }
            circuit.queuedTicks.put(tick, components);
        }
        ListTag queuedSequentialUpdates = tag.m_128437_("queued_sequential_updates", 11);
        for (int i = 0; i < queuedSequentialUpdates.size(); ++i) {
            int[] arr = queuedSequentialUpdates.m_128767_(i);
            circuit.queuedSequentialUpdates.add(new AbsoluteSlotPos(arr));
        }
        ListTag queuedStateUpdates = tag.m_128437_("queued_state_updates", 11);
        for (int i = 0; i < queuedStateUpdates.size(); ++i) {
            int[] arr = queuedStateUpdates.m_128767_(i);
            circuit.queuedStateUpdates.add(new AbsoluteSlotPos(arr));
        }
        circuit.currentTime = tag.m_128454_("current_time");
        return circuit;
    }
}

