/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.scm.circuit.client;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.technicalitiesmc.lib.circuit.component.ComponentSlot;
import com.technicalitiesmc.lib.circuit.component.ComponentState;
import com.technicalitiesmc.lib.circuit.component.ComponentType;
import com.technicalitiesmc.lib.math.Vec2i;
import com.technicalitiesmc.scm.circuit.CircuitAdjacency;
import com.technicalitiesmc.scm.circuit.CircuitHelper;
import com.technicalitiesmc.scm.circuit.TileAccessor;
import com.technicalitiesmc.scm.circuit.util.ComponentPos;
import com.technicalitiesmc.scm.circuit.util.ComponentSlotPos;
import com.technicalitiesmc.scm.circuit.util.TilePos;
import com.technicalitiesmc.scm.circuit.util.TileSection;
import com.technicalitiesmc.scm.circuit.util.UnpackedPos;
import com.technicalitiesmc.scm.client.model.CircuitModelData;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ClientTile
implements TileAccessor {
    private final ComponentState[] components = new ComponentState[CircuitHelper.TOTAL_POSITIONS];
    private final VoxelShape[] shapes = new VoxelShape[CircuitHelper.TOTAL_POSITIONS];
    private final CircuitAdjacency[] adjacency = new CircuitAdjacency[4];
    private final Host host;

    public ClientTile(Host host) {
        this.host = host;
        Arrays.fill((Object[])this.adjacency, (Object)CircuitAdjacency.NONE);
    }

    @Nullable
    private ClientTile getTile(TileSection section) {
        if (section == TileSection.ALL) {
            return this;
        }
        return this.host.getClientNeighbor(new Vec2i(-section.getXOffset(), -section.getZOffset()));
    }

    @Nullable
    private ClientTile getTile(TilePos pos) {
        if (pos.isZero()) {
            return this;
        }
        return this.host.getClientNeighbor(new Vec2i(pos.x(), pos.z()));
    }

    @Override
    public boolean isAreaEmpty() {
        for (TileSection section : TileSection.VALUES) {
            ClientTile tile = this.getTile(section);
            if (tile == null || !section.getBits().stream().anyMatch(i -> tile.components[i] != null)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void clearArea() {
        for (TileSection section : TileSection.VALUES) {
            ClientTile tile = this.getTile(section);
            if (tile == null) continue;
            for (int i = 0; i < CircuitHelper.TOTAL_POSITIONS; ++i) {
                tile.components[i] = null;
                tile.shapes[i] = null;
            }
        }
    }

    public boolean hasNeighbor(Vec2i offset) {
        return this.host.getClientNeighbor(offset) != null;
    }

    @Nullable
    public ComponentState getState(Vec3i pos, ComponentSlot slot) {
        UnpackedPos unpacked = UnpackedPos.of(pos);
        ClientTile tile = this.getTile(unpacked.tile());
        return tile != null ? tile.components[CircuitHelper.getIndex(unpacked.pos(), slot)] : null;
    }

    public boolean canFit(Vec3i pos, ComponentType type) {
        UnpackedPos unpacked = UnpackedPos.of(pos);
        if (unpacked.pos().y() < 0 || unpacked.pos().y() >= 4) {
            return false;
        }
        ClientTile tile = this.getTile(unpacked.tile());
        if (tile != null) {
            HashSet<ComponentSlot> typeSlots = new HashSet<ComponentSlot>(Arrays.asList(type.getAllSlots()));
            for (ComponentSlot slot : ComponentSlot.VALUES) {
                ComponentState comp = tile.components[CircuitHelper.getIndex(unpacked.pos(), slot)];
                if (comp == null) continue;
                for (ComponentSlot s : comp.getComponentType().getAllSlots()) {
                    if (!typeSlots.contains(s)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void setState(Vec3i pos, ComponentSlot slot, @Nullable ComponentState state) {
        UnpackedPos unpacked = UnpackedPos.of(pos);
        if (unpacked.pos().y() < 0 || unpacked.pos().y() >= 4) {
            return;
        }
        ClientTile tile = this.getTile(unpacked.tile());
        if (tile != null) {
            int index = CircuitHelper.getIndex(unpacked.pos(), slot);
            tile.components[index] = state;
            tile.shapes[index] = state != null ? CircuitHelper.createShape(state.getBoundingBox(), unpacked.pos(), slot) : null;
            tile.host.onUpdateReceived();
        }
    }

    public void setAdjacency(CircuitAdjacency[] adjacency) {
        System.arraycopy(adjacency, 0, this.adjacency, 0, 4);
        this.host.onUpdateReceived();
    }

    @Override
    public void visitAreaShapes(Consumer<VoxelShape> consumer) {
        for (TileSection section : TileSection.VALUES) {
            ClientTile tile = this.getTile(section);
            if (tile == null) continue;
            section.getBits().stream().forEach(i -> {
                VoxelShape shape = tile.shapes[i];
                if (shape != null) {
                    ComponentSlotPos pos = CircuitHelper.getPositionFromIndex(i);
                    ComponentPos newPos = new ComponentPos(pos.pos().x() - 8 * section.getXOffset(), pos.pos().y(), pos.pos().z() - 8 * section.getZOffset());
                    int index = CircuitHelper.createShapeIndex(newPos, pos.slot());
                    consumer.accept(section.offsetNeg(shape, index));
                }
            });
        }
    }

    public CircuitModelData getModelData(boolean hideComponents) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        for (int i = 0; i < CircuitHelper.TOTAL_POSITIONS; ++i) {
            ComponentState state = this.components[i];
            if (state == null) continue;
            ComponentSlotPos pos = CircuitHelper.getPositionFromIndex(i);
            builder.put((Object)pos.toAbsolute().pos(), (Object)state);
        }
        return new CircuitModelData((Multimap<Vec3i, ComponentState>)builder.build(), this.adjacency, hideComponents);
    }

    public static ClientTile fromDescription(Host host, CompoundTag tag) {
        ClientTile tile = new ClientTile(host);
        int[] indices = tag.m_128465_("indices");
        ListTag components = tag.m_128437_("components", 10);
        for (int i = 0; i < components.size(); ++i) {
            int idx = indices[i];
            ComponentState state = ComponentState.deserialize((CompoundTag)components.m_128728_(i));
            if (state == null) continue;
            ComponentSlotPos pos = CircuitHelper.getPositionFromIndex(idx);
            tile.setState(pos.toAbsolute().pos(), pos.slot(), state);
        }
        int[] adjInt = tag.m_128465_("adjacency");
        for (int i = 0; i < adjInt.length; ++i) {
            tile.adjacency[i] = CircuitAdjacency.VALUES[adjInt[i]];
        }
        return tile;
    }

    public static interface Host {
        @Nullable
        public ClientTile getClientNeighbor(Vec2i var1);

        public void onUpdateReceived();
    }
}

