/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.scm.block;

import com.technicalitiesmc.lib.block.BlockComponentData;
import com.technicalitiesmc.lib.block.TKBlock;
import com.technicalitiesmc.lib.block.component.BlockData;
import com.technicalitiesmc.scm.init.SCMBlockEntities;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;

public class InspectorBlock
extends TKBlock.WithEntity {
    private static final String LANG_LEARNED = "msg.supercircuitmaker.inspector.learned";
    private static final String LANG_MODE_STATE = "msg.supercircuitmaker.inspector.mode_state";
    private static final String LANG_MODE_BLOCK = "msg.supercircuitmaker.inspector.mode_block";
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    private final BlockData<Data> data = (BlockData)this.addComponent("data", BlockData.of(Data::new));

    public InspectorBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(3.0f).m_60999_().m_60924_(($, $$, $$$) -> false), SCMBlockEntities.INSPECTOR, new Property[0]);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.SOUTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, POWERED});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_7820_().m_122424_().m_122424_());
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public void m_7458_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)), 2);
        } else {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true)), 2);
            level.m_186460_(pos, (Block)this, 2);
        }
        this.updateNeighborsInFront((Level)level, pos, state);
    }

    public BlockState m_7417_(BlockState state, Direction side, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (state.m_61143_((Property)FACING) == side) {
            this.checkUpdate(level, pos, state, neighborState);
        }
        return super.m_7417_(state, side, neighborState, level, pos, neighborPos);
    }

    private void checkUpdate(LevelAccessor level, BlockPos pos, BlockState state, BlockState neighborState) {
        Data data = (Data)this.data.at((BlockGetter)level, pos, state);
        if (data != null && !((Boolean)state.m_61143_((Property)POWERED)).booleanValue() && data.checkBlock(neighborState)) {
            this.startSignal(level, pos);
        }
    }

    private void startSignal(LevelAccessor level, BlockPos pos) {
        if (!level.m_5776_() && !level.m_183326_().m_183582_(pos, (Object)this)) {
            level.m_186460_(pos, (Block)this, 2);
        }
    }

    protected void updateNeighborsInFront(Level level, BlockPos pos, BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos neighborPos = pos.m_142300_(direction.m_122424_());
        level.m_46586_(neighborPos, (Block)this, pos);
        level.m_46590_(neighborPos, (Block)this, direction);
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction direction) {
        return state.m_61143_((Property)FACING) == direction;
    }

    public int m_6376_(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        return state.m_60746_(level, pos, side);
    }

    public int m_6378_(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        return (Boolean)state.m_61143_((Property)POWERED) != false && state.m_61143_((Property)FACING) == side ? 15 : 0;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        Data data = (Data)this.data.at((BlockGetter)level, pos, state);
        return data != null && data.found ? 15 : 0;
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean moving) {
        super.m_6807_(state, level, pos, oldState, moving);
        if (!state.m_60713_(oldState.m_60734_())) {
            this.checkUpdate((LevelAccessor)level, pos, state, level.m_8055_(pos.m_142300_((Direction)state.m_61143_((Property)FACING))));
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moving) {
        if (!state.m_60713_(newState.m_60734_()) && !level.f_46443_ && ((Boolean)state.m_61143_((Property)POWERED)).booleanValue() && level.m_183326_().m_183582_(pos, (Object)this)) {
            this.updateNeighborsInFront(level, pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
        }
        super.m_6810_(state, level, pos, newState, moving);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.m_6047_()) {
            Data data;
            if (!level.m_5776_() && (data = (Data)this.data.at((BlockGetter)level, pos, state)) != null) {
                BlockState neighborState = level.m_8055_(pos.m_142300_((Direction)state.m_61143_((Property)FACING)));
                if (data.matchedState != neighborState) {
                    data.setMatchedState(neighborState);
                    player.m_5661_((Component)new TranslatableComponent(LANG_LEARNED), true);
                } else {
                    data.toggleMode();
                    player.m_5661_((Component)new TranslatableComponent(data.mode ? LANG_MODE_BLOCK : LANG_MODE_STATE), true);
                }
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    private static class Data
    extends BlockComponentData {
        private BlockState matchedState;
        private boolean mode = false;
        private boolean found = false;

        protected Data(BlockComponentData.Context context) {
            super(context);
        }

        private void setMatchedState(BlockState state) {
            this.matchedState = state;
            this.markUnsaved();
            this.checkBlock();
        }

        private void toggleMode() {
            this.mode = !this.mode;
            this.markUnsaved();
            this.checkBlock();
        }

        private void checkBlock() {
            BlockState state = this.getLevel().m_8055_(this.getBlockPos().m_142300_((Direction)this.getBlockState().m_61143_((Property)FACING)));
            this.checkBlock(state);
        }

        private boolean checkBlock(BlockState state) {
            boolean found;
            boolean bl = this.mode ? state.m_60734_() == this.matchedState.m_60734_() : (found = state == this.matchedState);
            if (found != this.found) {
                this.found = found;
                this.getLevel().m_46717_(this.getBlockPos(), this.getBlockState().m_60734_());
            }
            return found;
        }

        public CompoundTag save(CompoundTag tag) {
            if (this.matchedState != null) {
                tag.m_128405_("matched_state", Block.f_49791_.m_7447_((Object)this.matchedState));
            }
            tag.m_128379_("mode", this.mode);
            tag.m_128379_("found", this.found);
            return super.save(tag);
        }

        public void load(CompoundTag tag) {
            super.load(tag);
            if (tag.m_128441_("matched_state")) {
                this.matchedState = (BlockState)Block.f_49791_.m_7942_(tag.m_128451_("matched_state"));
            }
            this.mode = tag.m_128471_("mode");
            this.found = tag.m_128471_("found");
        }
    }
}

