/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.scm.api3.component;

import com.google.common.base.Suppliers;
import com.mojang.math.Vector3f;
import com.technicalitiesmc.lib.circuit.component.ComponentSlot;
import com.technicalitiesmc.lib.circuit.component.ComponentState;
import com.technicalitiesmc.lib.math.VecDirection;
import com.technicalitiesmc.lib.util.Maybe;
import com.technicalitiesmc.scm.api2.logical.StateLike;
import com.technicalitiesmc.scm.api2.signal.SignalMap;
import com.technicalitiesmc.scm.api2.signal.SignalPorts;
import com.technicalitiesmc.scm.api2.signal.SignalType;
import com.technicalitiesmc.scm.api3.CircuitPos;
import com.technicalitiesmc.scm.api3.component.PlacementIntent;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class CircuitComponent<S extends State<S>, P>
extends ForgeRegistryEntry<CircuitComponent<?, ?>> {
    public static final Class<CircuitComponent<?, ?>> REGISTRY_TYPE = CircuitComponent.class;
    private final StateLoader<S> stateLoader;
    private final Supplier<ResourceLocation> lootTablePath = Suppliers.memoize(() -> {
        ResourceLocation name = this.getRegistryName();
        return new ResourceLocation(name.m_135827_(), "scm_components/" + name.m_135815_());
    });

    protected CircuitComponent(StateLoader<S> stateLoader, Property<?> ... visualProperties) {
        this.stateLoader = stateLoader;
    }

    protected final ResourceLocation getLootTablePath() {
        return this.lootTablePath.get();
    }

    protected final ComponentState baseVisualState() {
        return null;
    }

    public abstract Maybe<StateLike<S>> create(PlacementIntent<P> var1);

    public abstract StateLike<S> onNewInputs(S var1, SignalMap var2);

    public abstract StateLike<S> tick(S var1, SignalMap var2);

    public abstract <T> SignalPorts<T> getPorts(Metadata var1, S var2, CircuitPos var3, VecDirection var4, SignalType<T> var5);

    public ComponentState getVisualState(Metadata metadata, S state) {
        return this.baseVisualState();
    }

    public abstract VoxelShape getShape(ComponentState var1);

    public abstract ItemStack getPicked(ComponentState var1);

    public VoxelShape getShape(Metadata metadata, S state) {
        return this.getShape(metadata.visualState());
    }

    public ItemStack getPicked(Metadata metadata, S state) {
        return this.getPicked(metadata.visualState());
    }

    public List<ItemStack> getDrops(Metadata metadata, S state, ServerLevel level, boolean isCreative) {
        if (isCreative) {
            return List.of();
        }
        ResourceLocation path = this.getLootTablePath();
        LootTable table = level.m_142572_().m_129898_().m_79217_(path);
        LootContext lootContext = new LootContext.Builder(level).m_78975_(LootContextParamSets.f_81410_);
        return table.m_79129_(lootContext);
    }

    public InteractionResultHolder<S> use(Context ctx, S state, Player player, InteractionHand hand, VecDirection sideHit, Vector3f hit) {
        return InteractionResultHolder.m_19098_(state);
    }

    @FunctionalInterface
    public static interface StateLoader<S> {
        public S load(CompoundTag var1);
    }

    public static interface Metadata {
        public Footprint footprint();

        public ComponentState visualState();
    }

    public record Footprint(int xSize, int ySize, int zSize, ComponentSlot bottomSlot, ComponentSlot topSlot) {
    }

    public static interface Context
    extends Metadata {
    }

    public static interface State<S extends State<S>>
    extends StateLike<S> {
        default public S apply(Rotation rotation) {
            return (S)this.asState();
        }

        public CompoundTag save();

        @Override
        default public S asState() {
            return (S)this;
        }
    }
}

