/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.scm.api2.signal;

import com.technicalitiesmc.scm.api2.signal.InputPort;
import com.technicalitiesmc.scm.api2.signal.OutputPort;
import com.technicalitiesmc.scm.api2.signal.SignalType;
import javax.annotation.Nullable;
import org.jetbrains.annotations.Contract;

public record SignalPorts<T>(@Nullable InputPort<T> input, @Nullable OutputPort<T> output) {
    public static <T> Builder<T> of(SignalType<T> type) {
        return new Builder<T>(type);
    }

    public static class Builder<T> {
        private final SignalType<T> type;
        @Nullable
        private InputPort<T> input;
        @Nullable
        private OutputPort<T> output;

        public Builder(SignalType<T> type) {
            this.type = type;
        }

        @Contract(value="_, _, _ -> this")
        public <V> Builder<T> when(SignalType<V> signalType, @Nullable InputPort<V> input, @Nullable OutputPort<V> output) {
            return this.when(signalType, true, input, output);
        }

        @Contract(value="_, _, _, _ -> this")
        public <V> Builder<T> when(SignalType<V> signalType, boolean condition, @Nullable InputPort<V> input, @Nullable OutputPort<V> output) {
            if (this.type == signalType && condition) {
                this.input = input;
                this.output = output;
            }
            return this;
        }

        @Contract(pure=true, value="-> new")
        public SignalPorts<T> build() {
            return new SignalPorts<T>(this.input, this.output);
        }
    }
}

