/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.rangedpumps.block;

import com.refinedmods.rangedpumps.blockentity.PumpBlockEntity;
import com.refinedmods.rangedpumps.blockentity.PumpState;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.registries.ObjectHolder;

public class PumpBlock
extends Block
implements EntityBlock {
    @ObjectHolder(value="rangedpumps:pump")
    public static final PumpBlock BLOCK = null;

    public PumpBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(1.9f).m_60918_(SoundType.f_56742_));
        this.setRegistryName("rangedpumps", "pump");
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof PumpBlockEntity) {
            PumpBlockEntity pump = (PumpBlockEntity)blockEntity;
            IEnergyStorage energy = (IEnergyStorage)pump.getCapability(CapabilityEnergy.ENERGY).orElse(null);
            if (energy == null) {
                return InteractionResult.SUCCESS;
            }
            Component message = PumpState.getMessage(pump);
            if (message != null) {
                player.m_6352_(message, player.m_142081_());
            }
            if (pump.getTank().getFluidAmount() == 0) {
                player.m_6352_((Component)new TranslatableComponent("block.rangedpumps.pump.state_empty", new Object[]{energy.getEnergyStored(), energy.getMaxEnergyStored()}), player.m_142081_());
            } else {
                player.m_6352_((Component)new TranslatableComponent("block.rangedpumps.pump.state", new Object[]{pump.getTank().getFluidAmount(), pump.getTank().getFluid().getDisplayName(), energy.getEnergyStored(), energy.getMaxEnergyStored()}), player.m_142081_());
            }
        }
        return InteractionResult.SUCCESS;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new PumpBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return !level.f_46443_ ? (levelTicker, pos, stateTicker, blockEntity) -> ((PumpBlockEntity)blockEntity).tick() : null;
    }
}

