/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.lib.ModTags;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.data.recipes.BotaniaRecipeProvider;

public class ElvenTradeProvider
extends BotaniaRecipeProvider {
    public ElvenTradeProvider(DataGenerator gen) {
        super(gen);
    }

    @Override
    public void registerRecipes(Consumer<net.minecraft.data.recipes.FinishedRecipe> consumer) {
        consumer.accept(new FinishedRecipe(ElvenTradeProvider.id("dreamwood_log"), new ItemStack((ItemLike)ModBlocks.dreamwoodLog), Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModBlocks.livingwoodLog})));
        consumer.accept(new FinishedRecipe(ElvenTradeProvider.id("dreamwood"), new ItemStack((ItemLike)ModBlocks.dreamwood), Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModBlocks.livingwood})));
        Ingredient manaDiamond = Ingredient.m_204132_(ModTags.Items.GEMS_MANA_DIAMOND);
        Ingredient manaSteel = Ingredient.m_204132_(ModTags.Items.INGOTS_MANASTEEL);
        consumer.accept(new FinishedRecipe(ElvenTradeProvider.id("elementium"), new ItemStack((ItemLike)ModItems.elementium), manaSteel, manaSteel));
        consumer.accept(new FinishedRecipe(ElvenTradeProvider.id("elementium_block"), new ItemStack((ItemLike)ModBlocks.elementiumBlock), Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModBlocks.manasteelBlock}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModBlocks.manasteelBlock})));
        consumer.accept(new FinishedRecipe(ElvenTradeProvider.id("pixie_dust"), new ItemStack((ItemLike)ModItems.pixieDust), Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModItems.manaPearl})));
        consumer.accept(new FinishedRecipe(ElvenTradeProvider.id("dragonstone"), new ItemStack((ItemLike)ModItems.dragonstone), manaDiamond));
        consumer.accept(new FinishedRecipe(ElvenTradeProvider.id("dragonstone_block"), new ItemStack((ItemLike)ModBlocks.dragonstoneBlock), Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModBlocks.manaDiamondBlock})));
        consumer.accept(new FinishedRecipe(ElvenTradeProvider.id("elf_quartz"), new ItemStack((ItemLike)ModItems.elfQuartz), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42692_})));
        consumer.accept(new FinishedRecipe(ElvenTradeProvider.id("elf_glass"), new ItemStack((ItemLike)ModBlocks.elfGlass), Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModBlocks.manaGlass})));
        consumer.accept(new FinishedRecipe(ElvenTradeProvider.id("iron_return"), new ItemStack((ItemLike)Items.f_42416_), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42416_})));
        consumer.accept(new FinishedRecipe(ElvenTradeProvider.id("iron_block_return"), new ItemStack((ItemLike)Blocks.f_50075_), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50075_})));
        consumer.accept(new FinishedRecipe(ElvenTradeProvider.id("ender_pearl_return"), new ItemStack((ItemLike)Items.f_42584_), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42584_})));
        consumer.accept(new FinishedRecipe(ElvenTradeProvider.id("diamond_return"), new ItemStack((ItemLike)Items.f_42415_), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42415_})));
        consumer.accept(new FinishedRecipe(ElvenTradeProvider.id("diamond_block_return"), new ItemStack((ItemLike)Blocks.f_50090_), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50090_})));
        SpecialRecipeBuilder.m_126357_(ModRecipeTypes.LEXICON_ELVEN_TRADE_SERIALIZER).m_126359_(consumer, ElvenTradeProvider.id("lexicon_elven").toString());
    }

    private static ResourceLocation id(String path) {
        return ResourceLocationHelper.prefix("elven_trade/" + path);
    }

    public String m_6055_() {
        return "Botania elven trade recipes";
    }

    protected static class FinishedRecipe
    implements net.minecraft.data.recipes.FinishedRecipe {
        private final ResourceLocation id;
        private final List<Ingredient> inputs;
        private final List<ItemStack> outputs;

        public FinishedRecipe(ResourceLocation id, ItemStack output, Ingredient ... inputs) {
            this(id, Arrays.asList(inputs), Collections.singletonList(output));
        }

        protected FinishedRecipe(ResourceLocation id, List<Ingredient> inputs, List<ItemStack> outputs) {
            this.id = id;
            this.inputs = inputs;
            this.outputs = outputs;
        }

        public void m_7917_(JsonObject json) {
            JsonArray in = new JsonArray();
            for (Ingredient ingr : this.inputs) {
                in.add(ingr.m_43942_());
            }
            JsonArray out = new JsonArray();
            for (ItemStack s : this.outputs) {
                out.add((JsonElement)ItemNBTHelper.serializeStack(s));
            }
            json.add("ingredients", (JsonElement)in);
            json.add("output", (JsonElement)out);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return ModRecipeTypes.ELVEN_TRADE_SERIALIZER;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

