/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.generating;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityGeneratingFlower;
import vazkii.botania.client.fx.WispParticleData;

public abstract class SubTileFluidGenerator
extends TileEntityGeneratingFlower {
    private static final String TAG_BURN_TIME = "burnTime";
    public static final String TAG_COOLDOWN = "cooldown";
    private static final BlockPos[] OFFSETS = new BlockPos[]{new BlockPos(0, 0, 1), new BlockPos(0, 0, -1), new BlockPos(1, 0, 0), new BlockPos(-1, 0, 0), new BlockPos(-1, 0, 1), new BlockPos(-1, 0, -1), new BlockPos(1, 0, 1), new BlockPos(1, 0, -1)};
    public static final int DECAY_TIME = 72000;
    private int burnTime;
    private int cooldown;
    private final TagKey<Fluid> consumedFluid;
    private final int startBurnTime;
    private final int manaPerTick;
    private final int maxCooldown;

    protected SubTileFluidGenerator(BlockEntityType<?> type, BlockPos pos, BlockState state, TagKey<Fluid> consumedFluid, int startBurnTime, int manaPerTick, int maxCooldown) {
        super(type, pos, state);
        this.consumedFluid = consumedFluid;
        this.startBurnTime = startBurnTime;
        this.manaPerTick = manaPerTick;
        this.maxCooldown = maxCooldown;
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.cooldown > 0) {
            --this.cooldown;
            for (int i = 0; i < 3; ++i) {
                WispParticleData data = WispParticleData.wisp((float)Math.random() / 6.0f, 0.1f, 0.1f, 0.1f, 1.0f);
                this.emitParticle(data, 0.5 + Math.random() * 0.2 - 0.1, 0.5 + Math.random() * 0.2 - 0.1, 0.5 + Math.random() * 0.2 - 0.1, 0.0, (float)Math.random() / 30.0f, 0.0);
            }
        }
        if (!this.m_58904_().f_46443_ && this.burnTime > 0 && this.ticksExisted % this.getGenerationDelay() == 0) {
            this.addMana(this.manaPerTick);
        }
        if (this.burnTime == 0) {
            if (this.getMana() < this.getMaxMana() && !this.m_58904_().f_46443_) {
                List<BlockPos> offsets = Arrays.asList(OFFSETS);
                Collections.shuffle(offsets);
                for (BlockPos offset : offsets) {
                    BlockPos pos = this.getEffectivePos().m_141952_((Vec3i)offset);
                    BlockState bstate = this.m_58904_().m_8055_(pos);
                    FluidState fstate = this.m_58904_().m_6425_(pos);
                    if (!fstate.m_205070_(this.consumedFluid) || !fstate.m_76170_()) continue;
                    if (this.consumedFluid != FluidTags.f_13131_) {
                        this.m_58904_().m_46597_(pos, Blocks.f_50016_.m_49966_());
                    } else {
                        int waterAround = 0;
                        for (Direction dir : Direction.values()) {
                            if (!this.m_58904_().m_6425_(pos.m_142300_(dir)).m_205070_(this.consumedFluid)) continue;
                            ++waterAround;
                        }
                        if (waterAround < 2) {
                            Block block = bstate.m_60734_();
                            if (block instanceof BucketPickup) {
                                BucketPickup bucketPickup = (BucketPickup)block;
                                bucketPickup.m_142598_((LevelAccessor)this.m_58904_(), pos, bstate);
                            } else {
                                this.m_58904_().m_46597_(pos, Blocks.f_50016_.m_49966_());
                            }
                        }
                    }
                    if (this.cooldown == 0) {
                        this.burnTime += this.startBurnTime;
                    } else {
                        this.cooldown = this.maxCooldown;
                    }
                    this.sync();
                    this.playSound();
                    break;
                }
            }
        } else {
            if (this.m_58904_().f_46441_.nextInt(8) == 0) {
                this.doBurnParticles();
            }
            --this.burnTime;
            if (this.burnTime == 0) {
                this.cooldown = this.maxCooldown;
                this.sync();
            }
        }
    }

    public int getGenerationDelay() {
        return 1;
    }

    public abstract void doBurnParticles();

    public abstract void playSound();

    @Override
    public void writeToPacketNBT(CompoundTag cmp) {
        super.writeToPacketNBT(cmp);
        cmp.m_128405_(TAG_BURN_TIME, this.burnTime);
        cmp.m_128405_(TAG_COOLDOWN, this.cooldown);
    }

    @Override
    public void readFromPacketNBT(CompoundTag cmp) {
        super.readFromPacketNBT(cmp);
        this.burnTime = cmp.m_128451_(TAG_BURN_TIME);
        this.cooldown = cmp.m_128451_(TAG_COOLDOWN);
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), 1);
    }
}

