/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.chipped.registry;

import com.mojang.datafixers.util.Pair;
import earth.terrarium.chipped.Chipped;
import earth.terrarium.chipped.block.ChippedUniqueLantern;
import earth.terrarium.chipped.block.ChippedWorkbench;
import earth.terrarium.chipped.block.CustomPointedDripstoneBlock;
import earth.terrarium.chipped.menus.ChippedMenu;
import earth.terrarium.chipped.registry.ChippedMenuType;
import earth.terrarium.chipped.registry.ChippedProperties;
import earth.terrarium.chipped.registry.ChippedRecipeTypes;
import earth.terrarium.chipped.registry.ChippedTags;
import earth.terrarium.chipped.registry.RegistryHelpers;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DoubleHighBlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.item.WaterLilyBlockItem;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.CryingObsidianBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.FungusBlock;
import net.minecraft.world.level.block.GlassBlock;
import net.minecraft.world.level.block.HayBlock;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.MelonBlock;
import net.minecraft.world.level.block.MossBlock;
import net.minecraft.world.level.block.MushroomBlock;
import net.minecraft.world.level.block.NetherSproutsBlock;
import net.minecraft.world.level.block.PoweredBlock;
import net.minecraft.world.level.block.PumpkinBlock;
import net.minecraft.world.level.block.RedstoneLampBlock;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.RedstoneWallTorchBlock;
import net.minecraft.world.level.block.RootsBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SoulSandBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.SpongeBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.WaterlilyBlock;
import net.minecraft.world.level.block.WebBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;

public class ChippedBlocks {
    public static final List<Supplier<Block>> TRANSPARENT_BLOCKS = new ArrayList<Supplier<Block>>();
    public static final List<Supplier<Block>> CUTOUT_BLOCKS = new ArrayList<Supplier<Block>>();
    public static final List<Supplier<? extends Block>> BLOCKS = new ArrayList<Supplier<? extends Block>>();
    public static final List<Supplier<? extends Item>> ITEMS = new ArrayList<Supplier<? extends Item>>();
    public static final List<Pair<Supplier<Block>, ResourceLocation>> REGISTERED_BLOCKS = new ArrayList<Pair<Supplier<Block>, ResourceLocation>>();
    public static final List<Supplier<? extends Block>> SKIPPED_MODELS = new ArrayList<Supplier<? extends Block>>();
    public static final List<Supplier<? extends Block>> EXCLUDED_DROPS = new ArrayList<Supplier<? extends Block>>();
    public static final List<Pair<Supplier<? extends Block>, Supplier<? extends Block>>> BLOCK_PAIRS = new ArrayList<Pair<Supplier<? extends Block>, Supplier<? extends Block>>>();
    private static final BlockBehaviour.StatePredicate ALWAYS_FALSE_POSITION = (state, world, position) -> false;
    private static final BlockBehaviour.StateArgumentPredicate<EntityType<?>> VALID_SPAWN = (state, world, position, type) -> false;
    public static final Supplier<Block> BOTANIST_WORKBENCH = ChippedBlocks.register("botanist_workbench", () -> new ChippedWorkbench((id, inventory, access) -> new ChippedMenu(id, inventory, access, ChippedMenuType.BOTANIST_WORKBENCH.get(), ChippedRecipeTypes.BOTANIST_WORKBENCH_TYPE.get(), BOTANIST_WORKBENCH.get()), BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(1.0f, 2.0f).m_60918_(SoundType.f_56736_).m_60955_().m_60922_(VALID_SPAWN).m_60924_(ALWAYS_FALSE_POSITION).m_60960_(ALWAYS_FALSE_POSITION).m_60971_(ALWAYS_FALSE_POSITION)));
    public static final Supplier<Block> GLASSBLOWER = ChippedBlocks.register("glassblower", () -> new ChippedWorkbench((windowId, inventory, access) -> new ChippedMenu(windowId, inventory, access, ChippedMenuType.GLASSBLOWER.get(), ChippedRecipeTypes.GLASSBLOWER_TYPE.get(), GLASSBLOWER.get()), BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(1.0f, 2.0f).m_60918_(SoundType.f_56736_).m_60955_().m_60922_(VALID_SPAWN).m_60924_(ALWAYS_FALSE_POSITION).m_60960_(ALWAYS_FALSE_POSITION).m_60971_(ALWAYS_FALSE_POSITION)));
    public static final Supplier<Block> CARPENTERS_TABLE = ChippedBlocks.register("carpenters_table", () -> new ChippedWorkbench((windowId, inventory, access) -> new ChippedMenu(windowId, inventory, access, ChippedMenuType.CARPENTERS_TABLE.get(), ChippedRecipeTypes.CARPENTERS_TABLE_TYPE.get(), CARPENTERS_TABLE.get()), BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(1.0f, 2.0f).m_60918_(SoundType.f_56736_).m_60955_().m_60922_(VALID_SPAWN).m_60924_(ALWAYS_FALSE_POSITION).m_60960_(ALWAYS_FALSE_POSITION).m_60971_(ALWAYS_FALSE_POSITION)));
    public static final Supplier<Block> LOOM_TABLE = ChippedBlocks.register("loom_table", () -> new ChippedWorkbench((windowId, inventory, access) -> new ChippedMenu(windowId, inventory, access, ChippedMenuType.LOOM_TABLE.get(), ChippedRecipeTypes.LOOM_TABLE_TYPE.get(), LOOM_TABLE.get()), BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(1.0f, 2.0f).m_60918_(SoundType.f_56736_).m_60955_().m_60922_(VALID_SPAWN).m_60924_(ALWAYS_FALSE_POSITION).m_60960_(ALWAYS_FALSE_POSITION).m_60971_(ALWAYS_FALSE_POSITION)));
    public static final Supplier<Block> MASON_TABLE = ChippedBlocks.register("mason_table", () -> new ChippedWorkbench((windowId, inventory, access) -> new ChippedMenu(windowId, inventory, access, ChippedMenuType.MASON_TABLE.get(), ChippedRecipeTypes.MASON_TABLE_TYPE.get(), MASON_TABLE.get()), BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_56743_).m_60955_().m_60922_(VALID_SPAWN).m_60924_(ALWAYS_FALSE_POSITION).m_60960_(ALWAYS_FALSE_POSITION).m_60971_(ALWAYS_FALSE_POSITION)));
    public static final Supplier<Block> ALCHEMY_BENCH = ChippedBlocks.register("alchemy_bench", () -> new ChippedWorkbench((windowId, inventory, access) -> new ChippedMenu(windowId, inventory, access, ChippedMenuType.ALCHEMY_BENCH.get(), ChippedRecipeTypes.ALCHEMY_BENCH_TYPE.get(), ALCHEMY_BENCH.get()), BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(1.0f, 2.0f).m_60918_(SoundType.f_56736_).m_60955_().m_60922_(VALID_SPAWN).m_60924_(ALWAYS_FALSE_POSITION).m_60960_(ALWAYS_FALSE_POSITION).m_60971_(ALWAYS_FALSE_POSITION)));
    public static final Supplier<Block> MECHANIST_WORKBENCH = ChippedBlocks.register("mechanist_workbench", () -> new ChippedWorkbench((windowId, inventory, access) -> new ChippedMenu(windowId, inventory, access, ChippedMenuType.MECHANIST_WORKBENCH.get(), ChippedRecipeTypes.MECHANIST_WORKBENCH_TYPE.get(), MECHANIST_WORKBENCH.get()), BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(1.0f, 2.0f).m_60918_(SoundType.f_56736_).m_60955_().m_60922_(VALID_SPAWN).m_60924_(ALWAYS_FALSE_POSITION).m_60960_(ALWAYS_FALSE_POSITION).m_60971_(ALWAYS_FALSE_POSITION)));

    public static void register() {
        ChippedBlocks.registerItem("botanist_workbench", () -> new BlockItem(BOTANIST_WORKBENCH.get(), new Item.Properties().m_41491_(Chipped.CHIPPED_ITEM_GROUP)));
        ChippedBlocks.registerItem("glassblower", () -> new BlockItem(GLASSBLOWER.get(), new Item.Properties().m_41491_(Chipped.CHIPPED_ITEM_GROUP)));
        ChippedBlocks.registerItem("carpenters_table", () -> new BlockItem(CARPENTERS_TABLE.get(), new Item.Properties().m_41491_(Chipped.CHIPPED_ITEM_GROUP)));
        ChippedBlocks.registerItem("loom_table", () -> new BlockItem(LOOM_TABLE.get(), new Item.Properties().m_41491_(Chipped.CHIPPED_ITEM_GROUP)));
        ChippedBlocks.registerItem("mason_table", () -> new BlockItem(MASON_TABLE.get(), new Item.Properties().m_41491_(Chipped.CHIPPED_ITEM_GROUP)));
        ChippedBlocks.registerItem("alchemy_bench", () -> new BlockItem(ALCHEMY_BENCH.get(), new Item.Properties().m_41491_(Chipped.CHIPPED_ITEM_GROUP)));
        ChippedBlocks.registerItem("mechanist_workbench", () -> new BlockItem(MECHANIST_WORKBENCH.get(), new Item.Properties().m_41491_(Chipped.CHIPPED_ITEM_GROUP)));
        ChippedBlocks.registerBlockWithPalette(Blocks.f_152490_, 69);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50722_, 69);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50334_, 69);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50618_, 33, new ChippedProperties().blockType(BarrelBlock::new));
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50137_, 69);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50730_, 69);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50568_, 69);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50453_, 11, new ChippedProperties().blockType(RotatedPillarBlock::new));
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50078_, 16);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50076_, 133);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50180_, 24);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_152497_, 69);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50143_, 22, new ChippedProperties().blockType(p -> new CarvedPumpkinBlock((BlockBehaviour.Properties)p){}));
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50129_, 67, new ChippedProperties().excludeLoot());
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50353_, 67);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50652_, 69);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50723_, 69, new ChippedProperties().blockType(CryingObsidianBlock::new));
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50379_, 69);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_152550_, 69);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50090_, 12);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50228_, 69);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50493_, 69);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50577_, 12, new ChippedProperties().excludeModel());
        ChippedBlocks.registerBlockWithPalette(Blocks.f_152537_, 69);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50268_, 12);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50259_, 69);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50706_, 69);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50141_, 20);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50074_, 12);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50122_, 69);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_49994_, 7, new ChippedProperties().blockType(FallingBlock::new));
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50335_, 8, new ChippedProperties().blockType(HayBlock::new));
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50126_, 69, new ChippedProperties().blockType(IceBlock::new));
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50183_, 21, new ChippedProperties().blockType(p -> new IronBarsBlock((BlockBehaviour.Properties)p){}).cutout());
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50075_, 12);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50144_, 22, new ChippedProperties().blockType(p -> new CarvedPumpkinBlock((BlockBehaviour.Properties)p){}));
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50155_, 10, new ChippedProperties().blockType(p -> new LadderBlock((BlockBehaviour.Properties)p){}).cutout());
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50060_, 69);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50729_, 69);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50450_, 69);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50186_, 10, new ChippedProperties().blockType(p -> new MelonBlock((BlockBehaviour.Properties)p){}).excludeLoot());
        ChippedBlocks.registerBlockWithPalette(Blocks.f_152544_, 11, new ChippedProperties().blockType(MossBlock::new));
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50079_, 69);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50223_, 69);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50182_, 7);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50197_, 69);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50451_, 14);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50721_, 12);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50134_, 69);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50080_, 69);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50354_, 69);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50377_, 69);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50133_, 16, new ChippedProperties().blockType(p -> new PumpkinBlock((BlockBehaviour.Properties)p){}));
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50492_, 69);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50333_, 69);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_152599_, 61);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_152600_, 61);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_152598_, 61);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50181_, 15);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50452_, 69);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50394_, 69);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50330_, 69, new ChippedProperties().blockType(PoweredBlock::new));
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50261_, 18, new ChippedProperties().blockType(RedstoneLampBlock::new));
        ChippedBlocks.registerBlockWithPalette(Blocks.f_49992_, 12, new ChippedProperties().blockType(FallingBlock::new));
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50062_, 69);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50386_, 16);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50701_, 16);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50470_, 69);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50127_, 69);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50135_, 11, new ChippedProperties().blockType(SoulSandBlock::new));
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50056_, 7, new ChippedProperties().blockType(p -> new SpongeBlock((BlockBehaviour.Properties)p){}));
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50069_, 69);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_152496_, 69);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50692_, 14, new ChippedProperties().cutout());
        ChippedBlocks.registerBlockWithPalette(Blocks.f_152571_, 11);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_152573_, 11);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_152574_, 11);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_152572_, 11);
        ChippedBlocks.registerGlass(Blocks.f_50058_, Blocks.f_50185_, 101);
        ChippedBlocks.registerGlass(Blocks.f_50147_, Blocks.f_50303_, 10);
        ChippedBlocks.registerGlass(Blocks.f_50148_, Blocks.f_50304_, 10);
        ChippedBlocks.registerGlass(Blocks.f_50202_, Blocks.f_50305_, 10);
        ChippedBlocks.registerGlass(Blocks.f_50203_, Blocks.f_50306_, 10);
        ChippedBlocks.registerGlass(Blocks.f_50204_, Blocks.f_50307_, 10);
        ChippedBlocks.registerGlass(Blocks.f_50205_, Blocks.f_50361_, 10);
        ChippedBlocks.registerGlass(Blocks.f_50206_, Blocks.f_50362_, 10);
        ChippedBlocks.registerGlass(Blocks.f_50207_, Blocks.f_50363_, 10);
        ChippedBlocks.registerGlass(Blocks.f_50208_, Blocks.f_50364_, 10);
        ChippedBlocks.registerGlass(Blocks.f_50209_, Blocks.f_50365_, 10);
        ChippedBlocks.registerGlass(Blocks.f_50210_, Blocks.f_50366_, 10);
        ChippedBlocks.registerGlass(Blocks.f_50211_, Blocks.f_50367_, 10);
        ChippedBlocks.registerGlass(Blocks.f_50212_, Blocks.f_50368_, 10);
        ChippedBlocks.registerGlass(Blocks.f_50213_, Blocks.f_50369_, 10);
        ChippedBlocks.registerGlass(Blocks.f_50214_, Blocks.f_50370_, 10);
        ChippedBlocks.registerGlass(Blocks.f_50215_, Blocks.f_50371_, 10);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50744_, 41);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50742_, 41);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50655_, 41);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50745_, 41);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50743_, 41);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50705_, 41);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50741_, 41);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50656_, 41);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50003_, 11, new ChippedProperties().blockType(RotatedPillarBlock::new));
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50001_, 11, new ChippedProperties().blockType(RotatedPillarBlock::new));
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50695_, 11, new ChippedProperties().blockType(RotatedPillarBlock::new));
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50004_, 11, new ChippedProperties().blockType(RotatedPillarBlock::new));
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50002_, 11, new ChippedProperties().blockType(RotatedPillarBlock::new));
        ChippedBlocks.registerBlockWithPalette(Blocks.f_49999_, 11, new ChippedProperties().blockType(RotatedPillarBlock::new));
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50000_, 11, new ChippedProperties().blockType(RotatedPillarBlock::new));
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50686_, 10, new ChippedProperties().blockType(RotatedPillarBlock::new));
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50008_, 16, new ChippedProperties().blockType(RotatedPillarBlock::new));
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50006_, 16, new ChippedProperties().blockType(RotatedPillarBlock::new));
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50696_, 16, new ChippedProperties().blockType(RotatedPillarBlock::new));
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50009_, 11, new ChippedProperties().blockType(RotatedPillarBlock::new));
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50007_, 16, new ChippedProperties().blockType(RotatedPillarBlock::new));
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50010_, 16, new ChippedProperties().blockType(RotatedPillarBlock::new));
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50005_, 16, new ChippedProperties().blockType(RotatedPillarBlock::new));
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50687_, 16, new ChippedProperties().blockType(RotatedPillarBlock::new));
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50054_, 12, new ChippedProperties().blockType(LeavesBlock::new).transparent().excludeLoot());
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50052_, 12, new ChippedProperties().blockType(LeavesBlock::new).transparent().excludeLoot());
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50055_, 12, new ChippedProperties().blockType(LeavesBlock::new).transparent().excludeLoot());
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50053_, 12, new ChippedProperties().blockType(LeavesBlock::new).transparent().excludeLoot());
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50050_, 12, new ChippedProperties().blockType(LeavesBlock::new).transparent().excludeLoot());
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50051_, 12, new ChippedProperties().blockType(LeavesBlock::new).transparent().excludeLoot());
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50287_, 66);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50288_, 66);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50289_, 66);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50290_, 66);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50291_, 66);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50292_, 66);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50293_, 66);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50294_, 66);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50295_, 66);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50296_, 66);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50297_, 66);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50298_, 66);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50299_, 66);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50300_, 66);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50301_, 66);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50302_, 66);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50526_, 11);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50527_, 11);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50528_, 11);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50529_, 11);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50530_, 11);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50531_, 11);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50532_, 11);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50533_, 11);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50534_, 11);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50535_, 11);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50536_, 11);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50537_, 11);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50538_, 11);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50539_, 11);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50540_, 11);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50541_, 11);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50542_, 21);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50505_, 21);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50501_, 21);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50502_, 21);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50499_, 21);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50497_, 21);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50503_, 21);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50545_, 21);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50498_, 21);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50495_, 21);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50544_, 21);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50543_, 21);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50496_, 21);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50500_, 21);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50504_, 21);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50494_, 21);
        ChippedBlocks.registerWool(Blocks.f_50041_, Blocks.f_50336_, 20);
        ChippedBlocks.registerWool(Blocks.f_50042_, Blocks.f_50337_, 20);
        ChippedBlocks.registerWool(Blocks.f_50096_, Blocks.f_50338_, 20);
        ChippedBlocks.registerWool(Blocks.f_50097_, Blocks.f_50339_, 20);
        ChippedBlocks.registerWool(Blocks.f_50098_, Blocks.f_50340_, 20);
        ChippedBlocks.registerWool(Blocks.f_50099_, Blocks.f_50341_, 20);
        ChippedBlocks.registerWool(Blocks.f_50100_, Blocks.f_50342_, 20);
        ChippedBlocks.registerWool(Blocks.f_50101_, Blocks.f_50343_, 20);
        ChippedBlocks.registerWool(Blocks.f_50102_, Blocks.f_50344_, 20);
        ChippedBlocks.registerWool(Blocks.f_50103_, Blocks.f_50345_, 20);
        ChippedBlocks.registerWool(Blocks.f_50104_, Blocks.f_50346_, 20);
        ChippedBlocks.registerWool(Blocks.f_50105_, Blocks.f_50347_, 20);
        ChippedBlocks.registerWool(Blocks.f_50106_, Blocks.f_50348_, 20);
        ChippedBlocks.registerWool(Blocks.f_50107_, Blocks.f_50349_, 20);
        ChippedBlocks.registerWool(Blocks.f_50108_, Blocks.f_50350_, 20);
        ChippedBlocks.registerWool(Blocks.f_50109_, Blocks.f_50351_, 20);
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50487_, 20, new ChippedProperties().itemType(DoubleHighBlockItem::new).blockType(p -> new DoorBlock((BlockBehaviour.Properties)p){}).cutout().excludeLoot());
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50488_, 20, new ChippedProperties().itemType(DoubleHighBlockItem::new).blockType(p -> new DoorBlock((BlockBehaviour.Properties)p){}).cutout().excludeLoot());
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50485_, 20, new ChippedProperties().itemType(DoubleHighBlockItem::new).blockType(p -> new DoorBlock((BlockBehaviour.Properties)p){}).cutout().excludeLoot());
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50486_, 20, new ChippedProperties().itemType(DoubleHighBlockItem::new).blockType(p -> new DoorBlock((BlockBehaviour.Properties)p){}).cutout().excludeLoot());
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50154_, 20, new ChippedProperties().itemType(DoubleHighBlockItem::new).blockType(p -> new DoorBlock((BlockBehaviour.Properties)p){}).cutout().excludeLoot());
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50484_, 20, new ChippedProperties().itemType(DoubleHighBlockItem::new).blockType(p -> new DoorBlock((BlockBehaviour.Properties)p){}).cutout().excludeLoot());
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50671_, 20, new ChippedProperties().itemType(DoubleHighBlockItem::new).blockType(p -> new DoorBlock((BlockBehaviour.Properties)p){}).cutout().excludeLoot());
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50672_, 20, new ChippedProperties().itemType(DoubleHighBlockItem::new).blockType(p -> new DoorBlock((BlockBehaviour.Properties)p){}).cutout().excludeLoot());
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50220_, 11, new ChippedProperties().blockType(p -> new TrapDoorBlock((BlockBehaviour.Properties)p){}).cutout().excludeLoot());
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50221_, 11, new ChippedProperties().blockType(p -> new TrapDoorBlock((BlockBehaviour.Properties)p){}).cutout().excludeLoot());
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50218_, 11, new ChippedProperties().blockType(p -> new TrapDoorBlock((BlockBehaviour.Properties)p){}).cutout().excludeLoot());
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50219_, 11, new ChippedProperties().blockType(p -> new TrapDoorBlock((BlockBehaviour.Properties)p){}).cutout().excludeLoot());
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50216_, 11, new ChippedProperties().blockType(p -> new TrapDoorBlock((BlockBehaviour.Properties)p){}).cutout().excludeLoot());
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50217_, 11, new ChippedProperties().blockType(p -> new TrapDoorBlock((BlockBehaviour.Properties)p){}).cutout().excludeLoot());
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50663_, 11, new ChippedProperties().blockType(p -> new TrapDoorBlock((BlockBehaviour.Properties)p){}).cutout().excludeLoot());
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50664_, 11, new ChippedProperties().blockType(p -> new TrapDoorBlock((BlockBehaviour.Properties)p){}).cutout().excludeLoot());
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50072_, 15, new ChippedProperties().blockType(p -> new MushroomBlock(p, () -> TreeFeatures.f_195121_)).cutout());
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50033_, 10, new ChippedProperties().blockType(WebBlock::new).cutout().excludeLoot());
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50700_, 15, new ChippedProperties().blockType(p -> new FungusBlock((BlockBehaviour.Properties)p, () -> TreeFeatures.f_195118_){}).cutout());
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50654_, 14, new ChippedProperties().blockType(p -> new RootsBlock((BlockBehaviour.Properties)p){}).cutout());
        ChippedBlocks.registerBlockWithPalette(Blocks.f_152588_, 13, new ChippedProperties().blockType(CustomPointedDripstoneBlock::new).cutout().excludeModel());
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50196_, 22, new ChippedProperties().blockType(p -> new WaterlilyBlock((BlockBehaviour.Properties)p){}).cutout().itemType(WaterLilyBlockItem::new));
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50694_, 20, new ChippedProperties().blockType(NetherSproutsBlock::new).cutout().excludeLoot());
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50073_, 15, new ChippedProperties().blockType(p -> new MushroomBlock(p, () -> TreeFeatures.f_195122_)).cutout());
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50191_, 11, new ChippedProperties().blockType(VineBlock::new).cutout().excludeLoot());
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50691_, 14, new ChippedProperties().blockType(p -> new FungusBlock((BlockBehaviour.Properties)p, () -> TreeFeatures.f_195120_){}).cutout());
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50693_, 9, new ChippedProperties().blockType(p -> new RootsBlock((BlockBehaviour.Properties)p){}).cutout());
        ChippedBlocks.registerTorch(Blocks.f_50081_, Blocks.f_50082_, 9, p -> new TorchBlock((BlockBehaviour.Properties)p, (ParticleOptions)ParticleTypes.f_123744_){}, p -> new WallTorchBlock((BlockBehaviour.Properties)p, (ParticleOptions)ParticleTypes.f_123744_){});
        ChippedBlocks.registerTorch(Blocks.f_50174_, Blocks.f_50123_, 5, p -> new RedstoneTorchBlock((BlockBehaviour.Properties)p){}, p -> new RedstoneWallTorchBlock((BlockBehaviour.Properties)p){});
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50681_, 14, new ChippedProperties().blockType(LanternBlock::new).cutout().excludeModel());
        ChippedBlocks.registerBlockWithPalette(Blocks.f_50682_, 11, new ChippedProperties().blockType(LanternBlock::new).cutout().excludeModel());
        ChippedBlocks.register("special_lantern_1", Blocks.f_50681_, new ChippedProperties().blockType(p -> new ChippedUniqueLantern((BlockBehaviour.Properties)p, ChippedUniqueLantern.CHONK_LANTERN_SHAPE)).cutout().excludeModel());
        ChippedBlocks.register("special_lantern_2", Blocks.f_50681_, new ChippedProperties().blockType(p -> new ChippedUniqueLantern((BlockBehaviour.Properties)p, ChippedUniqueLantern.DONUT_LANTERN_SHAPE_EAST, ChippedUniqueLantern.DONUT_LANTERN_SHAPE_NORTH)).cutout().excludeModel());
        ChippedBlocks.register("special_lantern_3", Blocks.f_50681_, new ChippedProperties().blockType(p -> new ChippedUniqueLantern((BlockBehaviour.Properties)p, ChippedUniqueLantern.TALL_LANTERN_SHAPE)).cutout().excludeModel());
        ChippedBlocks.register("special_lantern_4", Blocks.f_50681_, new ChippedProperties().blockType(p -> new ChippedUniqueLantern((BlockBehaviour.Properties)p, ChippedUniqueLantern.THICC_LANTERN_SHAPE)).cutout().excludeModel());
        ChippedBlocks.register("special_soul_lantern_1", Blocks.f_50681_, new ChippedProperties().blockType(p -> new ChippedUniqueLantern((BlockBehaviour.Properties)p, ChippedUniqueLantern.CHONK_LANTERN_SHAPE)).cutout().excludeModel());
        ChippedBlocks.register("special_soul_lantern_2", Blocks.f_50681_, new ChippedProperties().blockType(p -> new ChippedUniqueLantern((BlockBehaviour.Properties)p, ChippedUniqueLantern.DONUT_LANTERN_SHAPE_EAST, ChippedUniqueLantern.DONUT_LANTERN_SHAPE_NORTH)).cutout().excludeModel());
        ChippedBlocks.register("special_soul_lantern_3", Blocks.f_50681_, new ChippedProperties().blockType(p -> new ChippedUniqueLantern((BlockBehaviour.Properties)p, ChippedUniqueLantern.TALL_LANTERN_SHAPE)).cutout().excludeModel());
        ChippedBlocks.register("special_soul_lantern_4", Blocks.f_50681_, new ChippedProperties().blockType(p -> new ChippedUniqueLantern((BlockBehaviour.Properties)p, ChippedUniqueLantern.THICC_LANTERN_SHAPE)).cutout().excludeModel());
        REGISTERED_BLOCKS.forEach(block -> ChippedTags.addOrCreateTag((ResourceLocation)block.getSecond()));
    }

    private static void registerWool(Block wool, Block carpet, int count) {
        ChippedBlocks.registerPair(wool, carpet, count, new ChippedProperties(), new ChippedProperties().blockType(CarpetBlock::new));
    }

    private static void registerGlass(Block glass, Block pane, int count) {
        ChippedBlocks.registerPair(glass, pane, count, new ChippedProperties().transparent().excludeLoot().blockType(GlassBlock::new), new ChippedProperties().transparent().excludeLoot().blockType(p -> new IronBarsBlock((BlockBehaviour.Properties)p){}));
    }

    private static void registerTorch(Block torch, Block wallTorch, int count, Function<BlockBehaviour.Properties, Block> type1, Function<BlockBehaviour.Properties, Block> type2) {
        List<Pair<Supplier<? extends Block>, Supplier<? extends Block>>> pairs = ChippedBlocks.registerPair(torch, wallTorch, count, new ChippedProperties().cutout().blockType(type1).skipItem(), new ChippedProperties().cutout().excludeLoot().blockType(type2).skipItem());
        int i = 0;
        for (Pair<Supplier<? extends Block>, Supplier<? extends Block>> pair : pairs) {
            String appended = Registry.f_122824_.m_7981_((Object)torch).m_135815_() + "_" + (i + 1);
            ChippedBlocks.registerItem(appended, () -> new StandingAndWallBlockItem((Block)((Supplier)pair.getFirst()).get(), (Block)((Supplier)pair.getSecond()).get(), new Item.Properties().m_41491_(Chipped.CHIPPED_ITEM_GROUP)));
            ++i;
        }
    }

    private static void registerBlockWithPalette(Block ref, int count) {
        ChippedBlocks.registerBlockWithPalette(ref, count, new ChippedProperties().blockType(Block::new));
    }

    private static void registerBlockWithPalette(Block ref, int count, ChippedProperties properties) {
        for (int i = 0; i < count; ++i) {
            String appended = Registry.f_122824_.m_7981_((Object)ref).m_135815_() + "_" + (i + 1);
            ChippedBlocks.register(appended, ref, properties);
        }
    }

    private static List<Pair<Supplier<? extends Block>, Supplier<? extends Block>>> registerPair(Block ref, Block ref1, int count, ChippedProperties properties, ChippedProperties properties1) {
        ArrayList<Pair<Supplier<? extends Block>, Supplier<? extends Block>>> pairs = new ArrayList<Pair<Supplier<? extends Block>, Supplier<? extends Block>>>();
        for (int i = 0; i < count; ++i) {
            String appended = Registry.f_122824_.m_7981_((Object)ref).m_135815_() + "_" + (i + 1);
            Supplier<Block> block = ChippedBlocks.register(appended, ref, properties);
            String appended1 = Registry.f_122824_.m_7981_((Object)ref1).m_135815_() + "_" + (i + 1);
            Supplier<Block> block1 = ChippedBlocks.register(appended1, ref1, properties1);
            SKIPPED_MODELS.add(block);
            SKIPPED_MODELS.add(block1);
            pairs.add((Pair<Supplier<? extends Block>, Supplier<? extends Block>>)Pair.of(block, block1));
        }
        BLOCK_PAIRS.addAll(pairs);
        return pairs;
    }

    private static Supplier<Block> register(String id, Block block, ChippedProperties properties) {
        Pair<Supplier<Block>, ResourceLocation> output = RegistryHelpers.registerFull(Registry.f_122824_, id, () -> properties.getBlockType().apply(BlockBehaviour.Properties.m_60926_((BlockBehaviour)block)));
        Supplier registered = (Supplier)output.getFirst();
        BLOCKS.add(registered);
        if (!properties.skippedItem()) {
            ChippedBlocks.registerItem(id, () -> ChippedBlocks.lambda$register$73(properties, (Supplier)registered));
        }
        if (properties.isCutout()) {
            CUTOUT_BLOCKS.add(registered);
        }
        if (properties.isTransparent()) {
            TRANSPARENT_BLOCKS.add(registered);
        }
        if (properties.isExcludedFromLootTable()) {
            EXCLUDED_DROPS.add(registered);
        }
        if (properties.isExcludedModel()) {
            SKIPPED_MODELS.add(registered);
        }
        REGISTERED_BLOCKS.add(output);
        return registered;
    }

    private static <T extends Block> Supplier<T> register(String id, Supplier<T> block) {
        Supplier<T> registered = RegistryHelpers.register(Registry.f_122824_, id, block);
        BLOCKS.add(registered);
        return registered;
    }

    private static <T extends Item> Supplier<T> registerItem(String id, Supplier<T> item) {
        Supplier<T> registered = RegistryHelpers.register(Registry.f_122827_, id, item);
        ITEMS.add(registered);
        return registered;
    }

    private static /* synthetic */ Item lambda$register$73(ChippedProperties properties, Supplier registered) {
        return properties.getItemType().apply((Block)registered.get(), new Item.Properties().m_41491_(Chipped.CHIPPED_ITEM_GROUP));
    }
}

