/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.chipped.compat.jei;

import earth.terrarium.chipped.compat.jei.ChippedRecipeCategory;
import earth.terrarium.chipped.recipe.ChippedRecipe;
import earth.terrarium.chipped.registry.ChippedBlocks;
import earth.terrarium.chipped.registry.ChippedRecipeTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private static final ResourceLocation UID = new ResourceLocation("chipped", "chipped");

    @NotNull
    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper helper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new ChippedRecipeCategory(ChippedBlocks.BOTANIST_WORKBENCH.get().m_5456_(), helper), new ChippedRecipeCategory(ChippedBlocks.GLASSBLOWER.get().m_5456_(), helper), new ChippedRecipeCategory(ChippedBlocks.CARPENTERS_TABLE.get().m_5456_(), helper), new ChippedRecipeCategory(ChippedBlocks.LOOM_TABLE.get().m_5456_(), helper), new ChippedRecipeCategory(ChippedBlocks.MASON_TABLE.get().m_5456_(), helper), new ChippedRecipeCategory(ChippedBlocks.ALCHEMY_BENCH.get().m_5456_(), helper), new ChippedRecipeCategory(ChippedBlocks.MECHANIST_WORKBENCH.get().m_5456_(), helper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager recipeManager = Minecraft.m_91087_().f_91073_.m_7465_();
        registration.addRecipes(JEIPlugin.flatten(recipeManager.m_44013_(ChippedRecipeTypes.BOTANIST_WORKBENCH_TYPE.get())), JEIPlugin.getUidFromId("botanist_workbench"));
        registration.addRecipes(JEIPlugin.flatten(recipeManager.m_44013_(ChippedRecipeTypes.GLASSBLOWER_TYPE.get())), JEIPlugin.getUidFromId("glassblower"));
        registration.addRecipes(JEIPlugin.flatten(recipeManager.m_44013_(ChippedRecipeTypes.CARPENTERS_TABLE_TYPE.get())), JEIPlugin.getUidFromId("carpenters_table"));
        registration.addRecipes(JEIPlugin.flatten(recipeManager.m_44013_(ChippedRecipeTypes.LOOM_TABLE_TYPE.get())), JEIPlugin.getUidFromId("loom_table"));
        registration.addRecipes(JEIPlugin.flatten(recipeManager.m_44013_(ChippedRecipeTypes.MASON_TABLE_TYPE.get())), JEIPlugin.getUidFromId("mason_table"));
        registration.addRecipes(JEIPlugin.flatten(recipeManager.m_44013_(ChippedRecipeTypes.ALCHEMY_BENCH_TYPE.get())), JEIPlugin.getUidFromId("alchemy_bench"));
        registration.addRecipes(JEIPlugin.flatten(recipeManager.m_44013_(ChippedRecipeTypes.MECHANIST_WORKBENCH_TYPE.get())), JEIPlugin.getUidFromId("mechanist_workbench"));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ChippedBlocks.BOTANIST_WORKBENCH.get()), new ResourceLocation[]{JEIPlugin.getUidFromId("botanist_workbench")});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ChippedBlocks.GLASSBLOWER.get()), new ResourceLocation[]{JEIPlugin.getUidFromId("glassblower")});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ChippedBlocks.CARPENTERS_TABLE.get()), new ResourceLocation[]{JEIPlugin.getUidFromId("carpenters_table")});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ChippedBlocks.LOOM_TABLE.get()), new ResourceLocation[]{JEIPlugin.getUidFromId("loom_table")});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ChippedBlocks.MASON_TABLE.get()), new ResourceLocation[]{JEIPlugin.getUidFromId("mason_table")});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ChippedBlocks.ALCHEMY_BENCH.get()), new ResourceLocation[]{JEIPlugin.getUidFromId("alchemy_bench")});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ChippedBlocks.MECHANIST_WORKBENCH.get()), new ResourceLocation[]{JEIPlugin.getUidFromId("mechanist_workbench")});
    }

    private static List<ChippedRecipeCategory.FlattenedRecipe> flatten(Collection<ChippedRecipe> recipes) {
        ArrayList<ChippedRecipeCategory.FlattenedRecipe> flattenedRecipes = new ArrayList<ChippedRecipeCategory.FlattenedRecipe>();
        for (ChippedRecipe recipe : recipes) {
            for (HolderSet<Item> tag : recipe.tags()) {
                List<Item> items = tag.m_203614_().filter(Holder::m_203633_).map(Holder::m_203334_).toList();
                Ingredient ingredient = Ingredient.m_43921_(items.stream().map(ItemStack::new));
                for (Item item : items) {
                    flattenedRecipes.add(new ChippedRecipeCategory.FlattenedRecipe(ingredient, new ItemStack((ItemLike)item)));
                }
            }
        }
        return flattenedRecipes;
    }

    private static ResourceLocation getUidFromId(String id) {
        return new ResourceLocation("chipped", id);
    }
}

