/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.chipped.block;

import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class ChippedWorkbench
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    protected static final VoxelShape WORKBENCH_NORTH_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WORKBENCH_EAST_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WORKBENCH_WEST_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WORKBENCH_SOUTH_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final EnumProperty<WorkbenchModelType> MODEL_TYPE = EnumProperty.m_61587_((String)"model", WorkbenchModelType.class);
    private final ContainerFactory factory;
    private final LazyLoadedValue<Component> containerName;

    public ChippedWorkbench(ContainerFactory factory, BlockBehaviour.Properties properties) {
        super(properties);
        this.factory = factory;
        this.containerName = new LazyLoadedValue(() -> new TranslatableComponent("container.chipped." + Registry.f_122824_.m_7981_((Object)this).m_135815_()));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(MODEL_TYPE, (Comparable)((Object)WorkbenchModelType.MAIN)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, Level worldIn, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand handIn, @NotNull BlockHitResult hit) {
        if (worldIn.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        player.m_5893_(state.m_60750_(worldIn, pos));
        return InteractionResult.CONSUME;
    }

    @Nullable
    public MenuProvider m_7246_(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos) {
        return new SimpleMenuProvider((id, inventory, player) -> this.factory.create(id, inventory, ContainerLevelAccess.m_39289_((Level)worldIn, (BlockPos)pos)), (Component)this.containerName.m_13971_());
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        if (!worldIn.f_46443_) {
            BlockPos otherpos;
            BlockState otherstate;
            WorkbenchModelType workbenchModel = (WorkbenchModelType)((Object)state.m_61143_(MODEL_TYPE));
            if (workbenchModel == WorkbenchModelType.MAIN && (otherstate = worldIn.m_8055_(otherpos = pos.m_142300_(((Direction)state.m_61143_((Property)FACING)).m_122427_()))).m_60734_() == this) {
                worldIn.m_7731_(otherpos, Blocks.f_50016_.m_49966_(), 35);
                worldIn.m_5898_(player, 2001, otherpos, Block.m_49956_((BlockState)otherstate));
            }
            if (workbenchModel == WorkbenchModelType.SIDE && (otherstate = worldIn.m_8055_(otherpos = pos.m_142300_(((Direction)state.m_61143_((Property)FACING)).m_122428_()))).m_60734_() == this) {
                worldIn.m_7731_(otherpos, Blocks.f_50016_.m_49966_(), 35);
                worldIn.m_5898_(player, 2001, otherpos, Block.m_49956_((BlockState)otherstate));
            }
        }
        super.m_5707_(worldIn, pos, state, player);
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        if (!worldIn.f_46443_) {
            BlockPos blockpos = pos.m_142300_(((Direction)state.m_61143_((Property)FACING)).m_122427_());
            worldIn.m_7731_(blockpos, (BlockState)state.m_61124_(MODEL_TYPE, (Comparable)((Object)WorkbenchModelType.SIDE)), 3);
            worldIn.m_6289_(pos, Blocks.f_50016_);
            state.m_60701_((LevelAccessor)worldIn, pos, 3);
        }
    }

    public VoxelShape m_5940_(BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case NORTH: {
                return WORKBENCH_NORTH_SHAPE;
            }
            case SOUTH: {
                return WORKBENCH_SOUTH_SHAPE;
            }
            case WEST: {
                return WORKBENCH_WEST_SHAPE;
            }
        }
        return WORKBENCH_EAST_SHAPE;
    }

    @Deprecated
    public PushReaction m_5537_(BlockState state) {
        return PushReaction.BLOCK;
    }

    public VoxelShape m_7947_(BlockState state, BlockGetter reader, BlockPos pos) {
        return Shapes.m_83040_();
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, MODEL_TYPE});
    }

    @Deprecated
    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos otherpos = pos.m_142300_(((Direction)state.m_61143_((Property)FACING)).m_122427_());
        return worldIn.m_8055_(otherpos).m_60767_().m_76336_();
    }

    @Deprecated
    @OnlyIn(value=Dist.CLIENT)
    public float m_7749_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1.0f;
    }

    @FunctionalInterface
    public static interface ContainerFactory {
        public AbstractContainerMenu create(int var1, Inventory var2, ContainerLevelAccess var3);
    }

    public static enum WorkbenchModelType implements StringRepresentable
    {
        MAIN,
        SIDE;


        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public String toString() {
            return this.m_7912_();
        }
    }
}

