/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.extradisks.items.storageblocks;

import com.refinedmods.refinedstorage.api.storage.disk.IStorageDisk;
import com.refinedmods.refinedstorage.api.storage.disk.StorageDiskSyncData;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.block.BaseBlock;
import com.refinedmods.refinedstorage.item.blockitem.BaseBlockItem;
import com.refinedmods.refinedstorage.render.Styles;
import de.melanx.extradisks.blocks.fluid.ExtraFluidStorageBlock;
import de.melanx.extradisks.items.Registration;
import de.melanx.extradisks.items.fluid.ExtraFluidStoragePartItem;
import de.melanx.extradisks.items.fluid.ExtraFluidStorageType;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ExtraFluidStorageBlockItem
extends BaseBlockItem {
    private final ExtraFluidStorageType type;

    public ExtraFluidStorageBlockItem(ExtraFluidStorageBlock block, Item.Properties builder) {
        super((BaseBlock)block, builder);
        this.type = block.getType();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        if (this.isValid(stack)) {
            UUID id = this.getId(stack);
            API.instance().getStorageDiskSync().sendRequest(id);
            StorageDiskSyncData data = API.instance().getStorageDiskSync().getData(id);
            if (data != null) {
                if (data.getCapacity() == -1) {
                    tooltip.add((Component)new TranslatableComponent("misc.refinedstorage.storage.stored", new Object[]{API.instance().getQuantityFormatter().format(data.getStored())}).m_6270_(Styles.GRAY));
                } else {
                    tooltip.add((Component)new TranslatableComponent("misc.refinedstorage.storage.stored_capacity", new Object[]{API.instance().getQuantityFormatter().format(data.getStored()), API.instance().getQuantityFormatter().format(data.getCapacity())}).m_6270_(Styles.GRAY));
                }
            }
            if (flag.m_7050_()) {
                tooltip.add((Component)new TextComponent(id.toString()).m_6270_(Styles.GRAY));
            }
        }
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.f_46443_ && player.m_6047_()) {
            UUID diskId = null;
            IStorageDisk disk = null;
            if (this.isValid(stack)) {
                diskId = this.getId(stack);
                disk = API.instance().getStorageDiskManager((ServerLevel)level).get(diskId);
            }
            if (disk == null || disk.getStored() == 0) {
                ItemStack part = new ItemStack((ItemLike)ExtraFluidStoragePartItem.getByType(this.type));
                if (!player.m_150109_().m_36054_(part.m_41777_())) {
                    Containers.m_18992_((Level)level, (double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_(), (ItemStack)part);
                }
                if (disk != null) {
                    API.instance().getStorageDiskManager((ServerLevel)level).remove(diskId);
                    API.instance().getStorageDiskManager((ServerLevel)level).markForSaving();
                }
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)new ItemStack((ItemLike)Registration.ADVANCED_MACHINE_CASING.get()));
            }
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    public int getEntityLifespan(ItemStack itemStack, Level level) {
        return Integer.MAX_VALUE;
    }

    private UUID getId(ItemStack disk) {
        return disk.m_41784_().m_128342_("Id");
    }

    private boolean isValid(ItemStack disk) {
        return disk.m_41782_() && disk.m_41784_().m_128403_("Id");
    }
}

