/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.extradisks.blocks.item;

import com.refinedmods.refinedstorage.api.storage.IStorage;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDisk;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.node.storage.ItemStorageWrapperStorageDisk;
import com.refinedmods.refinedstorage.apiimpl.network.node.storage.StorageNetworkNode;
import de.melanx.extradisks.ModConfig;
import de.melanx.extradisks.blocks.item.ExtraItemStorageBlockEntity;
import de.melanx.extradisks.items.item.ExtraItemStorageType;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ExtraItemStorageNetworkNode
extends StorageNetworkNode {
    public static final ResourceLocation BLOCK_256K_ID = new ResourceLocation("extradisks", "256k_storage_block");
    public static final ResourceLocation BLOCK_1024K_ID = new ResourceLocation("extradisks", "1024k_storage_block");
    public static final ResourceLocation BLOCK_4096K_ID = new ResourceLocation("extradisks", "4096k_storage_block");
    public static final ResourceLocation BLOCK_16384K_ID = new ResourceLocation("extradisks", "16384k_storage_block");
    public static final ResourceLocation BLOCK_65536K_ID = new ResourceLocation("extradisks", "65536k_storage_block");
    public static final ResourceLocation BLOCK_262144K_ID = new ResourceLocation("extradisks", "262144k_storage_block");
    public static final ResourceLocation BLOCK_1048576K_ID = new ResourceLocation("extradisks", "1048576k_storage_block");
    public static final ResourceLocation BLOCK_INFINITE_ID = new ResourceLocation("extradisks", "infinite_storage_block");
    private final ExtraItemStorageType type;
    private IStorageDisk<ItemStack> storage;

    public ExtraItemStorageNetworkNode(Level level, BlockPos pos, ExtraItemStorageType type) {
        super(level, pos, null);
        this.type = type;
    }

    public static ResourceLocation getId(ExtraItemStorageType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ExtraItemStorageType.TIER_5 -> BLOCK_256K_ID;
            case ExtraItemStorageType.TIER_6 -> BLOCK_1024K_ID;
            case ExtraItemStorageType.TIER_7 -> BLOCK_4096K_ID;
            case ExtraItemStorageType.TIER_8 -> BLOCK_16384K_ID;
            case ExtraItemStorageType.TIER_9 -> BLOCK_65536K_ID;
            case ExtraItemStorageType.TIER_10 -> BLOCK_262144K_ID;
            case ExtraItemStorageType.TIER_11 -> BLOCK_1048576K_ID;
            case ExtraItemStorageType.TIER_12 -> BLOCK_INFINITE_ID;
        };
    }

    public ResourceLocation getId() {
        return ExtraItemStorageNetworkNode.getId(this.type);
    }

    public int getEnergyUsage() {
        return switch (this.type) {
            default -> throw new IncompatibleClassChangeError();
            case ExtraItemStorageType.TIER_5 -> (Integer)ModConfig.tier5usage.get();
            case ExtraItemStorageType.TIER_6 -> (Integer)ModConfig.tier6usage.get();
            case ExtraItemStorageType.TIER_7 -> (Integer)ModConfig.tier7usage.get();
            case ExtraItemStorageType.TIER_8 -> (Integer)ModConfig.tier8usage.get();
            case ExtraItemStorageType.TIER_9 -> (Integer)ModConfig.tier9usage.get();
            case ExtraItemStorageType.TIER_10 -> (Integer)ModConfig.tier10usage.get();
            case ExtraItemStorageType.TIER_11 -> (Integer)ModConfig.tier11usage.get();
            case ExtraItemStorageType.TIER_12 -> (Integer)ModConfig.tier12usage.get();
        };
    }

    public void addItemStorages(List<IStorage<ItemStack>> storages) {
        if (this.storage == null) {
            this.loadStorage(null);
        }
        storages.add((IStorage<ItemStack>)this.storage);
    }

    public void loadStorage(@Nullable Player owner) {
        IStorageDisk disk = API.instance().getStorageDiskManager((ServerLevel)this.level).get(this.getStorageId());
        if (disk == null) {
            disk = API.instance().createDefaultItemDisk((ServerLevel)this.level, this.type.getCapacity(), owner);
            API.instance().getStorageDiskManager((ServerLevel)this.level).set(this.getStorageId(), disk);
            API.instance().getStorageDiskManager((ServerLevel)this.level).markForSaving();
        }
        this.storage = new ItemStorageWrapperStorageDisk((StorageNetworkNode)this, disk);
    }

    public IStorageDisk<ItemStack> getStorage() {
        return this.storage;
    }

    public Component getTitle() {
        return new TranslatableComponent("block.extradisks." + this.type.getName() + "_storage_block");
    }

    public long getStored() {
        return (Long)ExtraItemStorageBlockEntity.STORED.getValue();
    }

    public long getCapacity() {
        return this.type.getCapacity();
    }
}

