/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino.mod.util;

import dev.latvian.mods.rhino.mod.util.RemapperException;
import dev.latvian.mods.rhino.mod.util.RemappingHelper;
import dev.latvian.mods.rhino.util.Remapper;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public class MinecraftRemapper
implements Remapper {
    private final Map<String, RemappedClass> classMap;
    private final Map<String, String> unmapClassMap;

    private static int readVarInt(InputStream stream) throws Exception {
        return RemappingHelper.readVarInt(stream);
    }

    private static String readUtf(InputStream stream) throws Exception {
        return RemappingHelper.readUtf(stream);
    }

    public static MinecraftRemapper load(InputStream stream, boolean debug) throws Exception {
        MinecraftRemapper m = new MinecraftRemapper(new HashMap<String, RemappedClass>(), new HashMap<String, String>());
        m.load0(stream, debug);
        return m;
    }

    private void load0(InputStream stream, boolean debug) throws Exception {
        int index;
        int i;
        if (stream.read() != 0) {
            throw new RemapperException("Invalid Minecraft Remapper file!");
        }
        int version = stream.read();
        if (version > 1) {
            throw new RemapperException("Invalid Minecraft Remapper file version!");
        }
        RemappingHelper.LOGGER.info("Loading mappings for " + MinecraftRemapper.readUtf(stream));
        int unmappedTypes = MinecraftRemapper.readVarInt(stream);
        RemappedType[] mappedTypes = new RemappedType[MinecraftRemapper.readVarInt(stream)];
        int arrayTypes = MinecraftRemapper.readVarInt(stream);
        RemappedType[] types = new RemappedType[unmappedTypes + mappedTypes.length + arrayTypes];
        if (debug) {
            RemappingHelper.LOGGER.info("Unmapped Types: " + unmappedTypes);
            RemappingHelper.LOGGER.info("Mapped Types: " + mappedTypes.length);
            RemappingHelper.LOGGER.info("Array Types: " + arrayTypes);
            RemappingHelper.LOGGER.info("Total Types: " + types.length);
        }
        for (i = 0; i < unmappedTypes; ++i) {
            index = MinecraftRemapper.readVarInt(stream);
            String name = MinecraftRemapper.readUtf(stream);
            types[index] = new RemappedType(new RemappedClass(name, ""), 0);
        }
        for (i = 0; i < mappedTypes.length; ++i) {
            index = MinecraftRemapper.readVarInt(stream);
            String unmappedName = MinecraftRemapper.readUtf(stream);
            String mmName = MinecraftRemapper.readUtf(stream);
            types[index] = new RemappedType(new RemappedClass(unmappedName.isEmpty() ? mmName : unmappedName, mmName), 0);
            mappedTypes[i] = types[index];
            this.classMap.put(types[index].parent.unmappedName, types[index].parent);
        }
        for (i = 0; i < arrayTypes; ++i) {
            index = MinecraftRemapper.readVarInt(stream);
            int type = MinecraftRemapper.readVarInt(stream);
            int array = MinecraftRemapper.readVarInt(stream);
            if (type < 0 || type >= types.length || types[type] == null) {
                throw new RemapperException("Invalid array index: " + type + "!");
            }
            types[index] = new RemappedType(types[type].parent, array);
        }
        Class[][] sig = new Class[MinecraftRemapper.readVarInt(stream)][];
        for (int i2 = 0; i2 < sig.length; ++i2) {
            sig[i2] = new Class[MinecraftRemapper.readVarInt(stream)];
            for (int j = 0; j < sig[i2].length; ++j) {
                sig[i2][j] = types[MinecraftRemapper.readVarInt(stream)].getRealClass(debug);
            }
        }
        for (RemappedType c : mappedTypes) {
            String mmName;
            String unmappedName;
            int i3;
            if (debug) {
                RemappingHelper.LOGGER.info(String.format("- %s -> %s", c.parent.unmappedName, c.parent.mmName));
            }
            int fields = MinecraftRemapper.readVarInt(stream);
            int arg0 = MinecraftRemapper.readVarInt(stream);
            int argN = MinecraftRemapper.readVarInt(stream);
            for (i3 = 0; i3 < fields; ++i3) {
                unmappedName = MinecraftRemapper.readUtf(stream);
                mmName = MinecraftRemapper.readUtf(stream);
                if (unmappedName.isEmpty() || mmName.isEmpty() || unmappedName.equals(mmName)) continue;
                if (c.parent.fields == null) {
                    c.parent.fields = new HashMap<String, String>(arg0 + argN);
                }
                c.parent.fields.put(unmappedName, mmName);
                if (!debug) continue;
                RemappingHelper.LOGGER.info(String.format("  %s -> %s", unmappedName, mmName));
            }
            for (i3 = 0; i3 < arg0; ++i3) {
                unmappedName = MinecraftRemapper.readUtf(stream);
                mmName = MinecraftRemapper.readUtf(stream);
                if (unmappedName.isEmpty() || mmName.isEmpty() || unmappedName.equals(mmName)) continue;
                if (c.parent.methods == null) {
                    c.parent.methods = new HashMap<RemappedMethodSignature, String>(arg0 + argN);
                }
                c.parent.methods.put(new RemappedMethodSignature(unmappedName, RemappedMethodSignature.EMPTY_CLASS_ARRAY), mmName);
                if (!debug) continue;
                RemappingHelper.LOGGER.info(String.format("  %s() -> %s", unmappedName, mmName));
            }
            for (i3 = 0; i3 < argN; ++i3) {
                unmappedName = MinecraftRemapper.readUtf(stream);
                mmName = MinecraftRemapper.readUtf(stream);
                if (unmappedName.isEmpty() || mmName.isEmpty() || unmappedName.equals(mmName)) continue;
                if (c.parent.methods == null) {
                    c.parent.methods = new HashMap<RemappedMethodSignature, String>(arg0 + argN);
                }
                int index2 = MinecraftRemapper.readVarInt(stream);
                RemappedMethodSignature key = new RemappedMethodSignature(unmappedName, sig[index2]);
                c.parent.methods.put(key, mmName);
                if (!debug) continue;
                RemappingHelper.LOGGER.info(String.format("  %s -> %s", key, mmName));
            }
        }
    }

    MinecraftRemapper(Map<String, RemappedClass> m1, Map<String, String> m2) {
        this.classMap = m1;
        this.unmapClassMap = m2;
    }

    @Override
    public String getMappedClass(Class<?> from) {
        RemappedClass c = this.classMap.get(from.getName());
        return c == null ? "" : c.mmName;
    }

    @Override
    public String getUnmappedClass(String mmName) {
        if (this.classMap.isEmpty()) {
            return "";
        }
        String s = this.unmapClassMap.get(mmName);
        if (s == null) {
            s = "";
            for (RemappedClass c : this.classMap.values()) {
                if (!c.mmName.equals(mmName)) continue;
                s = c.unmappedName;
            }
            this.unmapClassMap.put(mmName, s);
        }
        return s;
    }

    @Override
    public String getMappedField(Class<?> from, Field field) {
        if (from == null || from == Object.class || from.getPackageName().startsWith("java.")) {
            return "";
        }
        RemappedClass c = this.classMap.get(from.getName());
        return c == null || c.fields == null ? "" : c.fields.getOrDefault(field.getName(), "");
    }

    @Override
    public String getMappedMethod(Class<?> from, Method method) {
        if (from == null || from == Object.class || from.getPackageName().startsWith("java.")) {
            return "";
        }
        RemappedClass c = this.classMap.get(from.getName());
        return c == null || c.methods == null ? "" : c.methods.getOrDefault(new RemappedMethodSignature(method), "");
    }

    private static final class RemappedType {
        private final RemappedClass parent;
        private final int array;
        private Optional<Class<?>> realClass;

        private RemappedType(RemappedClass parent, int array) {
            this.parent = parent;
            this.array = array;
        }

        public String toString() {
            if (this.array == 0) {
                return this.parent.toString();
            }
            return this.parent.toString() + "[]".repeat(this.array);
        }

        @Nullable
        private Class<?> getRealClass(boolean debug) {
            if (this.realClass == null) {
                Optional<Class<?>> r = RemappingHelper.getClass(this.parent.unmappedName);
                if (!r.isPresent() && !this.parent.mmName.isEmpty()) {
                    r = RemappingHelper.getClass(this.parent.mmName);
                }
                if (r.isPresent()) {
                    this.realClass = this.array > 0 ? Optional.of(Array.newInstance(r.get(), this.array).getClass()) : r;
                } else {
                    this.realClass = Optional.empty();
                    if (debug) {
                        RemappingHelper.LOGGER.error("Class " + this.parent.unmappedName + " / " + this.parent.mmName + " not found!");
                    }
                }
            }
            return this.realClass.orElse(null);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (obj == this) return true;
            if (!(obj instanceof RemappedType)) return false;
            RemappedType type = (RemappedType)obj;
            if (type.parent != this.parent) return false;
            if (type.array != this.array) return false;
            return true;
        }

        public int hashCode() {
            return Objects.hash(this.parent, this.array);
        }
    }

    private static final class RemappedClass {
        private final String unmappedName;
        private final String mmName;
        private Map<String, String> fields;
        private Map<RemappedMethodSignature, String> methods;

        private RemappedClass(String unmappedName, String mmName) {
            this.unmappedName = unmappedName;
            this.mmName = mmName;
            this.fields = null;
            this.methods = null;
        }

        public String toString() {
            if (!this.mmName.isEmpty()) {
                return this.mmName + "[" + this.unmappedName + "]";
            }
            return this.unmappedName;
        }
    }

    private record RemappedMethodSignature(String name, Class<?>[] types) {
        public static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];

        public RemappedMethodSignature(Method m) {
            this(m.getName(), m.getParameterCount() == 0 ? EMPTY_CLASS_ARRAY : m.getParameterTypes());
        }

        @Override
        public int hashCode() {
            return this.name.hashCode() * 31 + Arrays.hashCode(this.types);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (obj == this) return true;
            if (!(obj instanceof RemappedMethodSignature)) return false;
            RemappedMethodSignature s = (RemappedMethodSignature)obj;
            if (!s.name.equals(this.name)) return false;
            if (!Arrays.equals(s.types, this.types)) return false;
            return true;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(this.name);
            sb.append('(');
            for (Class<?> t : this.types) {
                if (t == null) {
                    sb.append('X');
                    continue;
                }
                sb.append(t.descriptorString());
            }
            sb.append(')');
            return sb.toString();
        }
    }
}

