/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.misc.IPlayerMatcher;
import me.desht.pneumaticcraft.common.amadron.BiomeMatcher;
import me.desht.pneumaticcraft.common.amadron.DimensionMatcher;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.Validate;

public class PlayerFilter
implements Predicate<Player> {
    public static final PlayerFilter YES = new PlayerFilter(Op.YES, Collections.emptyMap());
    public static final PlayerFilter NO = new PlayerFilter(Op.NO, Collections.emptyMap());
    private static final Map<ResourceLocation, IPlayerMatcher.MatcherFactory<?>> matcherFactories = new ConcurrentHashMap();
    private final Map<ResourceLocation, IPlayerMatcher> matchers;
    private final Op op;

    private PlayerFilter(Op op, @Nonnull Map<ResourceLocation, IPlayerMatcher> matchers) {
        Validate.isTrue((op.isFake() || !matchers.isEmpty() ? 1 : 0) != 0, (String)"received empty matcher list!", (Object[])new Object[0]);
        this.op = op;
        this.matchers = ImmutableMap.copyOf(matchers);
    }

    public static PlayerFilter fromJson(JsonObject json) {
        for (String opStr : new String[]{"or", "and"}) {
            HashMap<ResourceLocation, IPlayerMatcher> matchers = new HashMap<ResourceLocation, IPlayerMatcher>();
            if (!json.has(opStr)) continue;
            Op op = Op.valueOf(opStr.toUpperCase(Locale.ROOT));
            JsonObject jsonSub = json.getAsJsonObject(opStr);
            for (Map.Entry entry : jsonSub.entrySet()) {
                ResourceLocation id = PlayerFilter.getId((String)entry.getKey());
                if (matcherFactories.containsKey(id)) {
                    matchers.put(id, (IPlayerMatcher)matcherFactories.get(id).fromJson((JsonElement)entry.getValue()));
                    continue;
                }
                throw new JsonSyntaxException("unknown matcher: " + id);
            }
            return new PlayerFilter(op, matchers);
        }
        throw new JsonSyntaxException("must provide one of 'and' or 'or'!");
    }

    public static PlayerFilter fromBytes(FriendlyByteBuf buffer) {
        Op op = (Op)buffer.m_130066_(Op.class);
        int nMatchers = buffer.m_130242_();
        HashMap<ResourceLocation, IPlayerMatcher> map = new HashMap<ResourceLocation, IPlayerMatcher>();
        for (int i = 0; i < nMatchers; ++i) {
            ResourceLocation id = buffer.m_130281_();
            map.put(id, (IPlayerMatcher)matcherFactories.get(id).fromBytes(buffer));
        }
        return new PlayerFilter(op, map);
    }

    public static void registerDefaultMatchers() {
        PlayerFilter.registerMatcher("dimensions", new DimensionMatcher.Factory());
        PlayerFilter.registerMatcher("biome_categories", new BiomeMatcher.Factory());
    }

    public static void registerMatcher(String id, IPlayerMatcher.MatcherFactory<?> matcher) {
        matcherFactories.put(PlayerFilter.getId(id), matcher);
    }

    public boolean isReal() {
        return !this.op.isFake();
    }

    public boolean matchAll() {
        return this.op == Op.AND;
    }

    private static ResourceLocation getId(String key) {
        return key.contains(":") ? new ResourceLocation(key) : PneumaticRegistry.RL(key);
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.op);
        buffer.m_130130_(this.matchers.size());
        this.matchers.forEach((id, matcher) -> {
            buffer.m_130085_(id);
            matcher.toBytes(buffer);
        });
    }

    public JsonObject toJson() {
        JsonObject sub = new JsonObject();
        this.matchers.forEach((id, matcher) -> sub.add(id.toString(), matcher.toJson()));
        JsonObject res = new JsonObject();
        res.add(this.op.name(), (JsonElement)sub);
        return res;
    }

    @Override
    public boolean test(Player player) {
        return switch (this.op) {
            default -> throw new IncompatibleClassChangeError();
            case Op.YES -> true;
            case Op.NO -> false;
            case Op.OR -> this.matchers.values().stream().anyMatch(matcher -> matcher.test(player));
            case Op.AND -> this.matchers.values().stream().allMatch(matcher -> matcher.test(player));
        };
    }

    public void getDescription(Player player, List<Component> tooltip) {
        if (this.isReal()) {
            this.matchers.values().forEach(matcher -> matcher.addDescription(player, tooltip));
        }
    }

    public String toString() {
        String delimiter = " " + this.op.toString() + " ";
        return "[" + this.matchers.values().stream().map(Object::toString).collect(Collectors.joining(delimiter)) + "]";
    }

    private static enum Op {
        YES,
        NO,
        AND,
        OR;


        public boolean isFake() {
            return this == YES || this == NO;
        }
    }
}

