/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Stream;
import me.desht.pneumaticcraft.common.block.entity.AerialInterfaceBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.ChargingStationBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.SecurityStationBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.UniversalSensorBlockEntity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.thread.EffectiveSide;

@Mod.EventBusSubscriber(modid="pneumaticcraft")
public class GlobalTileEntityCacheManager {
    private static final GlobalTileEntityCacheManager CLIENT_INSTANCE = new GlobalTileEntityCacheManager();
    private static final GlobalTileEntityCacheManager SERVER_INSTANCE = new GlobalTileEntityCacheManager();
    public final GlobalTileEntityCache<UniversalSensorBlockEntity> universalSensors = new GlobalTileEntityCache();
    public final GlobalTileEntityCache<ChargingStationBlockEntity> chargingStations = new GlobalTileEntityCache();
    public final GlobalTileEntityCache<SecurityStationBlockEntity> securityStations = new GlobalTileEntityCache();
    public final GlobalTileEntityCache<AerialInterfaceBlockEntity> aerialInterfaces = new GlobalTileEntityCache();

    public static GlobalTileEntityCacheManager getInstance() {
        return EffectiveSide.get() == LogicalSide.CLIENT ? CLIENT_INSTANCE : SERVER_INSTANCE;
    }

    @SubscribeEvent
    public static void onWorldUnloaded(WorldEvent.Unload event) {
        GlobalTileEntityCacheManager.getInstance().removeFromWorld(event.getWorld());
    }

    private void removeFromWorld(LevelAccessor world) {
        this.universalSensors.removeFromWorld(world);
        this.chargingStations.removeFromWorld(world);
        this.securityStations.removeFromWorld(world);
        this.aerialInterfaces.removeFromWorld(world);
    }

    public static class GlobalTileEntityCache<T extends BlockEntity>
    implements Iterable<T> {
        private final Set<T> tileEntities = Collections.newSetFromMap(new WeakHashMap());

        public void add(T te) {
            this.tileEntities.add(te);
        }

        public void remove(T te) {
            this.tileEntities.remove(te);
        }

        public void removeFromWorld(LevelAccessor world) {
            this.tileEntities.removeIf(te -> te.m_58904_() == world);
        }

        public Stream<T> stream() {
            return this.tileEntities.stream();
        }

        @Override
        public Iterator<T> iterator() {
            return this.tileEntities.iterator();
        }
    }
}

