/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.desht.pneumaticcraft.api.crafting.TemperatureRange;
import me.desht.pneumaticcraft.api.crafting.recipe.ThermoPlantRecipe;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTemperature;
import me.desht.pneumaticcraft.client.render.pressure_gauge.PressureGaugeRenderer2D;
import me.desht.pneumaticcraft.common.block.ThermopneumaticProcessingPlantBlock;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.thirdparty.jei.AbstractPNCCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.Helpers;
import me.desht.pneumaticcraft.common.thirdparty.jei.RecipeTypes;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class JEIThermopneumaticProcessingPlantCategory
extends AbstractPNCCategory<ThermoPlantRecipe> {
    private final ITickTimer tickTimer;
    private final Map<ResourceLocation, WidgetTemperature> tempWidgets = new HashMap<ResourceLocation, WidgetTemperature>();
    private final IDrawableAnimated progressBar;

    JEIThermopneumaticProcessingPlantCategory() {
        super(RecipeTypes.THERMO_PLANT, (Component)PneumaticCraftUtils.xlate(((ThermopneumaticProcessingPlantBlock)ModBlocks.THERMOPNEUMATIC_PROCESSING_PLANT.get()).m_7705_(), new Object[0]), (IDrawable)JEIThermopneumaticProcessingPlantCategory.guiHelper().createDrawable(Textures.GUI_JEI_THERMOPNEUMATIC_PROCESSING_PLANT, 0, 0, 166, 70), JEIThermopneumaticProcessingPlantCategory.guiHelper().createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.THERMOPNEUMATIC_PROCESSING_PLANT.get())));
        this.tickTimer = JEIThermopneumaticProcessingPlantCategory.guiHelper().createTickTimer(60, 60, false);
        IDrawableStatic d = JEIThermopneumaticProcessingPlantCategory.guiHelper().createDrawable(Textures.GUI_THERMOPNEUMATIC_PROCESSING_PLANT, 176, 0, 48, 30);
        this.progressBar = JEIThermopneumaticProcessingPlantCategory.guiHelper().createAnimatedDrawable(d, 60, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ThermoPlantRecipe recipe, IFocusGroup focuses) {
        int inH = 64;
        int outH = 64;
        int inputAmount = recipe.getInputFluid().getAmount();
        int outputAmount = recipe.getOutputFluid().getAmount();
        if (outputAmount > 0) {
            if (inputAmount > outputAmount) {
                outH = Math.min(64, outputAmount * 64 / inputAmount);
            } else {
                inH = Math.min(64, inputAmount * 64 / outputAmount);
            }
        }
        if (inputAmount > 0) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 8, 3 + (64 - inH)).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, recipe.getInputFluid().getFluidStacks())).setFluidRenderer(inputAmount, false, 16, inH).setOverlay(Helpers.makeTankOverlay(inH), 0, 0);
        }
        if (!recipe.getInputItem().m_43947_()) {
            builder.addSlot(RecipeIngredientRole.INPUT, 33, 3).addIngredients(recipe.getInputItem());
        }
        if (outputAmount > 0) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 74, 3 + (64 - outH)).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)recipe.getOutputFluid())).setFluidRenderer(outputAmount, false, 16, outH).setOverlay(Helpers.makeTankOverlay(outH), 0, 0);
        }
        if (!recipe.getOutputItem().m_41619_()) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 48, 51).addItemStack(recipe.getOutputItem());
        }
    }

    public void draw(ThermoPlantRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack matrixStack, double mouseX, double mouseY) {
        if (recipe.getRequiredPressure() != 0.0f) {
            float pressure = recipe.getRequiredPressure() * ((float)this.tickTimer.getValue() / (float)this.tickTimer.getMaxValue());
            PressureGaugeRenderer2D.drawPressureGauge(matrixStack, Minecraft.m_91087_().f_91062_, -1.0f, PressureTier.TIER_ONE_HALF.getCriticalPressure(), PressureTier.TIER_ONE_HALF.getDangerPressure(), recipe.getRequiredPressure(), pressure, 141, 42);
        }
        if (!recipe.getOperatingTemperature().isAny()) {
            WidgetTemperature w = this.tempWidgets.computeIfAbsent(recipe.m_6423_(), id -> WidgetTemperature.fromOperatingRange(100, 12, recipe.getOperatingTemperature()));
            w.setTemperature(w.getTotalRange().getMin() + (w.getTotalRange().getMax() - w.getTotalRange().getMin()) * this.tickTimer.getValue() / this.tickTimer.getMaxValue());
            w.m_6305_(matrixStack, (int)mouseX, (int)mouseY, 0.0f);
        }
        this.progressBar.draw(matrixStack, 25, 20);
    }

    public List<Component> getTooltipStrings(ThermoPlantRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ArrayList<Component> res = new ArrayList<Component>();
        WidgetTemperature w = this.tempWidgets.get(recipe.m_6423_());
        if (w != null && w.m_5953_(mouseX, mouseY)) {
            res.add(HeatUtil.formatHeatString(recipe.getOperatingTemperature().asString(TemperatureRange.TemperatureScale.CELSIUS)));
        }
        if (recipe.getRequiredPressure() > 0.0f && mouseX >= 116.0 && mouseY >= 22.0 && mouseX <= 156.0 && mouseY <= 62.0) {
            res.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.pressure", Float.valueOf(recipe.getRequiredPressure())));
            if (recipe.getAirUseMultiplier() != 1.0f) {
                res.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.pneumatic_armor.usage", new Object[0]).m_130946_(" x").m_130946_(String.format("%.1f", Float.valueOf(recipe.getAirUseMultiplier()))).m_130940_(ChatFormatting.GRAY));
            }
        }
        return res;
    }
}

